/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.openlineage.config.http;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MaxDuration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.NotNull;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class OpenLineageClientHttpTransportConfig {
    private URI url;
    private String endpoint;
    private Optional<String> apiKey = Optional.empty();
    private Duration timeout = new Duration(5000.0, TimeUnit.MILLISECONDS);
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> urlParams = new HashMap<String, String>();

    @NotNull
    public URI getUrl() {
        return this.url;
    }

    @Config(value="openlineage-event-listener.transport.url")
    @ConfigDescription(value="URL of receiving server. Explicitly set the scheme https:// to use symmetric encryption")
    public OpenLineageClientHttpTransportConfig setUrl(URI url) {
        this.url = url;
        return this;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    @Config(value="openlineage-event-listener.transport.endpoint")
    @ConfigDescription(value="Custom path for API receiving the events.")
    public OpenLineageClientHttpTransportConfig setEndpoint(String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Optional<String> getApiKey() {
        return this.apiKey;
    }

    @Config(value="openlineage-event-listener.transport.api-key")
    @ConfigDescription(value="API Key to use when authenticating against OpenLineage API")
    @ConfigSecuritySensitive
    public OpenLineageClientHttpTransportConfig setApiKey(String apiKey) {
        this.apiKey = Optional.ofNullable(apiKey);
        return this;
    }

    @MinDuration(value="1ms")
    @MaxDuration(value="1h")
    public @MinDuration(value="1ms") @MaxDuration(value="1h") Duration getTimeout() {
        return this.timeout;
    }

    @Config(value="openlineage-event-listener.transport.timeout")
    @ConfigDescription(value="Timeout when making HTTP Requests.")
    public OpenLineageClientHttpTransportConfig setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    @Config(value="openlineage-event-listener.transport.headers")
    @ConfigDescription(value="List of custom custom HTTP headers provided as: \"Header-Name-1: header value 1, Header-Value-2: header value 2, ...\" ")
    public OpenLineageClientHttpTransportConfig setHeaders(List<String> headers) {
        try {
            this.headers = headers.stream().collect(Collectors.toMap(keyValue -> keyValue.split(":", 2)[0], keyValue -> keyValue.split(":", 2)[1]));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Cannot parse http headers from property openlineage-event-listener.transport.headers; value provided was %s, expected format is \"Header-Name-1: header value 1, Header-Value-2: header value 2, ...\"", String.join((CharSequence)", ", headers)), e);
        }
        return this;
    }

    public Map<String, String> getUrlParams() {
        return this.urlParams;
    }

    @Config(value="openlineage-event-listener.transport.url-params")
    @ConfigDescription(value="List of custom custom url params provided as: \"url-param-1: url param value 1, ...\" ")
    public OpenLineageClientHttpTransportConfig setUrlParams(List<String> urlParas) {
        try {
            this.urlParams = urlParas.stream().collect(Collectors.toMap(kvs -> kvs.split(":", 2)[0], kvs -> kvs.split(":", 2)[1]));
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(String.format("Cannot parse url params from property openlineage-event-listener.transport.url-params; value provided was %s, expected format is \"url-param-1: url param value 1, ...\"", String.join((CharSequence)", ", urlParas)), e);
        }
        return this;
    }
}

