/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.transports;

import io.openlineage.client.OpenLineage;
import io.openlineage.client.OpenLineageClientException;
import io.openlineage.client.OpenLineageClientUtils;
import io.openlineage.client.transports.ApiKeyTokenProvider;
import io.openlineage.client.transports.HttpConfig;
import io.openlineage.client.transports.HttpSslContextConfig;
import io.openlineage.client.transports.HttpTransportResponseException;
import io.openlineage.client.transports.TokenProvider;
import io.openlineage.client.transports.Transport;
import io.openlineage.client.transports.TransportConfig;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.GzipCompressingEntity;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.net.URIBuilder;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HttpTransport
extends Transport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpTransport.class);
    private static final String API_V1 = "/api/v1";
    private final CloseableHttpClient http;
    private final URI uri;
    @Nullable
    private final TokenProvider tokenProvider;
    private final Map<String, String> headers;
    @Nullable
    private final HttpConfig.Compression compression;

    public HttpTransport(@NonNull HttpConfig httpConfig) {
        this(HttpTransport.withTimeout(httpConfig), httpConfig);
        if (httpConfig == null) {
            throw new NullPointerException("httpConfig is marked non-null but is null");
        }
    }

    private static CloseableHttpClient withTimeout(HttpConfig httpConfig) {
        int timeoutMs = httpConfig.getTimeoutInMillis() != null ? httpConfig.getTimeoutInMillis() : 5000;
        Timeout timeout = Timeout.ofMilliseconds((long)timeoutMs);
        PoolingHttpClientConnectionManagerBuilder connectionManagerBuilder = PoolingHttpClientConnectionManagerBuilder.create().setDefaultSocketConfig(SocketConfig.custom().setSoTimeout(timeout).build()).setPoolConcurrencyPolicy(PoolConcurrencyPolicy.STRICT).setConnPoolPolicy(PoolReusePolicy.LIFO).setDefaultConnectionConfig(ConnectionConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setTimeToLive((TimeValue)timeout).build());
        if (httpConfig.getSslContextConfig() != null) {
            SSLContext sslContext = HttpTransport.getSSLContext(httpConfig.getSslContextConfig());
            if (sslContext != null) {
                log.info("SSLContext set up successfully");
                DefaultClientTlsStrategy tlsStrategy = new DefaultClientTlsStrategy(sslContext);
                connectionManagerBuilder.setTlsSocketStrategy((TlsSocketStrategy)tlsStrategy);
            } else {
                log.warn("SSLContext configured but unable to set up");
            }
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(timeout).setResponseTimeout(timeout).build();
        return HttpClientBuilder.create().setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManagerBuilder.build()).setDefaultRequestConfig(requestConfig).build();
    }

    private static SSLContext getSSLContext(HttpSslContextConfig httpSslContextConfig) {
        if (httpSslContextConfig == null || httpSslContextConfig.getKeyStoreType() == null || httpSslContextConfig.getKeyStorePath() == null) {
            return null;
        }
        try {
            return SSLContexts.custom().setKeyStoreType(httpSslContextConfig.getKeyStoreType()).loadKeyMaterial(new File(httpSslContextConfig.getKeyStorePath()), httpSslContextConfig.getStorePassword().toCharArray(), httpSslContextConfig.getKeyPassword().toCharArray()).build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            log.error("Error creating SSLContext: {}", (Object)e.getMessage());
            return null;
        }
    }

    public HttpTransport(@NonNull CloseableHttpClient httpClient, @NonNull HttpConfig httpConfig) {
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        if (httpConfig == null) {
            throw new NullPointerException("httpConfig is marked non-null but is null");
        }
        this.http = httpClient;
        try {
            this.uri = this.getUri(httpConfig);
        }
        catch (URISyntaxException e) {
            throw new OpenLineageClientException(e);
        }
        this.tokenProvider = httpConfig.getAuth();
        this.headers = httpConfig.getHeaders() != null ? httpConfig.getHeaders() : new HashMap<String, String>();
        this.compression = httpConfig.getCompression();
    }

    private URI getUri(HttpConfig httpConfig) throws URISyntaxException {
        URI url = httpConfig.getUrl();
        if (url == null) {
            throw new OpenLineageClientException("url can't be null, try setting transport.url in config");
        }
        URIBuilder builder = new URIBuilder(url);
        if (StringUtils.isNotBlank((CharSequence)url.getPath())) {
            if (StringUtils.isNotBlank((CharSequence)httpConfig.getEndpoint())) {
                throw new OpenLineageClientException("You can't pass both uri and endpoint parameters.");
            }
        } else {
            String endpoint = StringUtils.isNotBlank((CharSequence)httpConfig.getEndpoint()) ? httpConfig.getEndpoint() : "/api/v1/lineage";
            builder.setPath(endpoint);
        }
        if (httpConfig.getUrlParams() != null) {
            httpConfig.getUrlParams().entrySet().stream().forEach(e -> builder.addParameter(((String)e.getKey()).replace("url.param.", ""), (String)e.getValue()));
        }
        return builder.build();
    }

    @Override
    public void emit(@NonNull OpenLineage.RunEvent runEvent) {
        if (runEvent == null) {
            throw new NullPointerException("runEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(runEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.DatasetEvent datasetEvent) {
        if (datasetEvent == null) {
            throw new NullPointerException("datasetEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(datasetEvent));
    }

    @Override
    public void emit(@NonNull OpenLineage.JobEvent jobEvent) {
        if (jobEvent == null) {
            throw new NullPointerException("jobEvent is marked non-null but is null");
        }
        this.emit(OpenLineageClientUtils.toJson(jobEvent));
    }

    private void emit(String eventAsJson) {
        log.debug("POST event on URL {}", (Object)this.uri);
        try {
            ClassicRequestBuilder request = ClassicRequestBuilder.post((URI)this.uri);
            this.setHeaders(request);
            this.setBody(request, eventAsJson);
            this.http.execute(request.build(), response -> {
                this.throwOnHttpError(response);
                return null;
            });
        }
        catch (IOException e) {
            throw new OpenLineageClientException(e);
        }
    }

    private void setBody(ClassicRequestBuilder request, String body) {
        StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
        if (this.compression == HttpConfig.Compression.GZIP) {
            entity = new GzipCompressingEntity((HttpEntity)entity);
        }
        request.setEntity((HttpEntity)entity);
    }

    private void setHeaders(ClassicRequestBuilder request) {
        this.headers.forEach((key, value) -> request.setHeader(key, value));
        request.setHeader("Accept", ContentType.APPLICATION_JSON.toString());
        request.setHeader("Content-Type", ContentType.APPLICATION_JSON.toString());
        if (this.tokenProvider != null) {
            request.addHeader("Authorization", this.tokenProvider.getToken());
        }
    }

    private void throwOnHttpError(@NonNull ClassicHttpResponse response) throws IOException, ParseException {
        if (response == null) {
            throw new NullPointerException("response is marked non-null but is null");
        }
        int code = response.getCode();
        HttpEntity entity = response.getEntity();
        String body = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
        EntityUtils.consume((HttpEntity)entity);
        if (code >= 400 && code < 600) {
            throw new HttpTransportResponseException(code, body);
        }
    }

    @Override
    public void close() throws IOException {
        this.http.close();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Deprecated
    public static final class Builder {
        private static final URI DEFAULT_OPENLINEAGE_URI = OpenLineageClientUtils.toUri("http://localhost:8080");
        @Nullable
        private CloseableHttpClient httpClient;
        private final HttpConfig httpConfig = new HttpConfig();

        private Builder() {
            this.httpConfig.setUrl(DEFAULT_OPENLINEAGE_URI);
        }

        public Builder uri(@NonNull String urlAsString) {
            if (urlAsString == null) {
                throw new NullPointerException("urlAsString is marked non-null but is null");
            }
            return this.uri(OpenLineageClientUtils.toUri(urlAsString));
        }

        public Builder uri(@NonNull String urlAsString, @NonNull Map<String, String> queryParams) {
            if (urlAsString == null) {
                throw new NullPointerException("urlAsString is marked non-null but is null");
            }
            if (queryParams == null) {
                throw new NullPointerException("queryParams is marked non-null but is null");
            }
            return this.uri(OpenLineageClientUtils.toUri(urlAsString), queryParams);
        }

        public Builder uri(@NonNull URI uri) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            return this.uri(uri, Collections.emptyMap());
        }

        public Builder uri(@NonNull URI uri, @NonNull Map<String, String> queryParams) {
            if (uri == null) {
                throw new NullPointerException("uri is marked non-null but is null");
            }
            if (queryParams == null) {
                throw new NullPointerException("queryParams is marked non-null but is null");
            }
            try {
                URIBuilder builder = new URIBuilder(uri);
                queryParams.forEach((arg_0, arg_1) -> ((URIBuilder)builder).addParameter(arg_0, arg_1));
                this.httpConfig.setUrl(builder.build());
            }
            catch (URISyntaxException e) {
                throw new OpenLineageClientException(e);
            }
            return this;
        }

        public Builder http(@NonNull CloseableHttpClient httpClient) {
            if (httpClient == null) {
                throw new NullPointerException("httpClient is marked non-null but is null");
            }
            this.httpClient = httpClient;
            return this;
        }

        public Builder tokenProvider(@Nullable TokenProvider tokenProvider) {
            this.httpConfig.setAuth(tokenProvider);
            return this;
        }

        public Builder apiKey(@Nullable String apiKey) {
            ApiKeyTokenProvider apiKeyTokenProvider = new ApiKeyTokenProvider();
            apiKeyTokenProvider.setApiKey(apiKey);
            return this.tokenProvider(apiKeyTokenProvider);
        }

        public HttpTransport build() {
            if (this.httpClient != null) {
                return new HttpTransport(this.httpClient, this.httpConfig);
            }
            return new HttpTransport(this.httpConfig);
        }

        @Generated
        public HttpConfig mergeWithNonNull(HttpConfig other) {
            return this.httpConfig.mergeWithNonNull(other);
        }

        @Generated
        public URI getUrl() {
            return this.httpConfig.getUrl();
        }

        @Generated
        public void setUrl(URI url) {
            this.httpConfig.setUrl(url);
        }

        @Generated
        public String getEndpoint() {
            return this.httpConfig.getEndpoint();
        }

        @Generated
        public void setEndpoint(String endpoint) {
            this.httpConfig.setEndpoint(endpoint);
        }

        @Generated
        public Integer getTimeoutInMillis() {
            return this.httpConfig.getTimeoutInMillis();
        }

        @Generated
        public void setTimeoutInMillis(Integer timeoutInMillis) {
            this.httpConfig.setTimeoutInMillis(timeoutInMillis);
        }

        @Generated
        public TokenProvider getAuth() {
            return this.httpConfig.getAuth();
        }

        @Generated
        public void setAuth(TokenProvider auth) {
            this.httpConfig.setAuth(auth);
        }

        @Generated
        public Map<String, String> getUrlParams() {
            return this.httpConfig.getUrlParams();
        }

        @Generated
        public void setUrlParams(Map<String, String> urlParams) {
            this.httpConfig.setUrlParams(urlParams);
        }

        @Generated
        public Map<String, String> getHeaders() {
            return this.httpConfig.getHeaders();
        }

        @Generated
        public void setHeaders(Map<String, String> headers) {
            this.httpConfig.setHeaders(headers);
        }

        @Generated
        public HttpConfig.Compression getCompression() {
            return this.httpConfig.getCompression();
        }

        @Generated
        public void setCompression(HttpConfig.Compression compression) {
            this.httpConfig.setCompression(compression);
        }

        @Generated
        public HttpSslContextConfig getSslContextConfig() {
            return this.httpConfig.getSslContextConfig();
        }

        @Generated
        public void setSslContextConfig(HttpSslContextConfig sslContextConfig) {
            this.httpConfig.setSslContextConfig(sslContextConfig);
        }

        @Generated
        public String getName() {
            return this.httpConfig.getName();
        }

        @Generated
        public void setName(String name) {
            this.httpConfig.setName(name);
        }

        @Generated
        public int compareTo(TransportConfig o) {
            return this.httpConfig.compareTo(o);
        }

        @Generated
        public HttpConfig mergeWith(HttpConfig t) {
            return this.httpConfig.mergeWith(t);
        }

        @Generated
        public Map mergePropertyWith(Map base, Map overwrite) {
            return this.httpConfig.mergePropertyWith(base, overwrite);
        }

        @Generated
        public <T> T mergePropertyWith(T base, T overwrite) {
            return this.httpConfig.mergePropertyWith(base, overwrite);
        }

        @Generated
        public <T> T mergeWithDefaultValue(T base, T overwrite, T def) {
            return this.httpConfig.mergeWithDefaultValue(base, overwrite, def);
        }
    }
}

