/*
 * Decompiled with CFR 0.152.
 */
package io.openlineage.client.utils;

import java.security.MessageDigest;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.UUID;

public class UUIDUtils {
    public static UUID generateNewUUID() {
        return UUIDUtils.generateNewUUID(Instant.now());
    }

    public static UUID generateNewUUID(Instant instant) {
        long time = instant.toEpochMilli();
        SecureRandom random = new SecureRandom();
        long msb = time << 16 | random.nextLong() & 0xFFFL | 0x7000L;
        long lsb = random.nextLong() & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(msb, lsb);
    }

    public static UUID generateStaticUUID(Instant instant, byte[] data) {
        int i;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] hash = md.digest(data);
        long hasbMsb = 0L;
        long hasbLsb = 0L;
        for (i = 0; i < 8; ++i) {
            hasbMsb = hasbMsb << 8 | (long)(hash[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            hasbLsb = hasbLsb << 8 | (long)(hash[i] & 0xFF);
        }
        long time = instant.toEpochMilli();
        long uuidMsb = time << 16 | hasbMsb & 0xFFFL | 0x7000L;
        long uuidLsb = hasbLsb & 0x3FFFFFFFFFFFFFFFL | Long.MIN_VALUE;
        return new UUID(uuidMsb, uuidLsb);
    }
}

