/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.configuration.validation.FileExists;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.File;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class OpenSearchConfig {
    private List<String> hosts;
    private int port = 9200;
    private String defaultSchema = "default";
    private int scrollSize = 1000;
    private Duration scrollTimeout = new Duration(1.0, TimeUnit.MINUTES);
    private Duration requestTimeout = new Duration(10.0, TimeUnit.SECONDS);
    private Duration connectTimeout = new Duration(1.0, TimeUnit.SECONDS);
    private Duration backoffInitDelay = new Duration(500.0, TimeUnit.MILLISECONDS);
    private Duration backoffMaxDelay = new Duration(20.0, TimeUnit.SECONDS);
    private Duration maxRetryTime = new Duration(30.0, TimeUnit.SECONDS);
    private Duration nodeRefreshInterval = new Duration(1.0, TimeUnit.MINUTES);
    private int maxHttpConnections = 25;
    private int httpThreadCount = Runtime.getRuntime().availableProcessors();
    private boolean tlsEnabled;
    private File keystorePath;
    private File trustStorePath;
    private String keystorePassword;
    private String truststorePassword;
    private boolean ignorePublishAddress;
    private boolean verifyHostnames = true;
    private Security security;

    @NotNull
    public List<String> getHosts() {
        return this.hosts;
    }

    @Config(value="opensearch.host")
    public OpenSearchConfig setHosts(List<String> hosts) {
        this.hosts = hosts;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    @Config(value="opensearch.port")
    public OpenSearchConfig setPort(int port) {
        this.port = port;
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="opensearch.default-schema-name")
    @ConfigDescription(value="Default schema name to use")
    public OpenSearchConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @NotNull
    @Min(value=1L)
    public @NotNull @Min(value=1L) int getScrollSize() {
        return this.scrollSize;
    }

    @Config(value="opensearch.scroll-size")
    @ConfigDescription(value="Scroll batch size")
    public OpenSearchConfig setScrollSize(int scrollSize) {
        this.scrollSize = scrollSize;
        return this;
    }

    @NotNull
    public Duration getScrollTimeout() {
        return this.scrollTimeout;
    }

    @Config(value="opensearch.scroll-timeout")
    @ConfigDescription(value="Scroll timeout")
    public OpenSearchConfig setScrollTimeout(Duration scrollTimeout) {
        this.scrollTimeout = scrollTimeout;
        return this;
    }

    @NotNull
    public Duration getRequestTimeout() {
        return this.requestTimeout;
    }

    @Config(value="opensearch.request-timeout")
    @ConfigDescription(value="OpenSearch request timeout")
    public OpenSearchConfig setRequestTimeout(Duration requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    @NotNull
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    @Config(value="opensearch.connect-timeout")
    @ConfigDescription(value="OpenSearch connect timeout")
    public OpenSearchConfig setConnectTimeout(Duration timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    @NotNull
    public Duration getBackoffInitDelay() {
        return this.backoffInitDelay;
    }

    @Config(value="opensearch.backoff-init-delay")
    @ConfigDescription(value="Initial delay to wait between backpressure retries")
    public OpenSearchConfig setBackoffInitDelay(Duration backoffInitDelay) {
        this.backoffInitDelay = backoffInitDelay;
        return this;
    }

    @NotNull
    public Duration getBackoffMaxDelay() {
        return this.backoffMaxDelay;
    }

    @Config(value="opensearch.backoff-max-delay")
    @ConfigDescription(value="Maximum delay to wait between backpressure retries")
    public OpenSearchConfig setBackoffMaxDelay(Duration backoffMaxDelay) {
        this.backoffMaxDelay = backoffMaxDelay;
        return this;
    }

    @NotNull
    public Duration getMaxRetryTime() {
        return this.maxRetryTime;
    }

    @Config(value="opensearch.max-retry-time")
    @ConfigDescription(value="Maximum timeout in case of multiple retries")
    public OpenSearchConfig setMaxRetryTime(Duration maxRetryTime) {
        this.maxRetryTime = maxRetryTime;
        return this;
    }

    @NotNull
    @MinDuration(value="1ms")
    public @NotNull @MinDuration(value="1ms") Duration getNodeRefreshInterval() {
        return this.nodeRefreshInterval;
    }

    @Config(value="opensearch.node-refresh-interval")
    @ConfigDescription(value="How often to refresh the list of available nodes in the OpenSearch cluster")
    public OpenSearchConfig setNodeRefreshInterval(Duration nodeRefreshInterval) {
        this.nodeRefreshInterval = nodeRefreshInterval;
        return this;
    }

    @Config(value="opensearch.max-http-connections")
    @ConfigDescription(value="Maximum number of persistent HTTP connections to OpenSearch cluster")
    public OpenSearchConfig setMaxHttpConnections(int size) {
        this.maxHttpConnections = size;
        return this;
    }

    @NotNull
    public int getMaxHttpConnections() {
        return this.maxHttpConnections;
    }

    @Config(value="opensearch.http-thread-count")
    @ConfigDescription(value="Number of threads handling HTTP connections to OpenSearch cluster")
    public OpenSearchConfig setHttpThreadCount(int count) {
        this.httpThreadCount = count;
        return this;
    }

    @NotNull
    public int getHttpThreadCount() {
        return this.httpThreadCount;
    }

    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Config(value="opensearch.tls.enabled")
    public OpenSearchConfig setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
        return this;
    }

    public Optional<@FileExists File> getKeystorePath() {
        return Optional.ofNullable(this.keystorePath);
    }

    @Config(value="opensearch.tls.keystore-path")
    public OpenSearchConfig setKeystorePath(File path) {
        this.keystorePath = path;
        return this;
    }

    public Optional<String> getKeystorePassword() {
        return Optional.ofNullable(this.keystorePassword);
    }

    @Config(value="opensearch.tls.keystore-password")
    @ConfigSecuritySensitive
    public OpenSearchConfig setKeystorePassword(String password) {
        this.keystorePassword = password;
        return this;
    }

    public Optional<@FileExists File> getTrustStorePath() {
        return Optional.ofNullable(this.trustStorePath);
    }

    @Config(value="opensearch.tls.truststore-path")
    public OpenSearchConfig setTrustStorePath(File path) {
        this.trustStorePath = path;
        return this;
    }

    public Optional<String> getTruststorePassword() {
        return Optional.ofNullable(this.truststorePassword);
    }

    @Config(value="opensearch.tls.truststore-password")
    @ConfigSecuritySensitive
    public OpenSearchConfig setTruststorePassword(String password) {
        this.truststorePassword = password;
        return this;
    }

    public boolean isVerifyHostnames() {
        return this.verifyHostnames;
    }

    @Config(value="opensearch.tls.verify-hostnames")
    public OpenSearchConfig setVerifyHostnames(boolean verify) {
        this.verifyHostnames = verify;
        return this;
    }

    public boolean isIgnorePublishAddress() {
        return this.ignorePublishAddress;
    }

    @Config(value="opensearch.ignore-publish-address")
    public OpenSearchConfig setIgnorePublishAddress(boolean ignorePublishAddress) {
        this.ignorePublishAddress = ignorePublishAddress;
        return this;
    }

    @NotNull
    public Optional<Security> getSecurity() {
        return Optional.ofNullable(this.security);
    }

    @Config(value="opensearch.security")
    public OpenSearchConfig setSecurity(Security security) {
        this.security = security;
        return this;
    }

    public static enum Security {
        AWS,
        PASSWORD;

    }
}

