/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import com.google.inject.multibindings.OptionalBinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConditionalModule;
import io.airlift.configuration.ConfigBinder;
import io.trino.plugin.opensearch.AwsSecurityConfig;
import io.trino.plugin.opensearch.NodesSystemTable;
import io.trino.plugin.opensearch.OpenSearchConfig;
import io.trino.plugin.opensearch.OpenSearchConnector;
import io.trino.plugin.opensearch.OpenSearchMetadata;
import io.trino.plugin.opensearch.OpenSearchPageSourceProvider;
import io.trino.plugin.opensearch.OpenSearchSplitManager;
import io.trino.plugin.opensearch.PasswordConfig;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.plugin.opensearch.ptf.RawQuery;
import io.trino.spi.function.table.ConnectorTableFunction;
import java.util.function.Predicate;
import org.weakref.jmx.guice.ExportBinder;

public class OpenSearchConnectorModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        binder.bind(OpenSearchConnector.class).in(Scopes.SINGLETON);
        binder.bind(OpenSearchMetadata.class).in(Scopes.SINGLETON);
        binder.bind(OpenSearchSplitManager.class).in(Scopes.SINGLETON);
        binder.bind(OpenSearchPageSourceProvider.class).in(Scopes.SINGLETON);
        binder.bind(OpenSearchClient.class).in(Scopes.SINGLETON);
        binder.bind(NodesSystemTable.class).in(Scopes.SINGLETON);
        ExportBinder.newExporter((Binder)binder).export(OpenSearchClient.class).withGeneratedName();
        ConfigBinder.configBinder((Binder)binder).bindConfig(OpenSearchConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, AwsSecurityConfig.class);
        OptionalBinder.newOptionalBinder((Binder)binder, PasswordConfig.class);
        Multibinder.newSetBinder((Binder)binder, ConnectorTableFunction.class).addBinding().toProvider(RawQuery.class).in(Scopes.SINGLETON);
        this.install(ConditionalModule.conditionalModule(OpenSearchConfig.class, config -> config.getSecurity().filter(Predicate.isEqual((Object)OpenSearchConfig.Security.AWS)).isPresent(), conditionalBinder -> ConfigBinder.configBinder((Binder)conditionalBinder).bindConfig(AwsSecurityConfig.class)));
        this.install(ConditionalModule.conditionalModule(OpenSearchConfig.class, config -> config.getSecurity().filter(Predicate.isEqual((Object)OpenSearchConfig.Security.PASSWORD)).isPresent(), conditionalBinder -> ConfigBinder.configBinder((Binder)conditionalBinder).bindConfig(PasswordConfig.class)));
    }
}

