/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceUtf8;
import io.trino.plugin.base.expression.ConnectorExpressions;
import io.trino.plugin.opensearch.BuiltinColumns;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.OpenSearchColumnHandle;
import io.trino.plugin.opensearch.OpenSearchConfig;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.plugin.opensearch.client.IndexMetadata;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.plugin.opensearch.decoders.ArrayDecoder;
import io.trino.plugin.opensearch.decoders.BigintDecoder;
import io.trino.plugin.opensearch.decoders.BooleanDecoder;
import io.trino.plugin.opensearch.decoders.DoubleDecoder;
import io.trino.plugin.opensearch.decoders.IntegerDecoder;
import io.trino.plugin.opensearch.decoders.IpAddressDecoder;
import io.trino.plugin.opensearch.decoders.RawJsonDecoder;
import io.trino.plugin.opensearch.decoders.RealDecoder;
import io.trino.plugin.opensearch.decoders.RowDecoder;
import io.trino.plugin.opensearch.decoders.SmallintDecoder;
import io.trino.plugin.opensearch.decoders.TimestampDecoder;
import io.trino.plugin.opensearch.decoders.TinyintDecoder;
import io.trino.plugin.opensearch.decoders.VarbinaryDecoder;
import io.trino.plugin.opensearch.decoders.VarcharDecoder;
import io.trino.plugin.opensearch.ptf.RawQuery;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.LimitApplicationResult;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableColumnsMetadata;
import io.trino.spi.connector.TableFunctionApplicationResult;
import io.trino.spi.expression.Call;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Constant;
import io.trino.spi.expression.StandardFunctions;
import io.trino.spi.expression.Variable;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.opensearch.client.ResponseException;

public class OpenSearchMetadata
implements ConnectorMetadata {
    private static final String PASSTHROUGH_QUERY_RESULT_COLUMN_NAME = "result";
    private static final ColumnMetadata PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA = ColumnMetadata.builder().setName("result").setType((Type)VarcharType.VARCHAR).setNullable(true).setHidden(false).build();
    private static final Map<String, ColumnHandle> PASSTHROUGH_QUERY_COLUMNS = ImmutableMap.of((Object)"result", (Object)new OpenSearchColumnHandle("result", (Type)VarcharType.VARCHAR, new VarcharDecoder.Descriptor("result"), false));
    private static final Set<Integer> REGEXP_RESERVED_CHARACTERS = (Set)IntStream.of(46, 63, 43, 42, 124, 123, 125, 91, 93, 40, 41, 34, 35, 64, 38, 60, 62, 126).boxed().collect(ImmutableSet.toImmutableSet());
    private final Type ipAddressType;
    private final OpenSearchClient client;
    private final String schemaName;

    @Inject
    public OpenSearchMetadata(TypeManager typeManager, OpenSearchClient client, OpenSearchConfig config) {
        this.ipAddressType = typeManager.getType(new TypeSignature("ipaddress", new TypeSignatureParameter[0]));
        this.client = Objects.requireNonNull(client, "client is null");
        this.schemaName = config.getDefaultSchema();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)this.schemaName);
    }

    public OpenSearchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (tableName.getSchemaName().equals(this.schemaName) && this.client.indexExists(tableName.getTableName()) && !this.client.getIndexMetadata(tableName.getTableName()).getSchema().getFields().isEmpty()) {
            return new OpenSearchTableHandle(OpenSearchTableHandle.Type.SCAN, this.schemaName, tableName.getTableName(), Optional.empty());
        }
        return null;
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle table) {
        OpenSearchTableHandle handle = (OpenSearchTableHandle)table;
        if (OpenSearchMetadata.isPassthroughQuery(handle)) {
            return new ConnectorTableMetadata(new SchemaTableName(handle.getSchema(), handle.getIndex()), (List)ImmutableList.of((Object)PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA));
        }
        return this.getTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private ConnectorTableMetadata getTableMetadata(String schemaName, String tableName) {
        InternalTableMetadata internalTableMetadata = this.makeInternalTableMetadata(schemaName, tableName);
        return new ConnectorTableMetadata(new SchemaTableName(schemaName, tableName), internalTableMetadata.getColumnMetadata());
    }

    private InternalTableMetadata makeInternalTableMetadata(ConnectorTableHandle table) {
        OpenSearchTableHandle handle = (OpenSearchTableHandle)table;
        return this.makeInternalTableMetadata(handle.getSchema(), handle.getIndex());
    }

    private InternalTableMetadata makeInternalTableMetadata(String schema, String tableName) {
        IndexMetadata metadata = this.client.getIndexMetadata(tableName);
        List<IndexMetadata.Field> fields = this.getColumnFields(metadata);
        return new InternalTableMetadata(new SchemaTableName(schema, tableName), this.makeColumnMetadata(fields), this.makeColumnHandles(fields));
    }

    private List<IndexMetadata.Field> getColumnFields(IndexMetadata metadata) {
        Map<String, Long> counts = metadata.getSchema().getFields().stream().collect(Collectors.groupingBy(f -> f.getName().toLowerCase(Locale.ENGLISH), Collectors.counting()));
        return (List)metadata.getSchema().getFields().stream().filter(field -> this.toTrino((IndexMetadata.Field)field) != null && (Long)counts.get(field.getName().toLowerCase(Locale.ENGLISH)) <= 1L).collect(ImmutableList.toImmutableList());
    }

    private List<ColumnMetadata> makeColumnMetadata(List<IndexMetadata.Field> fields) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.add((Object)builtinColumn.getMetadata());
        }
        for (IndexMetadata.Field field : fields) {
            result.add((Object)ColumnMetadata.builder().setName(field.getName()).setType(this.toTrino(field).getType()).build());
        }
        return result.build();
    }

    private Map<String, ColumnHandle> makeColumnHandles(List<IndexMetadata.Field> fields) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (BuiltinColumns builtinColumn : BuiltinColumns.values()) {
            result.put((Object)builtinColumn.getName(), (Object)builtinColumn.getColumnHandle());
        }
        for (IndexMetadata.Field field : fields) {
            TypeAndDecoder converted = this.toTrino(field);
            result.put((Object)field.getName(), (Object)new OpenSearchColumnHandle(field.getName(), converted.getType(), converted.getDecoderDescriptor(), OpenSearchMetadata.supportsPredicates(field.getType())));
        }
        return result.buildOrThrow();
    }

    private static boolean supportsPredicates(IndexMetadata.Type type) {
        if (type instanceof IndexMetadata.DateTimeType) {
            return true;
        }
        if (type instanceof IndexMetadata.PrimitiveType) {
            switch (((IndexMetadata.PrimitiveType)type).getName().toLowerCase(Locale.ENGLISH)) {
                case "boolean": 
                case "byte": 
                case "short": 
                case "integer": 
                case "long": 
                case "double": 
                case "float": 
                case "keyword": {
                    return true;
                }
            }
        }
        return false;
    }

    private TypeAndDecoder toTrino(IndexMetadata.Field field) {
        return this.toTrino("", field);
    }

    private TypeAndDecoder toTrino(String prefix, IndexMetadata.Field field) {
        String path = OpenSearchMetadata.appendPath(prefix, field.getName());
        Preconditions.checkArgument((!field.asRawJson() || !field.isArray() ? 1 : 0) != 0, (Object)String.format("A column, (%s) cannot be declared as a Trino array and also be rendered as json.", path));
        if (field.asRawJson()) {
            return new TypeAndDecoder((Type)VarcharType.VARCHAR, new RawJsonDecoder.Descriptor(path));
        }
        if (field.isArray()) {
            TypeAndDecoder element = this.toTrino(path, OpenSearchMetadata.elementField(field));
            return new TypeAndDecoder((Type)new ArrayType(element.getType()), new ArrayDecoder.Descriptor(element.getDecoderDescriptor()));
        }
        IndexMetadata.Type type = field.getType();
        if (type instanceof IndexMetadata.PrimitiveType) {
            IndexMetadata.PrimitiveType primitiveType = (IndexMetadata.PrimitiveType)type;
            switch (primitiveType.getName()) {
                case "float": {
                    return new TypeAndDecoder((Type)RealType.REAL, new RealDecoder.Descriptor(path));
                }
                case "double": {
                    return new TypeAndDecoder((Type)DoubleType.DOUBLE, new DoubleDecoder.Descriptor(path));
                }
                case "byte": {
                    return new TypeAndDecoder((Type)TinyintType.TINYINT, new TinyintDecoder.Descriptor(path));
                }
                case "short": {
                    return new TypeAndDecoder((Type)SmallintType.SMALLINT, new SmallintDecoder.Descriptor(path));
                }
                case "integer": {
                    return new TypeAndDecoder((Type)IntegerType.INTEGER, new IntegerDecoder.Descriptor(path));
                }
                case "long": {
                    return new TypeAndDecoder((Type)BigintType.BIGINT, new BigintDecoder.Descriptor(path));
                }
                case "text": 
                case "keyword": {
                    return new TypeAndDecoder((Type)VarcharType.VARCHAR, new VarcharDecoder.Descriptor(path));
                }
                case "ip": {
                    return new TypeAndDecoder(this.ipAddressType, new IpAddressDecoder.Descriptor(path, this.ipAddressType));
                }
                case "boolean": {
                    return new TypeAndDecoder((Type)BooleanType.BOOLEAN, new BooleanDecoder.Descriptor(path));
                }
                case "binary": {
                    return new TypeAndDecoder((Type)VarbinaryType.VARBINARY, new VarbinaryDecoder.Descriptor(path));
                }
            }
        } else {
            if (type instanceof IndexMetadata.ScaledFloatType) {
                return new TypeAndDecoder((Type)DoubleType.DOUBLE, new DoubleDecoder.Descriptor(path));
            }
            if (type instanceof IndexMetadata.DateTimeType) {
                IndexMetadata.DateTimeType dateTimeType = (IndexMetadata.DateTimeType)type;
                if (dateTimeType.getFormats().isEmpty()) {
                    return new TypeAndDecoder((Type)TimestampType.TIMESTAMP_MILLIS, new TimestampDecoder.Descriptor(path));
                }
            } else if (type instanceof IndexMetadata.ObjectType) {
                IndexMetadata.ObjectType objectType = (IndexMetadata.ObjectType)type;
                ImmutableList.Builder rowFieldsBuilder = ImmutableList.builder();
                ImmutableList.Builder decoderFields = ImmutableList.builder();
                for (IndexMetadata.Field rowField : objectType.getFields()) {
                    String name = rowField.getName();
                    TypeAndDecoder child = this.toTrino(path, rowField);
                    if (child == null) continue;
                    decoderFields.add((Object)new RowDecoder.NameAndDescriptor(name, child.getDecoderDescriptor()));
                    rowFieldsBuilder.add((Object)RowType.field((String)name, (Type)child.getType()));
                }
                ImmutableList rowFields = rowFieldsBuilder.build();
                if (!rowFields.isEmpty()) {
                    return new TypeAndDecoder((Type)RowType.from((List)rowFields), new RowDecoder.Descriptor(path, (List<RowDecoder.NameAndDescriptor>)decoderFields.build()));
                }
            }
        }
        return null;
    }

    private static String appendPath(String base, String element) {
        if (base.isEmpty()) {
            return element;
        }
        return base + "." + element;
    }

    public static IndexMetadata.Field elementField(IndexMetadata.Field field) {
        Preconditions.checkArgument((boolean)field.isArray(), (Object)"Cannot get element field from a non-array field");
        return new IndexMetadata.Field(field.asRawJson(), false, field.getName(), field.getType());
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        if (schemaName.isPresent() && !schemaName.get().equals(this.schemaName)) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableSet indexes = ImmutableSet.copyOf(this.client.getIndexes());
        indexes.stream().map(index -> new SchemaTableName(this.schemaName, index)).forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        this.client.getAliases().entrySet().stream().filter(arg_0 -> OpenSearchMetadata.lambda$listTables$3((Set)indexes, arg_0)).flatMap(entry -> ((List)entry.getValue()).stream().map(alias -> new SchemaTableName(this.schemaName, alias))).distinct().forEach(arg_0 -> ((ImmutableList.Builder)result).add(arg_0));
        return result.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        OpenSearchTableHandle table = (OpenSearchTableHandle)tableHandle;
        if (OpenSearchMetadata.isPassthroughQuery(table)) {
            return PASSTHROUGH_QUERY_COLUMNS;
        }
        InternalTableMetadata tableMetadata = this.makeInternalTableMetadata(tableHandle);
        return tableMetadata.getColumnHandles();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        OpenSearchTableHandle table = (OpenSearchTableHandle)tableHandle;
        OpenSearchColumnHandle column = (OpenSearchColumnHandle)columnHandle;
        if (OpenSearchMetadata.isPassthroughQuery(table)) {
            if (column.getName().equals(PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA.getName())) {
                return PASSTHROUGH_QUERY_RESULT_COLUMN_METADATA;
            }
            throw new IllegalArgumentException(String.format("Unexpected column for table '%s$query': %s", table.getIndex(), column.getName()));
        }
        return BuiltinColumns.of(column.getName()).map(BuiltinColumns::getMetadata).orElse(ColumnMetadata.builder().setName(column.getName()).setType(column.getType()).build());
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        throw new UnsupportedOperationException("The deprecated listTableColumns is not supported because streamTableColumns is implemented instead");
    }

    public Iterator<TableColumnsMetadata> streamTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        if (prefix.getSchema().isPresent() && !((String)prefix.getSchema().get()).equals(this.schemaName)) {
            return Collections.emptyIterator();
        }
        if (prefix.getSchema().isPresent() && prefix.getTable().isPresent()) {
            ConnectorTableMetadata metadata = this.getTableMetadata((String)prefix.getSchema().get(), (String)prefix.getTable().get());
            return Iterators.singletonIterator((Object)TableColumnsMetadata.forTable((SchemaTableName)metadata.getTable(), (List)metadata.getColumns()));
        }
        return this.listTables(session, prefix.getSchema()).stream().flatMap(name -> {
            try {
                ConnectorTableMetadata tableMetadata = this.getTableMetadata(name.getSchemaName(), name.getTableName());
                return Stream.of(TableColumnsMetadata.forTable((SchemaTableName)tableMetadata.getTable(), (List)tableMetadata.getColumns()));
            }
            catch (TrinoException e) {
                ResponseException cause;
                Throwable patt0$temp = e.getCause();
                if (patt0$temp instanceof ResponseException && (cause = (ResponseException)patt0$temp).getResponse().getStatusLine().getStatusCode() == 404) {
                    return Stream.empty();
                }
                throw e;
            }
        }).iterator();
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle table) {
        OpenSearchTableHandle handle = (OpenSearchTableHandle)table;
        return new ConnectorTableProperties(handle.getConstraint(), Optional.empty(), Optional.empty(), (List)ImmutableList.of());
    }

    public Optional<LimitApplicationResult<ConnectorTableHandle>> applyLimit(ConnectorSession session, ConnectorTableHandle table, long limit) {
        OpenSearchTableHandle handle = (OpenSearchTableHandle)table;
        if (OpenSearchMetadata.isPassthroughQuery(handle)) {
            return Optional.empty();
        }
        if (handle.getLimit().isPresent() && handle.getLimit().getAsLong() <= limit) {
            return Optional.empty();
        }
        handle = new OpenSearchTableHandle(handle.getType(), handle.getSchema(), handle.getIndex(), handle.getConstraint(), handle.getRegexes(), handle.getQuery(), OptionalLong.of(limit));
        return Optional.of(new LimitApplicationResult((Object)handle, false, false));
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        OpenSearchTableHandle handle = (OpenSearchTableHandle)table;
        if (OpenSearchMetadata.isPassthroughQuery(handle)) {
            return Optional.empty();
        }
        HashMap<OpenSearchColumnHandle, Domain> supported = new HashMap<OpenSearchColumnHandle, Domain>();
        HashMap<OpenSearchColumnHandle, Domain> unsupported = new HashMap<OpenSearchColumnHandle, Domain>();
        Map domains = (Map)constraint.getSummary().getDomains().orElseThrow(() -> new IllegalArgumentException("constraint summary is NONE"));
        for (Map.Entry entry : domains.entrySet()) {
            OpenSearchColumnHandle column = (OpenSearchColumnHandle)entry.getKey();
            if (column.isSupportsPredicates()) {
                supported.put(column, (Domain)entry.getValue());
                continue;
            }
            unsupported.put(column, (Domain)entry.getValue());
        }
        TupleDomain<ColumnHandle> oldDomain = handle.getConstraint();
        TupleDomain newDomain = oldDomain.intersect(TupleDomain.withColumnDomains(supported));
        ConnectorExpression oldExpression = constraint.getExpression();
        HashMap<String, String> newRegexes = new HashMap<String, String>(handle.getRegexes());
        List expressions = ConnectorExpressions.extractConjuncts((ConnectorExpression)constraint.getExpression());
        ArrayList<ConnectorExpression> notHandledExpressions = new ArrayList<ConnectorExpression>();
        for (ConnectorExpression expression : expressions) {
            Call call;
            if (expression instanceof Call && OpenSearchMetadata.isSupportedLikeCall(call = (Call)expression)) {
                IndexMetadata metadata;
                List arguments = call.getArguments();
                String variableName = ((Variable)arguments.get(0)).getName();
                OpenSearchColumnHandle column = (OpenSearchColumnHandle)constraint.getAssignments().get(variableName);
                Verify.verifyNotNull((Object)column, (String)"No assignment for %s", (Object[])new Object[]{variableName});
                String columnName = column.getName();
                Object pattern = ((Constant)arguments.get(1)).getValue();
                Optional<Slice> escape = Optional.empty();
                if (arguments.size() == 3) {
                    escape = Optional.of((Slice)((Constant)arguments.get(2)).getValue());
                }
                if (!newRegexes.containsKey(columnName) && pattern instanceof Slice && (metadata = this.client.getIndexMetadata(handle.getIndex())).getSchema().getFields().stream().anyMatch(field -> columnName.equals(field.getName()) && field.getType() instanceof IndexMetadata.PrimitiveType && "keyword".equals(((IndexMetadata.PrimitiveType)field.getType()).getName()))) {
                    newRegexes.put(columnName, OpenSearchMetadata.likeToRegexp((Slice)pattern, escape));
                    continue;
                }
            }
            notHandledExpressions.add(expression);
        }
        ConnectorExpression newExpression = ConnectorExpressions.and(notHandledExpressions);
        if (oldDomain.equals((Object)newDomain) && oldExpression.equals((Object)newExpression)) {
            return Optional.empty();
        }
        handle = new OpenSearchTableHandle(handle.getType(), handle.getSchema(), handle.getIndex(), (TupleDomain<ColumnHandle>)newDomain, newRegexes, handle.getQuery(), handle.getLimit());
        return Optional.of(new ConstraintApplicationResult((Object)handle, TupleDomain.withColumnDomains(unsupported), newExpression, false));
    }

    protected static boolean isSupportedLikeCall(Call call) {
        if (!StandardFunctions.LIKE_FUNCTION_NAME.equals((Object)call.getFunctionName())) {
            return false;
        }
        List arguments = call.getArguments();
        if (arguments.size() < 2 || arguments.size() > 3) {
            return false;
        }
        if (!(arguments.get(0) instanceof Variable) || !(arguments.get(1) instanceof Constant)) {
            return false;
        }
        if (arguments.size() == 3) {
            return arguments.get(2) instanceof Constant;
        }
        return true;
    }

    protected static String likeToRegexp(Slice pattern, Optional<Slice> escape) {
        Optional<Character> escapeChar = escape.map(OpenSearchMetadata::getEscapeChar);
        StringBuilder regex = new StringBuilder();
        boolean escaped = false;
        int position = 0;
        block5: while (position < pattern.length()) {
            int currentChar = SliceUtf8.getCodePointAt((Slice)pattern, (int)position);
            position += SliceUtf8.lengthOfCodePoint((int)currentChar);
            OpenSearchMetadata.checkEscape(!escaped || currentChar == 37 || currentChar == 95 || currentChar == escapeChar.get().charValue());
            if (!escaped && escapeChar.isPresent() && currentChar == escapeChar.get().charValue()) {
                escaped = true;
                continue;
            }
            switch (currentChar) {
                case 37: {
                    regex.append(escaped ? "%" : ".*");
                    escaped = false;
                    continue block5;
                }
                case 95: {
                    regex.append(escaped ? "_" : ".");
                    escaped = false;
                    continue block5;
                }
                case 92: {
                    regex.append("\\\\");
                    continue block5;
                }
            }
            if (REGEXP_RESERVED_CHARACTERS.contains(currentChar)) {
                regex.append('\\');
            }
            regex.appendCodePoint(currentChar);
            escaped = false;
        }
        OpenSearchMetadata.checkEscape(!escaped);
        return regex.toString();
    }

    private static void checkEscape(boolean condition) {
        if (!condition) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape character must be followed by '%', '_' or the escape character itself");
        }
    }

    private static char getEscapeChar(Slice escape) {
        String escapeString = escape.toStringUtf8();
        if (escapeString.length() == 1) {
            return escapeString.charAt(0);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Escape string must be a single character");
    }

    private static boolean isPassthroughQuery(OpenSearchTableHandle table) {
        return table.getType().equals((Object)OpenSearchTableHandle.Type.QUERY);
    }

    public Optional<TableFunctionApplicationResult<ConnectorTableHandle>> applyTableFunction(ConnectorSession session, ConnectorTableFunctionHandle handle) {
        if (!(handle instanceof RawQuery.RawQueryFunctionHandle)) {
            return Optional.empty();
        }
        ConnectorTableHandle tableHandle = ((RawQuery.RawQueryFunctionHandle)handle).getTableHandle();
        ImmutableList columnHandles = ImmutableList.copyOf(this.getColumnHandles(session, tableHandle).values());
        return Optional.of(new TableFunctionApplicationResult((Object)tableHandle, (List)columnHandles));
    }

    private static /* synthetic */ boolean lambda$listTables$3(Set indexes, Map.Entry entry) {
        return indexes.contains(entry.getKey());
    }

    private static class InternalTableMetadata {
        private final SchemaTableName tableName;
        private final List<ColumnMetadata> columnMetadata;
        private final Map<String, ColumnHandle> columnHandles;

        public InternalTableMetadata(SchemaTableName tableName, List<ColumnMetadata> columnMetadata, Map<String, ColumnHandle> columnHandles) {
            this.tableName = tableName;
            this.columnMetadata = columnMetadata;
            this.columnHandles = columnHandles;
        }

        public SchemaTableName getTableName() {
            return this.tableName;
        }

        public List<ColumnMetadata> getColumnMetadata() {
            return this.columnMetadata;
        }

        public Map<String, ColumnHandle> getColumnHandles() {
            return this.columnHandles;
        }
    }

    private static class TypeAndDecoder {
        private final Type type;
        private final DecoderDescriptor decoderDescriptor;

        public TypeAndDecoder(Type type, DecoderDescriptor decoderDescriptor) {
            this.type = type;
            this.decoderDescriptor = decoderDescriptor;
        }

        public Type getType() {
            return this.type;
        }

        public DecoderDescriptor getDecoderDescriptor() {
            return this.decoderDescriptor;
        }
    }
}

