/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.opensearch.CountQueryPageSource;
import io.trino.plugin.opensearch.OpenSearchColumnHandle;
import io.trino.plugin.opensearch.OpenSearchSplit;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.plugin.opensearch.PassthroughQueryPageSource;
import io.trino.plugin.opensearch.ScanQueryPageSource;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.type.TypeManager;
import java.util.List;
import java.util.Objects;

public class OpenSearchPageSourceProvider
implements ConnectorPageSourceProvider {
    private final OpenSearchClient client;
    private final TypeManager typeManager;

    @Inject
    public OpenSearchPageSourceProvider(OpenSearchClient client, TypeManager typeManager) {
        this.client = Objects.requireNonNull(client, "client is null");
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    public ConnectorPageSource createPageSource(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<ColumnHandle> columns, DynamicFilter dynamicFilter) {
        Objects.requireNonNull(split, "split is null");
        Objects.requireNonNull(table, "table is null");
        OpenSearchTableHandle opensearchTable = (OpenSearchTableHandle)table;
        OpenSearchSplit opensearchSplit = (OpenSearchSplit)split;
        if (opensearchTable.getType().equals((Object)OpenSearchTableHandle.Type.QUERY)) {
            return new PassthroughQueryPageSource(this.client, opensearchTable);
        }
        if (columns.isEmpty()) {
            return new CountQueryPageSource(this.client, opensearchTable, opensearchSplit);
        }
        return new ScanQueryPageSource(this.client, this.typeManager, opensearchTable, opensearchSplit, (List)columns.stream().map(OpenSearchColumnHandle.class::cast).collect(ImmutableList.toImmutableList()));
    }
}

