/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.opensearch.OpenSearchSplit;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.connector.FixedSplitSource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class OpenSearchSplitManager
implements ConnectorSplitManager {
    private final OpenSearchClient client;

    @Inject
    public OpenSearchSplitManager(OpenSearchClient client) {
        this.client = Objects.requireNonNull(client, "client is null");
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle table, DynamicFilter dynamicFilter, Constraint constraint) {
        OpenSearchTableHandle tableHandle = (OpenSearchTableHandle)table;
        if (tableHandle.getType().equals((Object)OpenSearchTableHandle.Type.QUERY)) {
            return new FixedSplitSource((ConnectorSplit)new OpenSearchSplit(tableHandle.getIndex(), 0, Optional.empty()));
        }
        List splits = (List)this.client.getSearchShards(tableHandle.getIndex()).stream().map(shard -> new OpenSearchSplit(shard.getIndex(), shard.getId(), shard.getAddress())).collect(ImmutableList.toImmutableList());
        return new FixedSplitSource((Iterable)splits);
    }
}

