/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.trino.plugin.opensearch.BuiltinColumns;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.OpenSearchColumnHandle;
import io.trino.plugin.opensearch.OpenSearchQueryBuilder;
import io.trino.plugin.opensearch.OpenSearchSplit;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.plugin.opensearch.decoders.Decoder;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.search.SearchHit;
import org.opensearch.search.SearchHits;

public class ScanQueryPageSource
implements ConnectorPageSource {
    private static final Logger LOG = Logger.get(ScanQueryPageSource.class);
    private final List<Decoder> decoders;
    private final SearchHitIterator iterator;
    private final BlockBuilder[] columnBuilders;
    private final List<OpenSearchColumnHandle> columns;
    private long totalBytes;
    private long readTimeNanos;

    public ScanQueryPageSource(OpenSearchClient client, TypeManager typeManager, OpenSearchTableHandle table, OpenSearchSplit split, List<OpenSearchColumnHandle> columns) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(typeManager, "typeManager is null");
        Objects.requireNonNull(columns, "columns is null");
        this.columns = ImmutableList.copyOf(columns);
        this.decoders = this.createDecoders(columns);
        boolean needAllFields = columns.stream().map(OpenSearchColumnHandle::getName).anyMatch(Predicate.isEqual(BuiltinColumns.SOURCE.getName()));
        List documentFields = (List)this.flattenFields(columns).entrySet().stream().filter(entry -> ((Type)entry.getValue()).equals((Object)TimestampType.TIMESTAMP_MILLIS)).map(Map.Entry::getKey).collect(ImmutableList.toImmutableList());
        this.columnBuilders = (BlockBuilder[])columns.stream().map(OpenSearchColumnHandle::getType).map(type -> type.createBlockBuilder(null, 1)).toArray(BlockBuilder[]::new);
        List requiredFields = columns.stream().map(OpenSearchColumnHandle::getName).filter(name -> !BuiltinColumns.isBuiltinColumn(name)).collect(Collectors.toList());
        Optional<String> sort = Optional.of("_doc");
        if (table.getQuery().isPresent()) {
            sort = Optional.empty();
        }
        long start = System.nanoTime();
        SearchResponse searchResponse = client.beginSearch(split.getIndex(), split.getShard(), OpenSearchQueryBuilder.buildSearchQuery((TupleDomain<OpenSearchColumnHandle>)table.getConstraint().transformKeys(OpenSearchColumnHandle.class::cast), table.getQuery(), table.getRegexes()), needAllFields ? Optional.empty() : Optional.of(requiredFields), documentFields, sort, table.getLimit());
        this.readTimeNanos += System.nanoTime() - start;
        this.iterator = new SearchHitIterator(client, () -> searchResponse, table.getLimit());
    }

    public long getCompletedBytes() {
        return this.totalBytes;
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos + this.iterator.getReadTimeNanos();
    }

    public boolean isFinished() {
        return !this.iterator.hasNext();
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public void close() {
        this.iterator.close();
    }

    public Page getNextPage() {
        long size = 0L;
        while (size < 0x100000L && this.iterator.hasNext()) {
            SearchHit hit = (SearchHit)this.iterator.next();
            Map document = hit.getSourceAsMap();
            for (int i = 0; i < this.decoders.size(); ++i) {
                String field = this.columns.get(i).getName();
                this.decoders.get(i).decode(hit, () -> ScanQueryPageSource.getField(document, field), this.columnBuilders[i]);
            }
            if (hit.getSourceRef() != null) {
                this.totalBytes += (long)hit.getSourceRef().length();
            }
            size = Arrays.stream(this.columnBuilders).mapToLong(BlockBuilder::getSizeInBytes).sum();
        }
        Block[] blocks = new Block[this.columnBuilders.length];
        for (int i = 0; i < this.columnBuilders.length; ++i) {
            blocks[i] = this.columnBuilders[i].build();
            this.columnBuilders[i] = this.columnBuilders[i].newBlockBuilderLike(null);
        }
        return new Page(blocks);
    }

    public static Object getField(Map<String, Object> document, String field) {
        Object value = document.get(field);
        if (value == null) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            String prefix = field + ".";
            for (Map.Entry<String, Object> entry : document.entrySet()) {
                String key = entry.getKey();
                if (!key.startsWith(prefix)) continue;
                result.put(key.substring(prefix.length()), entry.getValue());
            }
            if (!result.isEmpty()) {
                return result;
            }
        }
        return value;
    }

    private Map<String, Type> flattenFields(List<OpenSearchColumnHandle> columns) {
        HashMap<String, Type> result = new HashMap<String, Type>();
        for (OpenSearchColumnHandle column : columns) {
            this.flattenFields(result, column.getName(), column.getType());
        }
        return result;
    }

    private void flattenFields(Map<String, Type> result, String fieldName, Type type) {
        if (type instanceof RowType) {
            for (RowType.Field field : ((RowType)type).getFields()) {
                this.flattenFields(result, ScanQueryPageSource.appendPath(fieldName, (String)field.getName().get()), field.getType());
            }
        } else {
            result.put(fieldName, type);
        }
    }

    private List<Decoder> createDecoders(List<OpenSearchColumnHandle> columns) {
        return (List)columns.stream().map(OpenSearchColumnHandle::getDecoderDescriptor).map(DecoderDescriptor::createDecoder).collect(ImmutableList.toImmutableList());
    }

    private static String appendPath(String base, String element) {
        if (base.isEmpty()) {
            return element;
        }
        return base + "." + element;
    }

    private static class SearchHitIterator
    extends AbstractIterator<SearchHit> {
        private final OpenSearchClient client;
        private final Supplier<SearchResponse> first;
        private final OptionalLong limit;
        private SearchHits searchHits;
        private String scrollId;
        private int currentPosition;
        private long readTimeNanos;
        private long totalRecordCount;

        public SearchHitIterator(OpenSearchClient client, Supplier<SearchResponse> first, OptionalLong limit) {
            this.client = client;
            this.first = first;
            this.limit = limit;
            this.totalRecordCount = 0L;
        }

        public long getReadTimeNanos() {
            return this.readTimeNanos;
        }

        protected SearchHit computeNext() {
            if (this.limit.isPresent() && this.totalRecordCount == this.limit.getAsLong()) {
                return (SearchHit)this.endOfData();
            }
            if (this.scrollId == null) {
                start = System.nanoTime();
                SearchResponse response = this.first.get();
                this.readTimeNanos += System.nanoTime() - start;
                this.reset(response);
            } else if (this.currentPosition == this.searchHits.getHits().length) {
                start = System.nanoTime();
                SearchResponse response = this.client.nextPage(this.scrollId);
                this.readTimeNanos += System.nanoTime() - start;
                this.reset(response);
            }
            if (this.currentPosition == this.searchHits.getHits().length) {
                return (SearchHit)this.endOfData();
            }
            SearchHit hit = this.searchHits.getAt(this.currentPosition);
            ++this.currentPosition;
            ++this.totalRecordCount;
            return hit;
        }

        private void reset(SearchResponse response) {
            this.scrollId = response.getScrollId();
            this.searchHits = response.getHits();
            this.currentPosition = 0;
        }

        public void close() {
            if (this.scrollId != null) {
                try {
                    this.client.clearScroll(this.scrollId);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e, "Error clearing scroll");
                }
            }
        }
    }
}

