/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;

public class IndexMetadata {
    private final ObjectType schema;

    public IndexMetadata(ObjectType schema) {
        this.schema = Objects.requireNonNull(schema, "schema is null");
    }

    public ObjectType getSchema() {
        return this.schema;
    }

    public static class ObjectType
    implements Type {
        private final List<Field> fields;

        public ObjectType(List<Field> fields) {
            Objects.requireNonNull(fields, "fields is null");
            this.fields = ImmutableList.copyOf(fields);
        }

        public List<Field> getFields() {
            return this.fields;
        }
    }

    public static class ScaledFloatType
    implements Type {
        private final double scale;

        public ScaledFloatType(double scale) {
            this.scale = scale;
        }

        public double getScale() {
            return this.scale;
        }
    }

    public static class DateTimeType
    implements Type {
        private final List<String> formats;

        public DateTimeType(List<String> formats) {
            Objects.requireNonNull(formats, "formats is null");
            this.formats = ImmutableList.copyOf(formats);
        }

        public List<String> getFormats() {
            return this.formats;
        }
    }

    public static class PrimitiveType
    implements Type {
        private final String name;

        public PrimitiveType(String name) {
            this.name = Objects.requireNonNull(name, "name is null");
        }

        public String getName() {
            return this.name;
        }
    }

    public static interface Type {
    }

    public static class Field {
        private final boolean asRawJson;
        private final boolean isArray;
        private final String name;
        private final Type type;

        public Field(boolean asRawJson, boolean isArray, String name, Type type) {
            Preconditions.checkArgument((!asRawJson || !isArray ? 1 : 0) != 0, (Object)String.format("A column, (%s) cannot be declared as a Trino array and also be rendered as json.", name));
            this.asRawJson = asRawJson;
            this.isArray = isArray;
            this.name = Objects.requireNonNull(name, "name is null");
            this.type = Objects.requireNonNull(type, "type is null");
        }

        public boolean asRawJson() {
            return this.asRawJson;
        }

        public boolean isArray() {
            return this.isArray;
        }

        public String getName() {
            return this.name;
        }

        public Type getType() {
            return this.type;
        }
    }
}

