/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.decoders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.decoders.Decoder;
import io.trino.spi.block.ArrayBlockBuilder;
import io.trino.spi.block.BlockBuilder;
import java.util.List;
import java.util.function.Supplier;
import org.opensearch.search.SearchHit;

public class ArrayDecoder
implements Decoder {
    private final Decoder elementDecoder;

    public ArrayDecoder(Decoder elementDecoder) {
        this.elementDecoder = elementDecoder;
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object data = getter.get();
        if (data == null) {
            output.appendNull();
        } else if (data instanceof List) {
            List list = (List)data;
            ((ArrayBlockBuilder)output).buildEntry(elementBuilder -> list.forEach(element -> this.elementDecoder.decode(hit, () -> element, elementBuilder)));
        } else {
            ((ArrayBlockBuilder)output).buildEntry(elementBuilder -> this.elementDecoder.decode(hit, () -> data, elementBuilder));
        }
    }

    public static class Descriptor
    implements DecoderDescriptor {
        private final DecoderDescriptor elementDescriptor;

        @JsonCreator
        public Descriptor(DecoderDescriptor elementDescriptor) {
            this.elementDescriptor = elementDescriptor;
        }

        @JsonProperty
        public DecoderDescriptor getElementDescriptor() {
            return this.elementDescriptor;
        }

        @Override
        public Decoder createDecoder() {
            return new ArrayDecoder(this.elementDescriptor.createDecoder());
        }
    }
}

