/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.ptf;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.airlift.slice.Slice;
import io.trino.plugin.opensearch.OpenSearchColumnHandle;
import io.trino.plugin.opensearch.OpenSearchMetadata;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnSchema;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableSchema;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.function.table.AbstractConnectorTableFunction;
import io.trino.spi.function.table.Argument;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.function.table.ConnectorTableFunctionHandle;
import io.trino.spi.function.table.Descriptor;
import io.trino.spi.function.table.ReturnTypeSpecification;
import io.trino.spi.function.table.ScalarArgument;
import io.trino.spi.function.table.ScalarArgumentSpecification;
import io.trino.spi.function.table.TableFunctionAnalysis;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class RawQuery
implements Provider<ConnectorTableFunction> {
    public static final String SCHEMA_NAME = "system";
    public static final String NAME = "raw_query";
    private final OpenSearchMetadata metadata;

    @Inject
    public RawQuery(OpenSearchMetadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    public ConnectorTableFunction get() {
        return new RawQueryFunction(this.metadata);
    }

    public static class RawQueryFunction
    extends AbstractConnectorTableFunction {
        private final OpenSearchMetadata metadata;

        public RawQueryFunction(OpenSearchMetadata metadata) {
            super(RawQuery.SCHEMA_NAME, RawQuery.NAME, List.of(ScalarArgumentSpecification.builder().name("SCHEMA").type((Type)VarcharType.VARCHAR).build(), ScalarArgumentSpecification.builder().name("INDEX").type((Type)VarcharType.VARCHAR).build(), ScalarArgumentSpecification.builder().name("QUERY").type((Type)VarcharType.VARCHAR).build()), (ReturnTypeSpecification)ReturnTypeSpecification.GenericTable.GENERIC_TABLE);
            this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        }

        public TableFunctionAnalysis analyze(ConnectorSession session, ConnectorTransactionHandle transaction, Map<String, Argument> arguments, ConnectorAccessControl accessControl) {
            String schema = ((Slice)((ScalarArgument)arguments.get("SCHEMA")).getValue()).toStringUtf8();
            String index = ((Slice)((ScalarArgument)arguments.get("INDEX")).getValue()).toStringUtf8();
            String query = ((Slice)((ScalarArgument)arguments.get("QUERY")).getValue()).toStringUtf8();
            OpenSearchTableHandle tableHandle = new OpenSearchTableHandle(OpenSearchTableHandle.Type.QUERY, schema, index, Optional.of(query));
            ConnectorTableSchema tableSchema = this.metadata.getTableSchema(session, tableHandle);
            Map<String, ColumnHandle> columnsByName = this.metadata.getColumnHandles(session, tableHandle);
            List columns = (List)tableSchema.getColumns().stream().map(ColumnSchema::getName).map(columnsByName::get).collect(ImmutableList.toImmutableList());
            Descriptor returnedType = new Descriptor(columns.stream().map(OpenSearchColumnHandle.class::cast).map(column -> new Descriptor.Field(column.getName(), Optional.of(column.getType()))).collect(Collectors.toList()));
            RawQueryFunctionHandle handle = new RawQueryFunctionHandle(tableHandle);
            return TableFunctionAnalysis.builder().returnedType(returnedType).handle((ConnectorTableFunctionHandle)handle).build();
        }
    }

    public static class RawQueryFunctionHandle
    implements ConnectorTableFunctionHandle {
        private final OpenSearchTableHandle tableHandle;

        @JsonCreator
        public RawQueryFunctionHandle(@JsonProperty(value="tableHandle") OpenSearchTableHandle tableHandle) {
            this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        }

        @JsonProperty
        public ConnectorTableHandle getTableHandle() {
            return this.tableHandle;
        }
    }
}

