/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.search;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.TotalHits;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchRequestOperationsListener;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.ShardStatsFieldNames;
import org.opensearch.common.annotation.InternalApi;

@InternalApi
public class SearchRequestContext {
    private final SearchRequestOperationsListener searchRequestOperationsListener;
    private long absoluteStartNanos;
    private final Map<String, Long> phaseTookMap;
    private TotalHits totalHits;
    private final EnumMap<ShardStatsFieldNames, Integer> shardStats;
    private final SearchRequest searchRequest;

    SearchRequestContext(SearchRequestOperationsListener searchRequestOperationsListener, SearchRequest searchRequest) {
        this.searchRequestOperationsListener = searchRequestOperationsListener;
        this.absoluteStartNanos = System.nanoTime();
        this.phaseTookMap = new HashMap<String, Long>();
        this.shardStats = new EnumMap(ShardStatsFieldNames.class);
        this.searchRequest = searchRequest;
    }

    SearchRequestOperationsListener getSearchRequestOperationsListener() {
        return this.searchRequestOperationsListener;
    }

    void updatePhaseTookMap(String phaseName, Long tookTime) {
        this.phaseTookMap.put(phaseName, tookTime);
    }

    public Map<String, Long> phaseTookMap() {
        return this.phaseTookMap;
    }

    SearchResponse.PhaseTook getPhaseTook() {
        if (this.searchRequest != null && this.searchRequest.isPhaseTook() != null && this.searchRequest.isPhaseTook().booleanValue()) {
            return new SearchResponse.PhaseTook(this.phaseTookMap);
        }
        return null;
    }

    void setAbsoluteStartNanos(long absoluteStartNanos) {
        this.absoluteStartNanos = absoluteStartNanos;
    }

    public long getAbsoluteStartNanos() {
        return this.absoluteStartNanos;
    }

    void setTotalHits(TotalHits totalHits) {
        this.totalHits = totalHits;
    }

    TotalHits totalHits() {
        return this.totalHits;
    }

    void setShardStats(int total, int successful, int skipped, int failed) {
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_TOTAL, total);
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SUCCESSFUL, successful);
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SKIPPED, skipped);
        this.shardStats.put(ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_FAILED, failed);
    }

    String formattedShardStats() {
        if (this.shardStats.isEmpty()) {
            return "";
        }
        return String.format(Locale.ROOT, "{%s:%s, %s:%s, %s:%s, %s:%s}", ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_TOTAL.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_TOTAL), ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SUCCESSFUL.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SUCCESSFUL), ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SKIPPED.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_SKIPPED), ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_FAILED.toString(), this.shardStats.get((Object)ShardStatsFieldNames.SEARCH_REQUEST_SLOWLOG_SHARD_FAILED));
    }
}

