/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.store;

import org.opensearch.common.cache.Cache;
import org.opensearch.common.cache.CacheBuilder;
import org.opensearch.common.cache.LoadAwareCacheLoader;
import org.opensearch.common.cache.RemovalListener;
import org.opensearch.common.cache.RemovalNotification;
import org.opensearch.common.cache.store.StoreAwareCache;
import org.opensearch.common.cache.store.StoreAwareCacheRemovalNotification;
import org.opensearch.common.cache.store.builders.StoreAwareCacheBuilder;
import org.opensearch.common.cache.store.enums.CacheStoreType;
import org.opensearch.common.cache.store.listeners.StoreAwareCacheEventListener;

public class OpenSearchOnHeapCache<K, V>
implements StoreAwareCache<K, V>,
RemovalListener<K, V> {
    private final Cache<K, V> cache;
    private final StoreAwareCacheEventListener<K, V> eventListener;

    public OpenSearchOnHeapCache(Builder<K, V> builder) {
        CacheBuilder cacheBuilder = CacheBuilder.builder().setMaximumWeight(builder.getMaxWeightInBytes()).weigher(builder.getWeigher()).removalListener(this);
        if (builder.getExpireAfterAcess() != null) {
            cacheBuilder.setExpireAfterAccess(builder.getExpireAfterAcess());
        }
        this.cache = cacheBuilder.build();
        this.eventListener = builder.getEventListener();
    }

    @Override
    public V get(K key) {
        V value = this.cache.get(key);
        if (value != null) {
            this.eventListener.onHit(key, value, CacheStoreType.ON_HEAP);
        } else {
            this.eventListener.onMiss(key, CacheStoreType.ON_HEAP);
        }
        return value;
    }

    @Override
    public void put(K key, V value) {
        this.cache.put(key, value);
        this.eventListener.onCached(key, value, CacheStoreType.ON_HEAP);
    }

    @Override
    public V computeIfAbsent(K key, LoadAwareCacheLoader<K, V> loader) throws Exception {
        Object value = this.cache.computeIfAbsent(key, (K key1) -> loader.load(key));
        if (!loader.isLoaded()) {
            this.eventListener.onHit(key, value, CacheStoreType.ON_HEAP);
        } else {
            this.eventListener.onMiss(key, CacheStoreType.ON_HEAP);
            this.eventListener.onCached(key, value, CacheStoreType.ON_HEAP);
        }
        return (V)value;
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public Iterable<K> keys() {
        return this.cache.keys();
    }

    @Override
    public long count() {
        return this.cache.count();
    }

    @Override
    public void refresh() {
        this.cache.refresh();
    }

    @Override
    public CacheStoreType getTierType() {
        return CacheStoreType.ON_HEAP;
    }

    @Override
    public void onRemoval(RemovalNotification<K, V> notification) {
        this.eventListener.onRemoval(new StoreAwareCacheRemovalNotification<K, V>(notification.getKey(), notification.getValue(), notification.getRemovalReason(), CacheStoreType.ON_HEAP));
    }

    public static class Builder<K, V>
    extends StoreAwareCacheBuilder<K, V> {
        @Override
        public StoreAwareCache<K, V> build() {
            return new OpenSearchOnHeapCache(this);
        }
    }
}

