/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.cache.tier;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.opensearch.common.cache.ICache;
import org.opensearch.common.cache.LoadAwareCacheLoader;
import org.opensearch.common.cache.RemovalReason;
import org.opensearch.common.cache.store.StoreAwareCache;
import org.opensearch.common.cache.store.StoreAwareCacheRemovalNotification;
import org.opensearch.common.cache.store.StoreAwareCacheValue;
import org.opensearch.common.cache.store.builders.StoreAwareCacheBuilder;
import org.opensearch.common.cache.store.enums.CacheStoreType;
import org.opensearch.common.cache.store.listeners.StoreAwareCacheEventListener;
import org.opensearch.common.util.concurrent.ReleasableLock;
import org.opensearch.common.util.iterable.Iterables;

public class TieredSpilloverCache<K, V>
implements ICache<K, V>,
StoreAwareCacheEventListener<K, V> {
    private final Optional<StoreAwareCache<K, V>> onDiskCache;
    private final StoreAwareCache<K, V> onHeapCache;
    private final StoreAwareCacheEventListener<K, V> listener;
    ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    ReleasableLock readLock = new ReleasableLock(this.readWriteLock.readLock());
    ReleasableLock writeLock = new ReleasableLock(this.readWriteLock.writeLock());
    private final List<StoreAwareCache<K, V>> cacheList;

    TieredSpilloverCache(Builder<K, V> builder) {
        Objects.requireNonNull(builder.onHeapCacheBuilder, "onHeap cache builder can't be null");
        this.onHeapCache = builder.onHeapCacheBuilder.setEventListener(this).build();
        this.onDiskCache = builder.onDiskCacheBuilder != null ? Optional.of(builder.onDiskCacheBuilder.setEventListener(this).build()) : Optional.empty();
        this.listener = builder.listener;
        this.cacheList = this.onDiskCache.map(diskTier -> Arrays.asList(this.onHeapCache, diskTier)).orElse(List.of(this.onHeapCache));
    }

    StoreAwareCache<K, V> getOnHeapCache() {
        return this.onHeapCache;
    }

    Optional<StoreAwareCache<K, V>> getOnDiskCache() {
        return this.onDiskCache;
    }

    @Override
    public V get(K key) {
        StoreAwareCacheValue<V> cacheValue = this.getValueFromTieredCache(true).apply(key);
        if (cacheValue == null) {
            return null;
        }
        return cacheValue.getValue();
    }

    @Override
    public void put(K key, V value) {
        try (ReleasableLock ignore = this.writeLock.acquire();){
            this.onHeapCache.put(key, value);
            this.listener.onCached(key, value, CacheStoreType.ON_HEAP);
        }
    }

    @Override
    public V computeIfAbsent(K key, LoadAwareCacheLoader<K, V> loader) throws Exception {
        StoreAwareCacheValue<V> cacheValue = this.getValueFromTieredCache(false).apply(key);
        if (cacheValue == null) {
            Object value = null;
            try (ReleasableLock ignore = this.writeLock.acquire();){
                value = this.onHeapCache.computeIfAbsent(key, loader);
            }
            if (loader.isLoaded()) {
                this.listener.onMiss(key, CacheStoreType.ON_HEAP);
                this.onDiskCache.ifPresent(diskTier -> this.listener.onMiss(key, CacheStoreType.DISK));
                this.listener.onCached(key, value, CacheStoreType.ON_HEAP);
            } else {
                this.listener.onHit(key, value, CacheStoreType.ON_HEAP);
            }
            return value;
        }
        this.listener.onHit(key, cacheValue.getValue(), cacheValue.getCacheStoreType());
        if (cacheValue.getCacheStoreType().equals((Object)CacheStoreType.DISK)) {
            this.listener.onMiss(key, CacheStoreType.ON_HEAP);
        }
        return cacheValue.getValue();
    }

    @Override
    public void invalidate(K key) {
        try (ReleasableLock ignore = this.writeLock.acquire();){
            for (StoreAwareCache<K, V> storeAwareCache : this.cacheList) {
                storeAwareCache.invalidate(key);
            }
        }
    }

    @Override
    public void invalidateAll() {
        try (ReleasableLock ignore = this.writeLock.acquire();){
            for (StoreAwareCache<K, V> storeAwareCache : this.cacheList) {
                storeAwareCache.invalidateAll();
            }
        }
    }

    @Override
    public Iterable<K> keys() {
        Iterable<Object> onDiskKeysIterable = this.onDiskCache.isPresent() ? this.onDiskCache.get().keys() : Collections::emptyIterator;
        return Iterables.concat(this.onHeapCache.keys(), onDiskKeysIterable);
    }

    @Override
    public long count() {
        long totalCount = 0L;
        for (StoreAwareCache<K, V> storeAwareCache : this.cacheList) {
            totalCount += storeAwareCache.count();
        }
        return totalCount;
    }

    @Override
    public void refresh() {
        try (ReleasableLock ignore = this.writeLock.acquire();){
            for (StoreAwareCache<K, V> storeAwareCache : this.cacheList) {
                storeAwareCache.refresh();
            }
        }
    }

    @Override
    public void onMiss(K key, CacheStoreType cacheStoreType) {
    }

    @Override
    public void onRemoval(StoreAwareCacheRemovalNotification<K, V> notification) {
        block9: {
            if (!RemovalReason.EVICTED.equals((Object)notification.getRemovalReason()) && !RemovalReason.CAPACITY.equals((Object)notification.getRemovalReason())) break block9;
            switch (notification.getCacheStoreType()) {
                case ON_HEAP: {
                    try (ReleasableLock ignore = this.writeLock.acquire();){
                        this.onDiskCache.ifPresent(diskTier -> diskTier.put(notification.getKey(), notification.getValue()));
                    }
                    this.onDiskCache.ifPresent(diskTier -> this.listener.onCached(notification.getKey(), notification.getValue(), CacheStoreType.DISK));
                    break;
                }
            }
        }
        this.listener.onRemoval(notification);
    }

    @Override
    public void onHit(K key, V value, CacheStoreType cacheStoreType) {
    }

    @Override
    public void onCached(K key, V value, CacheStoreType cacheStoreType) {
    }

    private Function<K, StoreAwareCacheValue<V>> getValueFromTieredCache(boolean triggerEventListener) {
        return key -> {
            try (ReleasableLock ignore = this.readLock.acquire();){
                for (StoreAwareCache<Object, V> storeAwareCache : this.cacheList) {
                    Object value = storeAwareCache.get(key);
                    if (value != null) {
                        if (triggerEventListener) {
                            this.listener.onHit(key, value, storeAwareCache.getTierType());
                        }
                        StoreAwareCacheValue storeAwareCacheValue = new StoreAwareCacheValue(value, storeAwareCache.getTierType());
                        return storeAwareCacheValue;
                    }
                    if (!triggerEventListener) continue;
                    this.listener.onMiss(key, storeAwareCache.getTierType());
                }
            }
            return null;
        };
    }

    public static class Builder<K, V> {
        private StoreAwareCacheBuilder<K, V> onHeapCacheBuilder;
        private StoreAwareCacheBuilder<K, V> onDiskCacheBuilder;
        private StoreAwareCacheEventListener<K, V> listener;

        public Builder<K, V> setOnHeapCacheBuilder(StoreAwareCacheBuilder<K, V> onHeapCacheBuilder) {
            this.onHeapCacheBuilder = onHeapCacheBuilder;
            return this;
        }

        public Builder<K, V> setOnDiskCacheBuilder(StoreAwareCacheBuilder<K, V> onDiskCacheBuilder) {
            this.onDiskCacheBuilder = onDiskCacheBuilder;
            return this;
        }

        public Builder<K, V> setListener(StoreAwareCacheEventListener<K, V> listener) {
            this.listener = listener;
            return this;
        }

        public TieredSpilloverCache<K, V> build() {
            return new TieredSpilloverCache(this);
        }
    }
}

