/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.FilterDirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.opensearch.common.SuppressForbidden;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.lucene.index.OpenSearchLeafReader;
import org.opensearch.core.index.shard.ShardId;

@PublicApi(since="1.0.0")
public final class OpenSearchDirectoryReader
extends FilterDirectoryReader {
    private final ShardId shardId;
    private final FilterDirectoryReader.SubReaderWrapper wrapper;

    private OpenSearchDirectoryReader(DirectoryReader in, FilterDirectoryReader.SubReaderWrapper wrapper, ShardId shardId) throws IOException {
        super(in, wrapper);
        this.wrapper = wrapper;
        this.shardId = shardId;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return this.in.getReaderCacheHelper();
    }

    protected DirectoryReader doWrapDirectoryReader(DirectoryReader in) throws IOException {
        return new OpenSearchDirectoryReader(in, this.wrapper, this.shardId);
    }

    public static OpenSearchDirectoryReader wrap(DirectoryReader reader, ShardId shardId) throws IOException {
        return new OpenSearchDirectoryReader(reader, new SubReaderWrapper(shardId), shardId);
    }

    @SuppressForbidden(reason="This is the only sane way to add a ReaderClosedListener")
    public static void addReaderCloseListener(DirectoryReader reader, IndexReader.ClosedListener listener) {
        OpenSearchDirectoryReader openSearchDirectoryReader = OpenSearchDirectoryReader.getOpenSearchDirectoryReader(reader);
        if (openSearchDirectoryReader == null) {
            throw new IllegalArgumentException("Can't install close listener reader is not an OpenSearchDirectoryReader/OpenSearchLeafReader");
        }
        IndexReader.CacheHelper cacheHelper = openSearchDirectoryReader.getReaderCacheHelper();
        if (cacheHelper == null) {
            throw new IllegalArgumentException("Reader " + String.valueOf((Object)openSearchDirectoryReader) + " does not support caching");
        }
        assert (cacheHelper.getKey() == reader.getReaderCacheHelper().getKey());
        cacheHelper.addClosedListener(listener);
    }

    public static OpenSearchDirectoryReader getOpenSearchDirectoryReader(DirectoryReader reader) {
        if (reader instanceof FilterDirectoryReader) {
            if (reader instanceof OpenSearchDirectoryReader) {
                return (OpenSearchDirectoryReader)reader;
            }
            return OpenSearchDirectoryReader.getOpenSearchDirectoryReader(((FilterDirectoryReader)reader).getDelegate());
        }
        return null;
    }

    private static final class SubReaderWrapper
    extends FilterDirectoryReader.SubReaderWrapper {
        private final ShardId shardId;

        SubReaderWrapper(ShardId shardId) {
            this.shardId = shardId;
        }

        public LeafReader wrap(LeafReader reader) {
            return new OpenSearchLeafReader(reader, this.shardId);
        }
    }
}

