/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.BitUtil;

public class ByteArrayIndexInput
extends IndexInput
implements RandomAccessInput {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private int pos;

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes) {
        this(resourceDesc, bytes, 0, bytes.length);
    }

    public ByteArrayIndexInput(String resourceDesc, byte[] bytes, int offset, int length) {
        super(resourceDesc);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.pos;
    }

    public void seek(long l) throws IOException {
        if (l < 0L) {
            throw new IllegalArgumentException("Seeking to negative position: " + this.pos);
        }
        if (l > (long)this.length) {
            throw new EOFException("seek past EOF");
        }
        this.pos = (int)l;
    }

    public long length() {
        return this.length;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        if (offset >= 0L && length >= 0L && offset + length <= (long)this.length) {
            return new ByteArrayIndexInput(sliceDescription, this.bytes, this.offset + (int)offset, (int)length);
        }
        throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: offset=" + offset + ",length=" + length + ",fileLength=" + this.length + ": " + String.valueOf((Object)this));
    }

    public byte readByte() throws IOException {
        this.validatePos(this.pos, 1);
        return this.bytes[this.offset + this.pos++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.validatePos(this.pos, len);
        System.arraycopy(this.bytes, this.offset + this.pos, b, offset, len);
        this.pos += len;
    }

    public byte readByte(long pos) throws IOException {
        this.validatePos(pos, 1);
        return this.bytes[this.offset + (int)pos];
    }

    public short readShort(long pos) throws IOException {
        this.validatePos(pos, 2);
        return BitUtil.VH_LE_SHORT.get(this.bytes, this.offset + (int)pos);
    }

    public int readInt(long pos) throws IOException {
        this.validatePos(pos, 4);
        return BitUtil.VH_LE_INT.get(this.bytes, this.offset + (int)pos);
    }

    public long readLong(long pos) throws IOException {
        this.validatePos(pos, 8);
        return BitUtil.VH_LE_LONG.get(this.bytes, this.offset + (int)pos);
    }

    private void validatePos(long pos, int len) throws EOFException {
        if (pos < 0L || pos + (long)len > (long)(this.length + this.offset)) {
            throw new EOFException("seek past EOF");
        }
    }
}

