/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.common.settings;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.OpenSearchParseException;
import org.opensearch.Version;
import org.opensearch.common.Booleans;
import org.opensearch.common.Nullable;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.regex.Regex;
import org.opensearch.common.settings.AbstractScopedSettings;
import org.opensearch.common.settings.SecureSetting;
import org.opensearch.common.settings.SecureSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.MemorySizeValue;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.common.unit.ByteSizeUnit;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.DeprecationHandler;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.MediaTypeRegistry;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;

@PublicApi(since="1.0.0")
public class Setting<T>
implements ToXContentObject {
    private final Key key;
    protected final Function<Settings, String> defaultValue;
    @Nullable
    protected final Setting<T> fallbackSetting;
    protected final Function<String, T> parser;
    protected final Validator<T> validator;
    private final EnumSet<Property> properties;
    private static final EnumSet<Property> EMPTY_PROPERTIES = EnumSet.noneOf(Property.class);

    private Setting(Key key, @Nullable Setting<T> fallbackSetting, Function<Settings, String> defaultValue, Function<String, T> parser, Validator<T> validator, Property ... properties) {
        assert (this instanceof SecureSetting || this.isGroupSetting() || parser.apply(defaultValue.apply(Settings.EMPTY)) != null) : "parser returned null";
        this.key = key;
        this.fallbackSetting = fallbackSetting;
        this.defaultValue = defaultValue;
        this.parser = parser;
        this.validator = validator;
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null for setting [" + String.valueOf(key) + "]");
        }
        if (properties.length == 0) {
            this.properties = EMPTY_PROPERTIES;
        } else {
            EnumSet<Property> propertiesAsSet = EnumSet.copyOf(Arrays.asList(properties));
            if (propertiesAsSet.contains((Object)Property.Dynamic) && propertiesAsSet.contains((Object)Property.Final)) {
                throw new IllegalArgumentException("final setting [" + String.valueOf(key) + "] cannot be dynamic");
            }
            this.checkPropertyRequiresIndexScope(propertiesAsSet, Property.NotCopyableOnResize);
            this.checkPropertyRequiresIndexScope(propertiesAsSet, Property.InternalIndex);
            this.checkPropertyRequiresIndexScope(propertiesAsSet, Property.PrivateIndex);
            this.checkPropertyRequiresNodeScope(propertiesAsSet, Property.Consistent);
            this.properties = propertiesAsSet;
        }
    }

    private void checkPropertyRequiresIndexScope(EnumSet<Property> properties, Property property) {
        if (properties.contains((Object)property) && !properties.contains((Object)Property.IndexScope)) {
            throw new IllegalArgumentException("non-index-scoped setting [" + String.valueOf(this.key) + "] can not have property [" + String.valueOf((Object)property) + "]");
        }
    }

    private void checkPropertyRequiresNodeScope(EnumSet<Property> properties, Property property) {
        if (properties.contains((Object)property) && !properties.contains((Object)Property.NodeScope)) {
            throw new IllegalArgumentException("non-node-scoped setting [" + String.valueOf(this.key) + "] can not have property [" + String.valueOf((Object)property) + "]");
        }
    }

    public Setting(Key key, Function<Settings, String> defaultValue, Function<String, T> parser, Property ... properties) {
        this(key, defaultValue, parser, (T v) -> {}, properties);
    }

    public Setting(Key key, Function<Settings, String> defaultValue, Function<String, T> parser, Validator<T> validator, Property ... properties) {
        this(key, null, defaultValue, parser, validator, properties);
    }

    public Setting(String key, String defaultValue, Function<String, T> parser, Property ... properties) {
        this(key, (Settings s) -> defaultValue, parser, properties);
    }

    public Setting(String key, String defaultValue, Function<String, T> parser, Validator<T> validator, Property ... properties) {
        this((Key)new SimpleKey(key), (Settings s) -> defaultValue, parser, validator, properties);
    }

    public Setting(String key, Function<Settings, String> defaultValue, Function<String, T> parser, Property ... properties) {
        this((Key)new SimpleKey(key), defaultValue, parser, properties);
    }

    public Setting(Key key, Setting<T> fallbackSetting, Function<String, T> parser, Property ... properties) {
        this(key, fallbackSetting, fallbackSetting::getRaw, parser, (T v) -> {}, properties);
    }

    public Setting(String key, Setting<T> fallBackSetting, Function<String, T> parser, Property ... properties) {
        this((Key)new SimpleKey(key), fallBackSetting, parser, properties);
    }

    public final String getKey() {
        return this.key.toString();
    }

    public final Key getRawKey() {
        return this.key;
    }

    public final boolean isDynamic() {
        return this.properties.contains((Object)Property.Dynamic);
    }

    public final boolean isFinal() {
        return this.properties.contains((Object)Property.Final);
    }

    public final boolean isInternalIndex() {
        return this.properties.contains((Object)Property.InternalIndex);
    }

    public final boolean isPrivateIndex() {
        return this.properties.contains((Object)Property.PrivateIndex);
    }

    public EnumSet<Property> getProperties() {
        return this.properties;
    }

    public boolean isFiltered() {
        return this.properties.contains((Object)Property.Filtered);
    }

    public boolean hasNodeScope() {
        return this.properties.contains((Object)Property.NodeScope);
    }

    public boolean isConsistent() {
        return this.properties.contains((Object)Property.Consistent);
    }

    public boolean hasIndexScope() {
        return this.properties.contains((Object)Property.IndexScope);
    }

    public boolean isDeprecated() {
        return this.properties.contains((Object)Property.Deprecated);
    }

    boolean isGroupSetting() {
        return false;
    }

    final boolean isListSetting() {
        return this instanceof ListSetting;
    }

    boolean hasComplexMatcher() {
        return this.isGroupSetting();
    }

    void validateWithoutDependencies(Settings settings) {
        this.validator.validate(this.get(settings, false));
    }

    public String getDefaultRaw(Settings settings) {
        return this.defaultValue.apply(settings);
    }

    public T getDefault(Settings settings) {
        return this.parser.apply(this.getDefaultRaw(settings));
    }

    public boolean exists(Settings settings) {
        return this.exists(settings.keySet());
    }

    public boolean exists(Settings.Builder builder) {
        return this.exists(builder.keys());
    }

    private boolean exists(Set<String> keys) {
        return keys.contains(this.getKey());
    }

    public boolean existsOrFallbackExists(Settings settings) {
        return settings.keySet().contains(this.getKey()) || this.fallbackSetting != null && this.fallbackSetting.existsOrFallbackExists(settings);
    }

    public T get(Settings settings) {
        return this.get(settings, true);
    }

    private T get(Settings settings, boolean validate) {
        String value = this.getRaw(settings);
        try {
            T parsed = this.parser.apply(value);
            if (validate) {
                Map<Setting<?>, Object> map;
                Iterator<Setting<?>> it = this.validator.settings();
                if (it.hasNext()) {
                    map = new HashMap();
                    while (it.hasNext()) {
                        Setting<?> setting = it.next();
                        if (setting instanceof AffixSetting) {
                            AffixSetting as = (AffixSetting)setting;
                            for (String ns : as.getNamespaces(settings)) {
                                Setting s = as.getConcreteSettingForNamespace(ns);
                                map.put(s, s.get(settings, false));
                            }
                            continue;
                        }
                        map.put(setting, setting.get(settings, false));
                    }
                } else {
                    map = Collections.emptyMap();
                }
                this.validator.validate(parsed);
                this.validator.validate(parsed, map);
                this.validator.validate(parsed, map, this.exists(settings));
            }
            return parsed;
        }
        catch (OpenSearchParseException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        catch (NumberFormatException ex) {
            String err = "Failed to parse value" + (String)(this.isFiltered() ? "" : " [" + value + "]") + " for setting [" + this.getKey() + "]";
            throw new IllegalArgumentException(err, ex);
        }
        catch (IllegalArgumentException ex) {
            throw ex;
        }
        catch (Exception t) {
            String err = "Failed to parse value" + (String)(this.isFiltered() ? "" : " [" + value + "]") + " for setting [" + this.getKey() + "]";
            throw new IllegalArgumentException(err, t);
        }
    }

    public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
        if (!this.exists(source)) {
            if (this.exists(defaultSettings)) {
                builder.put(this.getKey(), this.getRaw(defaultSettings));
            } else {
                builder.put(this.getKey(), this.getRaw(source));
            }
        }
    }

    private String getRaw(Settings settings) {
        this.checkDeprecation(settings);
        return this.innerGetRaw(settings);
    }

    String innerGetRaw(Settings settings) {
        SecureSettings secureSettings = settings.getSecureSettings();
        if (secureSettings != null && secureSettings.getSettingNames().contains(this.getKey())) {
            throw new IllegalArgumentException("Setting [" + this.getKey() + "] is a non-secure setting and must be stored inside opensearch.yml, but was found inside the OpenSearch keystore");
        }
        return settings.get(this.getKey(), this.defaultValue.apply(settings));
    }

    void checkDeprecation(Settings settings) {
        if (this.isDeprecated() && this.exists(settings)) {
            String key = this.getKey();
            Settings.DeprecationLoggerHolder.deprecationLogger.deprecate(key, "[{}] setting was deprecated in OpenSearch and will be removed in a future release! See the breaking changes documentation for the next major version.", key);
        }
    }

    public final boolean match(String toTest) {
        return this.key.match(toTest);
    }

    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("key", this.key.toString());
        builder.field("properties", this.properties);
        builder.field("is_group_setting", this.isGroupSetting());
        builder.field("default", this.defaultValue.apply(Settings.EMPTY));
        builder.endObject();
        return builder;
    }

    public String toString() {
        return Strings.toString((MediaType)MediaTypeRegistry.JSON, (ToXContent)this, (boolean)true, (boolean)true);
    }

    public final T get(Settings primary, Settings secondary) {
        if (this.exists(primary)) {
            return this.get(primary);
        }
        if (this.exists(secondary)) {
            return this.get(secondary);
        }
        if (this.fallbackSetting == null) {
            return this.get(primary);
        }
        if (this.fallbackSetting.exists(primary)) {
            return this.fallbackSetting.get(primary);
        }
        return this.fallbackSetting.get(secondary);
    }

    public Setting<T> getConcreteSetting(String key) {
        assert (key.startsWith(this.getKey())) : "was " + key + " expected: " + this.getKey();
        return this;
    }

    public Set<SettingDependency> getSettingsDependencies(String key) {
        return Collections.emptySet();
    }

    final AbstractScopedSettings.SettingUpdater<T> newUpdater(Consumer<T> consumer, Logger logger) {
        return this.newUpdater(consumer, logger, s -> {});
    }

    AbstractScopedSettings.SettingUpdater<T> newUpdater(Consumer<T> consumer, Logger logger, Consumer<T> validator) {
        if (this.isDynamic()) {
            return new Updater(consumer, logger, validator);
        }
        throw new IllegalStateException("setting [" + this.getKey() + "] is not dynamic");
    }

    static <A, B> AbstractScopedSettings.SettingUpdater<Tuple<A, B>> compoundUpdater(final BiConsumer<A, B> consumer, final BiConsumer<A, B> validator, final Setting<A> aSetting, final Setting<B> bSetting, final Logger logger) {
        final AbstractScopedSettings.SettingUpdater<A> aSettingUpdater = aSetting.newUpdater(null, logger);
        final AbstractScopedSettings.SettingUpdater<B> bSettingUpdater = bSetting.newUpdater(null, logger);
        return new AbstractScopedSettings.SettingUpdater<Tuple<A, B>>(){

            @Override
            public boolean hasChanged(Settings current, Settings previous) {
                return aSettingUpdater.hasChanged(current, previous) || bSettingUpdater.hasChanged(current, previous);
            }

            @Override
            public Tuple<A, B> getValue(Settings current, Settings previous) {
                Object valueA = aSettingUpdater.getValue(current, previous);
                Object valueB = bSettingUpdater.getValue(current, previous);
                validator.accept(valueA, valueB);
                return new Tuple(valueA, valueB);
            }

            @Override
            public void apply(Tuple<A, B> value, Settings current, Settings previous) {
                if (aSettingUpdater.hasChanged(current, previous)) {
                    Setting.logSettingUpdate(aSetting, current, previous, logger);
                }
                if (bSettingUpdater.hasChanged(current, previous)) {
                    Setting.logSettingUpdate(bSetting, current, previous, logger);
                }
                consumer.accept(value.v1(), value.v2());
            }

            public String toString() {
                return "CompoundUpdater for: " + String.valueOf(aSettingUpdater) + " and " + String.valueOf(bSettingUpdater);
            }
        };
    }

    static AbstractScopedSettings.SettingUpdater<Settings> groupedSettingsUpdater(Consumer<Settings> consumer, List<? extends Setting<?>> configuredSettings) {
        return Setting.groupedSettingsUpdater(consumer, configuredSettings, v -> {});
    }

    static AbstractScopedSettings.SettingUpdater<Settings> groupedSettingsUpdater(final Consumer<Settings> consumer, final List<? extends Setting<?>> configuredSettings, final Consumer<Settings> validator) {
        return new AbstractScopedSettings.SettingUpdater<Settings>(){

            private Settings get(Settings settings) {
                return settings.filter(s -> {
                    for (Setting setting : configuredSettings) {
                        if (!setting.key.match((String)s)) continue;
                        return true;
                    }
                    return false;
                });
            }

            @Override
            public boolean hasChanged(Settings current, Settings previous) {
                Settings previousSettings;
                Settings currentSettings = this.get(current);
                return !currentSettings.equals(previousSettings = this.get(previous));
            }

            @Override
            public Settings getValue(Settings current, Settings previous) {
                validator.accept(current);
                return this.get(current);
            }

            @Override
            public void apply(Settings value, Settings current, Settings previous) {
                consumer.accept(value);
            }

            public String toString() {
                return "Updater grouped: " + configuredSettings.stream().map(Setting::getKey).collect(Collectors.joining(", "));
            }
        };
    }

    public static Setting<Version> versionSetting(String key, Version defaultValue, Property ... properties) {
        return new Setting<Version>(key, s -> Integer.toString(defaultValue.id), s -> Version.fromId((int)Integer.parseInt(s)), properties);
    }

    private static boolean isFiltered(Property[] properties) {
        return properties != null && Arrays.asList(properties).contains((Object)Property.Filtered);
    }

    private static float parseFloat(String s, float minValue, float maxValue, String key, boolean isFiltered) {
        float value = Float.parseFloat(s);
        if (value < minValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
            throw new IllegalArgumentException(err);
        }
        if (value > maxValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be <= " + maxValue;
            throw new IllegalArgumentException(err);
        }
        return value;
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, Property ... properties) {
        return Setting.floatSetting(key, defaultValue, Float.MIN_VALUE, Float.MAX_VALUE, properties);
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, float minValue, Property ... properties) {
        return Setting.floatSetting(key, defaultValue, minValue, Float.MAX_VALUE, properties);
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, float minValue, float maxValue, Property ... properties) {
        return Setting.floatSetting(key, defaultValue, minValue, maxValue, (Float v) -> {}, properties);
    }

    public static Setting<Float> floatSetting(String key, float defaultValue, float minValue, float maxValue, Validator<Float> validator, Property ... properties) {
        return new Setting<Float>(key, Float.toString(defaultValue), new FloatParser(minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Float> floatSetting(String key, Setting<Float> fallbackSetting, Property ... properties) {
        return Setting.floatSetting(key, fallbackSetting, Float.MIN_VALUE, Float.MAX_VALUE, properties);
    }

    public static Setting<Float> floatSetting(String key, Setting<Float> fallbackSetting, float minValue, Property ... properties) {
        return Setting.floatSetting(key, fallbackSetting, minValue, Float.MAX_VALUE, properties);
    }

    public static Setting<Float> floatSetting(String key, Setting<Float> fallbackSetting, float minValue, float maxValue, Property ... properties) {
        return Setting.floatSetting(key, fallbackSetting, minValue, maxValue, (Float v) -> {}, properties);
    }

    public static Setting<Float> floatSetting(String key, Setting<Float> fallbackSetting, float minValue, float maxValue, Validator<Float> validator, Property ... properties) {
        return new Setting<Float>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, s -> Float.valueOf(Setting.parseFloat(s, minValue, maxValue, key, Setting.isFiltered(properties))), validator, properties);
    }

    public static int parseInt(String s, int minValue, String key) {
        return Setting.parseInt(s, minValue, Integer.MAX_VALUE, key);
    }

    public static int parseInt(String s, int minValue, int maxValue, String key) {
        return Setting.parseInt(s, minValue, maxValue, key, false);
    }

    public static int parseInt(String s, int minValue, int maxValue, String key, boolean isFiltered) {
        int value = Integer.parseInt(s);
        if (value < minValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
            throw new IllegalArgumentException(err);
        }
        if (value > maxValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be <= " + maxValue;
            throw new IllegalArgumentException(err);
        }
        return value;
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, Property ... properties) {
        return Setting.intSetting(key, defaultValue, Integer.MIN_VALUE, Integer.MAX_VALUE, properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, Property ... properties) {
        return Setting.intSetting(key, defaultValue, minValue, Integer.MAX_VALUE, properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, int maxValue, Property ... properties) {
        return Setting.intSetting(key, defaultValue, minValue, maxValue, (Integer v) -> {}, properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, Validator<Integer> validator, Property ... properties) {
        return Setting.intSetting(key, defaultValue, minValue, Integer.MAX_VALUE, validator, properties);
    }

    public static Setting<Integer> intSetting(String key, int defaultValue, int minValue, int maxValue, Validator<Integer> validator, Property ... properties) {
        return new Setting<Integer>(key, Integer.toString(defaultValue), new IntegerParser(minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, Property ... properties) {
        return Setting.intSetting(key, fallbackSetting, Integer.MIN_VALUE, Integer.MAX_VALUE, properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, Property ... properties) {
        return Setting.intSetting(key, fallbackSetting, minValue, Integer.MAX_VALUE, properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, int maxValue, Property ... properties) {
        return Setting.intSetting(key, fallbackSetting, minValue, maxValue, (Integer v) -> {}, properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, Validator<Integer> validator, Property ... properties) {
        return Setting.intSetting(key, fallbackSetting, minValue, Integer.MAX_VALUE, validator, properties);
    }

    public static Setting<Integer> intSetting(String key, Setting<Integer> fallbackSetting, int minValue, int maxValue, Validator<Integer> validator, Property ... properties) {
        return new Setting<Integer>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, s -> Setting.parseInt(s, minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    private static long parseLong(String s, long minValue, long maxValue, String key, boolean isFiltered) {
        long value = Long.parseLong(s);
        if (value < minValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
            throw new IllegalArgumentException(err);
        }
        if (value > maxValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be <= " + maxValue;
            throw new IllegalArgumentException(err);
        }
        return value;
    }

    public static Setting<Long> longSetting(String key, long defaultValue, Property ... properties) {
        return Setting.longSetting(key, defaultValue, Long.MIN_VALUE, Long.MAX_VALUE, properties);
    }

    public static Setting<Long> longSetting(String key, long defaultValue, long minValue, Property ... properties) {
        return Setting.longSetting(key, defaultValue, minValue, Long.MAX_VALUE, properties);
    }

    public static Setting<Long> longSetting(String key, long defaultValue, long minValue, long maxValue, Property ... properties) {
        return Setting.longSetting(key, defaultValue, minValue, maxValue, (Long v) -> {}, properties);
    }

    public static Setting<Long> longSetting(String key, long defaultValue, long minValue, long maxValue, Validator<Long> validator, Property ... properties) {
        return new Setting<Long>(key, Long.toString(defaultValue), new LongParser(minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Long> longSetting(String key, Setting<Long> fallbackSetting, Property ... properties) {
        return Setting.longSetting(key, fallbackSetting, Long.MIN_VALUE, Long.MAX_VALUE, properties);
    }

    public static Setting<Long> longSetting(String key, Setting<Long> fallbackSetting, long minValue, Property ... properties) {
        return Setting.longSetting(key, fallbackSetting, minValue, Long.MAX_VALUE, properties);
    }

    public static Setting<Long> longSetting(String key, Setting<Long> fallbackSetting, long minValue, long maxValue, Property ... properties) {
        return Setting.longSetting(key, fallbackSetting, minValue, maxValue, (Long v) -> {}, properties);
    }

    public static Setting<Long> longSetting(String key, Setting<Long> fallbackSetting, long minValue, Validator<Long> validator, Property ... properties) {
        return Setting.longSetting(key, fallbackSetting, minValue, Long.MAX_VALUE, validator, properties);
    }

    public static Setting<Long> longSetting(String key, Setting<Long> fallbackSetting, long minValue, long maxValue, Validator<Long> validator, Property ... properties) {
        return new Setting<Long>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, s -> Setting.parseLong(s, minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    private static double parseDouble(String s, double minValue, double maxValue, String key, boolean isFiltered) {
        double value = Double.parseDouble(s);
        if (value < minValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be >= " + minValue;
            throw new IllegalArgumentException(err);
        }
        if (value > maxValue) {
            String err = "Failed to parse value" + (String)(isFiltered ? "" : " [" + s + "]") + " for setting [" + key + "] must be <= " + maxValue;
            throw new IllegalArgumentException(err);
        }
        return value;
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, Property ... properties) {
        return Setting.doubleSetting(key, defaultValue, Double.MIN_VALUE, Double.MAX_VALUE, properties);
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, double minValue, Property ... properties) {
        return Setting.doubleSetting(key, defaultValue, minValue, Double.MAX_VALUE, properties);
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, double minValue, double maxValue, Property ... properties) {
        return Setting.doubleSetting(key, defaultValue, minValue, maxValue, (Double v) -> {}, properties);
    }

    public static Setting<Double> doubleSetting(String key, double defaultValue, double minValue, double maxValue, Validator<Double> validator, Property ... properties) {
        return new Setting<Double>(key, Double.toString(defaultValue), new DoubleParser(minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Double> doubleSetting(String key, Setting<Double> fallbackSetting, Property ... properties) {
        return Setting.doubleSetting(key, fallbackSetting, Double.MIN_VALUE, Double.MAX_VALUE, properties);
    }

    public static Setting<Double> doubleSetting(String key, Setting<Double> fallbackSetting, double minValue, Property ... properties) {
        return Setting.doubleSetting(key, fallbackSetting, minValue, Double.MAX_VALUE, properties);
    }

    public static Setting<Double> doubleSetting(String key, Setting<Double> fallbackSetting, double minValue, double maxValue, Property ... properties) {
        return Setting.doubleSetting(key, fallbackSetting, minValue, maxValue, (Double v) -> {}, properties);
    }

    public static Setting<Double> doubleSetting(String key, Setting<Double> fallbackSetting, double minValue, double maxValue, Validator<Double> validator, Property ... properties) {
        return new Setting<Double>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, s -> Setting.parseDouble(s, minValue, maxValue, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<String> simpleString(String key, Property ... properties) {
        return new Setting<String>(key, s -> "", Function.identity(), properties);
    }

    public static Setting<String> simpleString(String key, Validator<String> validator, Property ... properties) {
        return new Setting<String>((Key)new SimpleKey(key), null, s -> "", Function.identity(), validator, properties);
    }

    public static Setting<String> simpleString(String key, Validator<String> validator, Setting<String> fallback, Property ... properties) {
        return new Setting<String>((Key)new SimpleKey(key), fallback, fallback::getRaw, Function.identity(), validator, properties);
    }

    public static Setting<String> simpleString(String key, String defaultValue, Validator<String> validator, Property ... properties) {
        validator.validate(defaultValue);
        return new Setting<String>((Key)new SimpleKey(key), null, s -> defaultValue, Function.identity(), validator, properties);
    }

    public static Setting<String> simpleString(String key, Setting<String> fallback, Property ... properties) {
        return Setting.simpleString(key, fallback, Function.identity(), properties);
    }

    public static Setting<String> simpleString(String key, Setting<String> fallback, Function<String, String> parser, Property ... properties) {
        return new Setting<String>(key, fallback, parser, properties);
    }

    public static Setting<String> simpleString(String key, String defaultValue, Property ... properties) {
        return new Setting<String>(key, s -> defaultValue, Function.identity(), properties);
    }

    public static TimeValue parseTimeValue(String s, TimeValue minValue, String key) {
        TimeValue timeValue = TimeValue.parseTimeValue((String)s, null, (String)key);
        if (timeValue.millis() < minValue.millis()) {
            throw new IllegalArgumentException("Failed to parse value [" + s + "] for setting [" + key + "] must be >= " + String.valueOf(minValue));
        }
        return timeValue;
    }

    public static Setting<Boolean> boolSetting(String key, boolean defaultValue, Property ... properties) {
        return new Setting<Boolean>(key, s -> Boolean.toString(defaultValue), b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Boolean> boolSetting(String key, Setting<Boolean> fallbackSetting, Property ... properties) {
        return new Setting<Boolean>(key, fallbackSetting, b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), properties);
    }

    public static Setting<Boolean> boolSetting(String key, Setting<Boolean> fallbackSetting, Validator<Boolean> validator, Property ... properties) {
        return new Setting<Boolean>((Key)new SimpleKey(key), fallbackSetting, fallbackSetting::getRaw, b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Boolean> boolSetting(String key, boolean defaultValue, Validator<Boolean> validator, Property ... properties) {
        return new Setting<Boolean>(key, Boolean.toString(defaultValue), b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<Boolean> boolSetting(String key, Function<Settings, String> defaultValueFn, Property ... properties) {
        return new Setting<Boolean>(key, defaultValueFn, b -> Setting.parseBoolean(b, key, Setting.isFiltered(properties)), properties);
    }

    static boolean parseBoolean(String b, String key, boolean isFiltered) {
        try {
            return Booleans.parseBoolean((String)b);
        }
        catch (IllegalArgumentException ex) {
            if (isFiltered) {
                throw new IllegalArgumentException("Failed to parse value for setting [" + key + "]");
            }
            throw ex;
        }
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, ByteSizeValue value, Property ... properties) {
        return Setting.byteSizeSetting(key, (Settings s) -> value.getBytes() + ByteSizeUnit.BYTES.getSuffix(), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Setting<ByteSizeValue> fallbackSetting, Property ... properties) {
        return new Setting<ByteSizeValue>(key, fallbackSetting, new ByteSizeValueParser(key), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Function<Settings, String> defaultValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, new ByteSizeValueParser(key), properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, ByteSizeValue defaultValue, ByteSizeValue minValue, ByteSizeValue maxValue, Property ... properties) {
        return Setting.byteSizeSetting(key, (Settings s) -> defaultValue.getStringRep(), minValue, maxValue, properties);
    }

    public static Setting<ByteSizeValue> byteSizeSetting(String key, Function<Settings, String> defaultValue, ByteSizeValue minValue, ByteSizeValue maxValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, new ByteSizeValueParser(minValue, maxValue, key), properties);
    }

    public static ByteSizeValue parseByteSize(String s, ByteSizeValue minValue, ByteSizeValue maxValue, String key) {
        ByteSizeValue value = ByteSizeValue.parseBytesSizeValue((String)s, (String)key);
        if (value.getBytes() < minValue.getBytes()) {
            String message = String.format(Locale.ROOT, "failed to parse value [%s] for setting [%s], must be >= [%s]", s, key, minValue.getStringRep());
            throw new IllegalArgumentException(message);
        }
        if (value.getBytes() > maxValue.getBytes()) {
            String message = String.format(Locale.ROOT, "failed to parse value [%s] for setting [%s], must be <= [%s]", s, key, maxValue.getStringRep());
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, ByteSizeValue defaultValue, Property ... properties) {
        return Setting.memorySizeSetting(key, (Settings s) -> defaultValue.toString(), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, Function<Settings, String> defaultValue, Property ... properties) {
        return new Setting<ByteSizeValue>(key, defaultValue, new MemorySizeValueParser(key), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, String defaultPercentage, Property ... properties) {
        return new Setting<ByteSizeValue>(key, s -> defaultPercentage, new MemorySizeValueParser(key), properties);
    }

    public static Setting<ByteSizeValue> memorySizeSetting(String key, Setting<ByteSizeValue> fallbackSetting, Property ... properties) {
        return new Setting<ByteSizeValue>(key, fallbackSetting, s -> MemorySizeValue.parseBytesSizeValueOrHeapRatio(s, key), properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, List<String> defaultStringValue, Function<String, T> singleValueParser, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, (Settings s) -> defaultStringValue, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, List<String> defaultStringValue, Function<String, T> singleValueParser, Validator<List<T>> validator, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, (Settings s) -> defaultStringValue, validator, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Property ... properties) {
        return Setting.listSetting(key, fallbackSetting, singleValueParser, (Settings s) -> Setting.parseableStringToList(fallbackSetting.getRaw((Settings)s)), properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, defaultStringValue, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Validator<List<T>> validator, Property ... properties) {
        return Setting.listSetting(key, null, singleValueParser, defaultStringValue, validator, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, @Nullable Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Property ... properties) {
        return Setting.listSetting(key, fallbackSetting, singleValueParser, defaultStringValue, (List<T> v) -> {}, properties);
    }

    public static <T> Setting<List<T>> listSetting(String key, @Nullable Setting<List<T>> fallbackSetting, Function<String, T> singleValueParser, Function<Settings, List<String>> defaultStringValue, Validator<List<T>> validator, Property ... properties) {
        if (defaultStringValue.apply(Settings.EMPTY) == null) {
            throw new IllegalArgumentException("default value function must not return null");
        }
        Function parser = s -> Setting.parseableStringToList(s).stream().map(singleValueParser).collect(Collectors.toList());
        return new ListSetting<T>(key, fallbackSetting, defaultStringValue, parser, validator, properties);
    }

    private static List<String> parseableStringToList(String parsableString) {
        ArrayList<String> arrayList;
        block11: {
            XContentParser xContentParser = MediaTypeRegistry.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, parsableString);
            try {
                XContentParser.Token token = xContentParser.nextToken();
                if (token != XContentParser.Token.START_ARRAY) {
                    throw new IllegalArgumentException("expected START_ARRAY but got " + String.valueOf(token));
                }
                ArrayList<String> list = new ArrayList<String>();
                while ((token = xContentParser.nextToken()) != XContentParser.Token.END_ARRAY) {
                    if (token != XContentParser.Token.VALUE_STRING) {
                        throw new IllegalArgumentException("expected VALUE_STRING but got " + String.valueOf(token));
                    }
                    list.add(xContentParser.text());
                }
                arrayList = list;
                if (xContentParser == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (xContentParser != null) {
                        try {
                            xContentParser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("failed to parse array", e);
                }
            }
            xContentParser.close();
        }
        return arrayList;
    }

    private static String arrayToParsableString(List<String> array) {
        try {
            XContentBuilder builder = XContentBuilder.builder((XContent)MediaTypeRegistry.JSON.xContent());
            builder.startArray();
            for (String element : array) {
                builder.value(element);
            }
            builder.endArray();
            return builder.toString();
        }
        catch (IOException ex) {
            throw new OpenSearchException((Throwable)ex);
        }
    }

    static void logSettingUpdate(Setting setting, Settings current, Settings previous, Logger logger) {
        if (logger.isInfoEnabled()) {
            if (setting.isFiltered()) {
                logger.info("updating [{}]", (Object)setting.key);
            } else {
                logger.info("updating [{}] from [{}] to [{}]", (Object)setting.key, (Object)setting.getRaw(previous), (Object)setting.getRaw(current));
            }
        }
    }

    public static Setting<Settings> groupSetting(String key, Property ... properties) {
        return Setting.groupSetting(key, (Settings s) -> {}, properties);
    }

    public static Setting<Settings> groupSetting(String key, Consumer<Settings> validator, Property ... properties) {
        return new GroupSetting(key, validator, properties);
    }

    public static Setting<Settings> groupSetting(String key, Setting<Settings> fallback, Property ... properties) {
        return Setting.groupSetting(key, fallback, (Settings s) -> {}, properties);
    }

    public static Setting<Settings> groupSetting(String key, Setting<Settings> fallback, Consumer<Settings> validator, Property ... properties) {
        return new GroupSetting(key, fallback, validator, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallbackSetting, TimeValue minValue, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, fallbackSetting, fallbackSetting::getRaw, Setting.minTimeValueParser(key, minValue, Setting.isFiltered(properties)), v -> {}, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Function<Settings, TimeValue> defaultValue, TimeValue minValue, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, s -> ((TimeValue)defaultValue.apply((Settings)s)).getStringRep(), new MinTimeValueParser(key, minValue, Setting.isFiltered(properties)), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, TimeValue minValue, TimeValue maxValue, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, s -> defaultValue.getStringRep(), new MinMaxTimeValueParser(key, minValue, maxValue, Setting.isFiltered(properties)), properties);
    }

    private static Function<String, TimeValue> minTimeValueParser(String key, TimeValue minValue, boolean isFiltered) {
        return s -> {
            TimeValue value;
            try {
                value = TimeValue.parseTimeValue((String)s, null, (String)key);
            }
            catch (RuntimeException ex) {
                if (isFiltered) {
                    throw new IllegalArgumentException("failed to parse value for setting [" + key + "] as a time value");
                }
                throw ex;
            }
            if (value.millis() < minValue.millis()) {
                String message = String.format(Locale.ROOT, "failed to parse value%s for setting [%s], must be >= [%s]", isFiltered ? "" : " [" + s + "]", key, minValue.getStringRep());
                throw new IllegalArgumentException(message);
            }
            return value;
        };
    }

    private static Function<String, TimeValue> minMaxTimeValueParser(String key, TimeValue minValue, TimeValue maxValue, boolean isFiltered) {
        return s -> {
            TimeValue value;
            try {
                value = Setting.minTimeValueParser(key, minValue, isFiltered).apply((String)s);
            }
            catch (RuntimeException ex) {
                if (isFiltered) {
                    throw new IllegalArgumentException("failed to parse value for setting [" + key + "] as a time value");
                }
                throw ex;
            }
            if (value.millis() > maxValue.millis()) {
                String message = String.format(Locale.ROOT, "failed to parse value%s for setting [%s], must be <= [%s]", isFiltered ? "" : " [" + s + "]", key, maxValue.getStringRep());
                throw new IllegalArgumentException(message);
            }
            return value;
        };
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, TimeValue minValue, Property ... properties) {
        return Setting.timeSetting(key, (Settings s) -> defaultValue, minValue, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, Property ... properties) {
        return new Setting<TimeValue>(key, s -> defaultValue.getStringRep(), s -> TimeValue.parseTimeValue((String)s, (String)key), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallbackSetting, Property ... properties) {
        return new Setting<TimeValue>(key, fallbackSetting, s -> TimeValue.parseTimeValue((String)s, (String)key), properties);
    }

    public static Setting<TimeValue> timeSetting(String key, TimeValue defaultValue, TimeValue minValue, Validator<TimeValue> validator, Property ... properties) {
        SimpleKey simpleKey = new SimpleKey(key);
        return new Setting<TimeValue>((Key)simpleKey, s -> defaultValue.getStringRep(), Setting.minTimeValueParser(key, minValue, Setting.isFiltered(properties)), validator, properties);
    }

    public static Setting<TimeValue> timeSetting(String key, Setting<TimeValue> fallBackSetting, Validator<TimeValue> validator, Property ... properties) {
        return new Setting<TimeValue>((Key)new SimpleKey(key), fallBackSetting, fallBackSetting::getRaw, s -> TimeValue.parseTimeValue((String)s, (String)key), validator, properties);
    }

    public static Setting<TimeValue> positiveTimeSetting(String key, TimeValue defaultValue, Property ... properties) {
        return Setting.timeSetting(key, defaultValue, TimeValue.timeValueMillis((long)0L), properties);
    }

    public static Setting<TimeValue> positiveTimeSetting(String key, Setting<TimeValue> fallbackSetting, Property ... properties) {
        return Setting.timeSetting(key, fallbackSetting, TimeValue.timeValueMillis((long)0L), properties);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Setting setting = (Setting)o;
        return Objects.equals(this.key, setting.key);
    }

    public int hashCode() {
        return Objects.hash(this.key);
    }

    public static <T> AffixSetting<T> prefixKeySetting(String prefix, Function<String, Setting<T>> delegateFactory) {
        BiFunction<String, String, Setting<T>> delegateFactoryWithNamespace = (ns, k) -> (Setting)delegateFactory.apply((String)k);
        return Setting.affixKeySetting(new AffixKey(prefix), delegateFactoryWithNamespace, new AffixSettingDependency[0]);
    }

    public static <T> AffixSetting<T> affixKeySetting(String prefix, String suffix, Function<String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
        BiFunction<String, String, Setting<T>> delegateFactoryWithNamespace = (ns, k) -> (Setting)delegateFactory.apply((String)k);
        return Setting.affixKeySetting(new AffixKey(prefix, suffix), delegateFactoryWithNamespace, dependencies);
    }

    public static <T> AffixSetting<T> affixKeySetting(String prefix, String suffix, BiFunction<String, String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
        Setting<T> delegate = delegateFactory.apply("_na_", "_na_");
        return new AffixSetting<T>(new AffixKey(prefix, suffix), delegate, delegateFactory, dependencies);
    }

    private static <T> AffixSetting<T> affixKeySetting(AffixKey key, BiFunction<String, String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
        Setting<T> delegate = delegateFactory.apply("_na_", "_na_");
        return new AffixSetting<T>(key, delegate, delegateFactory, dependencies);
    }

    @PublicApi(since="1.0.0")
    public static interface Key {
        public boolean match(String var1);
    }

    @FunctionalInterface
    @PublicApi(since="1.0.0")
    public static interface Validator<T> {
        public void validate(T var1);

        default public void validate(T value, Map<Setting<?>, Object> settings) {
        }

        default public void validate(T value, Map<Setting<?>, Object> settings, boolean isPresent) {
        }

        default public Iterator<Setting<?>> settings() {
            return Collections.emptyIterator();
        }
    }

    @PublicApi(since="1.0.0")
    public static enum Property {
        Filtered,
        Dynamic,
        Final,
        Deprecated,
        NodeScope,
        Consistent,
        IndexScope,
        NotCopyableOnResize,
        InternalIndex,
        PrivateIndex,
        ExtensionScope;

    }

    @PublicApi(since="1.0.0")
    public static class SimpleKey
    implements Key {
        protected final String key;

        public SimpleKey(String key) {
            this.key = key;
        }

        @Override
        public boolean match(String key) {
            return this.key.equals(key);
        }

        public String toString() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleKey simpleKey = (SimpleKey)o;
            return Objects.equals(this.key, simpleKey.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    private static class ListSetting<T>
    extends Setting<List<T>> {
        private final Function<Settings, List<String>> defaultStringValue;

        private ListSetting(String key, @Nullable Setting<List<T>> fallbackSetting, Function<Settings, List<String>> defaultStringValue, Function<String, List<T>> parser, Validator<List<T>> validator, Property ... properties) {
            super((Key)new ListKey(key), fallbackSetting, (Settings s) -> Setting.arrayToParsableString((List)defaultStringValue.apply((Settings)s)), parser, validator, properties);
            this.defaultStringValue = defaultStringValue;
        }

        @Override
        String innerGetRaw(Settings settings) {
            List<String> array = settings.getAsList(this.getKey(), null);
            return array == null ? (String)this.defaultValue.apply(settings) : Setting.arrayToParsableString(array);
        }

        @Override
        boolean hasComplexMatcher() {
            return true;
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            if (!this.exists(source)) {
                List<String> asList = defaultSettings.getAsList(this.getKey(), null);
                if (asList == null) {
                    builder.putList(this.getKey(), this.defaultStringValue.apply(defaultSettings));
                } else {
                    builder.putList(this.getKey(), asList);
                }
            }
        }
    }

    @PublicApi(since="1.0.0")
    public static class AffixSetting<T>
    extends Setting<T> {
        private final AffixKey key;
        private final BiFunction<String, String, Setting<T>> delegateFactory;
        private final Set<AffixSettingDependency> dependencies;

        public AffixSetting(AffixKey key, Setting<T> delegate, BiFunction<String, String, Setting<T>> delegateFactory, AffixSettingDependency ... dependencies) {
            super((Key)key, delegate.defaultValue, delegate.parser, delegate.properties.toArray(new Property[0]));
            this.key = key;
            this.delegateFactory = delegateFactory;
            this.dependencies = Collections.unmodifiableSet(new HashSet<AffixSettingDependency>(Arrays.asList(dependencies)));
        }

        @Override
        boolean isGroupSetting() {
            return true;
        }

        private Stream<String> matchStream(Settings settings) {
            return settings.keySet().stream().filter(this::match).map(this.key::getConcreteString);
        }

        public Set<AffixSettingDependency> getDependencies() {
            return Collections.unmodifiableSet(this.dependencies);
        }

        @Override
        public Set<SettingDependency> getSettingsDependencies(String settingsKey) {
            if (this.dependencies.isEmpty()) {
                return Collections.emptySet();
            }
            String namespace = this.key.getNamespace(settingsKey);
            return this.dependencies.stream().map(s -> new SettingDependency(){
                final /* synthetic */ AffixSettingDependency val$s;
                final /* synthetic */ String val$namespace;
                {
                    this.val$s = affixSettingDependency;
                    this.val$namespace = string;
                }

                @Override
                public Setting<Object> getSetting() {
                    return this.val$s.getSetting().getConcreteSettingForNamespace(this.val$namespace);
                }

                @Override
                public void validate(String key, Object value, Object dependency) {
                    this.val$s.validate(key, value, dependency);
                }
            }).collect(Collectors.toSet());
        }

        AbstractScopedSettings.SettingUpdater<Map<AbstractScopedSettings.SettingUpdater<T>, T>> newAffixUpdater(final BiConsumer<String, T> consumer, final Logger logger, final BiConsumer<String, T> validator) {
            return new AbstractScopedSettings.SettingUpdater<Map<AbstractScopedSettings.SettingUpdater<T>, T>>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    return Stream.concat(this.matchStream(current), this.matchStream(previous)).findAny().isPresent();
                }

                @Override
                public Map<AbstractScopedSettings.SettingUpdater<T>, T> getValue(Settings current, Settings previous) {
                    IdentityHashMap result = new IdentityHashMap();
                    Stream.concat(this.matchStream(current), this.matchStream(previous)).distinct().forEach(aKey -> {
                        String namespace = key.getNamespace((String)aKey);
                        Setting<Object> concreteSetting = this.getConcreteSetting(namespace, (String)aKey);
                        AbstractScopedSettings.SettingUpdater<Object> updater = concreteSetting.newUpdater(v -> consumer.accept(namespace, v), logger, v -> validator.accept(namespace, v));
                        if (updater.hasChanged(current, previous)) {
                            Object value = updater.getValue(current, previous);
                            result.put(updater, value);
                        }
                    });
                    return result;
                }

                @Override
                public void apply(Map<AbstractScopedSettings.SettingUpdater<T>, T> value, Settings current, Settings previous) {
                    for (Map.Entry entry : value.entrySet()) {
                        entry.getKey().apply(entry.getValue(), current, previous);
                    }
                }
            };
        }

        AbstractScopedSettings.SettingUpdater<Map<String, T>> newAffixMapUpdater(final Consumer<Map<String, T>> consumer, final Logger logger, final BiConsumer<String, T> validator) {
            return new AbstractScopedSettings.SettingUpdater<Map<String, T>>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    return !current.filter(k -> this.match((String)k)).equals(previous.filter(k -> this.match((String)k)));
                }

                @Override
                public Map<String, T> getValue(Settings current, Settings previous) {
                    IdentityHashMap result = new IdentityHashMap();
                    Stream.concat(this.matchStream(current), this.matchStream(previous)).distinct().forEach(aKey -> {
                        String namespace = key.getNamespace((String)aKey);
                        Setting<Object> concreteSetting = this.getConcreteSetting(namespace, (String)aKey);
                        AbstractScopedSettings.SettingUpdater<Object> updater = concreteSetting.newUpdater(v -> {}, logger, v -> validator.accept(namespace, v));
                        if (updater.hasChanged(current, previous)) {
                            Object value = updater.getValue(current, previous);
                            result.put(namespace, value);
                        }
                    });
                    return result;
                }

                @Override
                public void apply(Map<String, T> value, Settings current, Settings previous) {
                    consumer.accept(value);
                }
            };
        }

        @Override
        public T get(Settings settings) {
            throw new UnsupportedOperationException("affix settings can't return values use #getConcreteSetting to obtain a concrete setting");
        }

        @Override
        public String innerGetRaw(Settings settings) {
            throw new UnsupportedOperationException("affix settings can't return values use #getConcreteSetting to obtain a concrete setting");
        }

        @Override
        public Setting<T> getConcreteSetting(String key) {
            if (this.match(key)) {
                String namespace = this.key.getNamespace(key);
                return this.delegateFactory.apply(namespace, key);
            }
            throw new IllegalArgumentException("key [" + key + "] must match [" + this.getKey() + "] but didn't.");
        }

        private Setting<T> getConcreteSetting(String namespace, String key) {
            if (this.match(key)) {
                return this.delegateFactory.apply(namespace, key);
            }
            throw new IllegalArgumentException("key [" + key + "] must match [" + this.getKey() + "] but didn't.");
        }

        public Setting<T> getConcreteSettingForNamespace(String namespace) {
            String fullKey = this.key.toConcreteKey(namespace).toString();
            return this.getConcreteSetting(namespace, fullKey);
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            this.matchStream(defaultSettings).forEach(key -> this.getConcreteSetting((String)key).diff(builder, source, defaultSettings));
        }

        public String getNamespace(Setting<T> concreteSetting) {
            return this.key.getNamespace(concreteSetting.getKey());
        }

        public Stream<Setting<T>> getAllConcreteSettings(Settings settings) {
            return this.matchStream(settings).distinct().map(this::getConcreteSetting);
        }

        public Set<String> getNamespaces(Settings settings) {
            return settings.keySet().stream().filter(this::match).map(this.key::getNamespace).collect(Collectors.toSet());
        }

        public Map<String, T> getAsMap(Settings settings) {
            HashMap map = new HashMap();
            this.matchStream(settings).distinct().forEach(key -> {
                String namespace = this.key.getNamespace((String)key);
                Setting<T> concreteSetting = this.getConcreteSetting(namespace, (String)key);
                map.put(namespace, concreteSetting.get(settings));
            });
            return Collections.unmodifiableMap(map);
        }
    }

    private final class Updater
    implements AbstractScopedSettings.SettingUpdater<T> {
        private final Consumer<T> consumer;
        private final Logger logger;
        private final Consumer<T> accept;

        Updater(Consumer<T> consumer, Logger logger, Consumer<T> accept) {
            this.consumer = consumer;
            this.logger = logger;
            this.accept = accept;
        }

        public String toString() {
            return "Updater for: " + Setting.this.toString();
        }

        @Override
        public boolean hasChanged(Settings current, Settings previous) {
            String newValue = Setting.this.getRaw(current);
            String value = Setting.this.getRaw(previous);
            assert (!Setting.this.isGroupSetting()) : "group settings must override this method";
            assert (value != null) : "value was null but can't be unless default is null which is invalid";
            return !value.equals(newValue);
        }

        @Override
        public T getValue(Settings current, Settings previous) {
            String newValue = Setting.this.getRaw(current);
            String value = Setting.this.getRaw(previous);
            try {
                Object inst = Setting.this.get(current);
                this.accept.accept(inst);
                return inst;
            }
            catch (AssertionError | Exception e) {
                if (Setting.this.isFiltered()) {
                    throw new IllegalArgumentException("illegal value can't update [" + String.valueOf(Setting.this.key) + "]");
                }
                throw new IllegalArgumentException("illegal value can't update [" + String.valueOf(Setting.this.key) + "] from [" + value + "] to [" + newValue + "]", (Throwable)e);
            }
        }

        @Override
        public void apply(T value, Settings current, Settings previous) {
            Setting.logSettingUpdate(Setting.this, current, previous, this.logger);
            this.consumer.accept(value);
        }
    }

    public static class FloatParser
    implements Function<String, Float>,
    Writeable {
        private float minValue;
        private float maxValue;
        private String key;
        private boolean isFiltered;

        public FloatParser(float minValue, float maxValue, String key, boolean isFiltered) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.key = key;
            this.isFiltered = isFiltered;
        }

        public FloatParser(StreamInput in) throws IOException {
            this.minValue = in.readFloat();
            this.maxValue = in.readFloat();
            this.key = in.readString();
            this.isFiltered = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeFloat(this.minValue);
            out.writeFloat(this.maxValue);
            out.writeString(this.key);
            out.writeBoolean(this.isFiltered);
        }

        public float getMin() {
            return this.minValue;
        }

        public float getMax() {
            return this.maxValue;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getFilterStatus() {
            return this.isFiltered;
        }

        @Override
        public Float apply(String s) {
            return Float.valueOf(Setting.parseFloat(s, this.minValue, this.maxValue, this.key, this.isFiltered));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FloatParser that = (FloatParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(Float.valueOf(this.minValue), Float.valueOf(that.minValue)) && Objects.equals(Float.valueOf(this.maxValue), Float.valueOf(that.maxValue)) && Objects.equals(this.isFiltered, that.isFiltered);
        }

        public int hashCode() {
            return Objects.hash(Float.valueOf(this.minValue), Float.valueOf(this.maxValue), this.key, this.isFiltered);
        }
    }

    public static class IntegerParser
    implements Function<String, Integer>,
    Writeable {
        private String key;
        private int minValue;
        private int maxValue;
        private boolean isFiltered;

        public IntegerParser(int minValue, int maxValue, String key, boolean isFiltered) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.key = key;
            this.isFiltered = isFiltered;
        }

        public IntegerParser(StreamInput in) throws IOException {
            this.minValue = in.readInt();
            this.maxValue = in.readInt();
            this.key = in.readString();
            this.isFiltered = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeInt(this.minValue);
            out.writeInt(this.maxValue);
            out.writeString(this.key);
            out.writeBoolean(this.isFiltered);
        }

        public int getMin() {
            return this.minValue;
        }

        public int getMax() {
            return this.maxValue;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getFilterStatus() {
            return this.isFiltered;
        }

        @Override
        public Integer apply(String s) {
            return Setting.parseInt(s, this.minValue, this.maxValue, this.key, this.isFiltered);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            IntegerParser that = (IntegerParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.isFiltered, that.isFiltered);
        }

        public int hashCode() {
            return Objects.hash(this.minValue, this.maxValue, this.key, this.isFiltered);
        }
    }

    public static class LongParser
    implements Function<String, Long>,
    Writeable {
        private String key;
        private long minValue;
        private long maxValue;
        private boolean isFiltered;

        public LongParser(long minValue, long maxValue, String key, boolean isFiltered) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.key = key;
            this.isFiltered = isFiltered;
        }

        public LongParser(StreamInput in) throws IOException {
            this.minValue = in.readLong();
            this.maxValue = in.readLong();
            this.key = in.readString();
            this.isFiltered = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeLong(this.minValue);
            out.writeLong(this.maxValue);
            out.writeString(this.key);
            out.writeBoolean(this.isFiltered);
        }

        public long getMin() {
            return this.minValue;
        }

        public long getMax() {
            return this.maxValue;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getFilterStatus() {
            return this.isFiltered;
        }

        @Override
        public Long apply(String s) {
            return Setting.parseLong(s, this.minValue, this.maxValue, this.key, this.isFiltered);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            LongParser that = (LongParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.isFiltered, that.isFiltered);
        }

        public int hashCode() {
            return Objects.hash(this.minValue, this.maxValue, this.key, this.isFiltered);
        }
    }

    public static class DoubleParser
    implements Function<String, Double>,
    Writeable {
        private double minValue;
        private double maxValue;
        private String key;
        private boolean isFiltered;

        public DoubleParser(double minValue, double maxValue, String key, boolean isFiltered) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.key = key;
            this.isFiltered = isFiltered;
        }

        public DoubleParser(StreamInput in) throws IOException {
            this.minValue = in.readDouble();
            this.maxValue = in.readDouble();
            this.key = in.readString();
            this.isFiltered = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeDouble(this.minValue);
            out.writeDouble(this.maxValue);
            out.writeString(this.key);
            out.writeBoolean(this.isFiltered);
        }

        public double getMin() {
            return this.minValue;
        }

        public double getMax() {
            return this.maxValue;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getFilterStatus() {
            return this.isFiltered;
        }

        @Override
        public Double apply(String s) {
            return Setting.parseDouble(s, this.minValue, this.maxValue, this.key, this.isFiltered);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            DoubleParser that = (DoubleParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.isFiltered, that.isFiltered);
        }

        public int hashCode() {
            return Objects.hash(this.minValue, this.maxValue, this.key, this.isFiltered);
        }
    }

    public static class ByteSizeValueParser
    implements Function<String, ByteSizeValue>,
    Writeable {
        private ByteSizeValue minValue;
        private ByteSizeValue maxValue;
        private String key;

        public ByteSizeValueParser(ByteSizeValue minValue, ByteSizeValue maxValue, String key) {
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.key = key;
        }

        public ByteSizeValueParser(String key) {
            this(new ByteSizeValue(-1L), new ByteSizeValue(Long.MAX_VALUE), key);
        }

        public ByteSizeValueParser(StreamInput in) throws IOException {
            this.minValue = new ByteSizeValue(in);
            this.maxValue = new ByteSizeValue(in);
            this.key = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.minValue.writeTo(out);
            this.maxValue.writeTo(out);
            out.writeString(this.key);
        }

        public ByteSizeValue getMin() {
            return this.minValue;
        }

        public ByteSizeValue getMax() {
            return this.maxValue;
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public ByteSizeValue apply(String s) {
            return Setting.parseByteSize(s, this.minValue, this.maxValue, this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            ByteSizeValueParser that = (ByteSizeValueParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.minValue, this.maxValue);
        }
    }

    public static class MemorySizeValueParser
    implements Function<String, ByteSizeValue>,
    Writeable {
        private String key;

        public MemorySizeValueParser(String key) {
            this.key = key;
        }

        public MemorySizeValueParser(StreamInput in) throws IOException {
            this.key = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public ByteSizeValue apply(String s) {
            return MemorySizeValue.parseBytesSizeValueOrHeapRatio(s, this.key);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MemorySizeValueParser that = (MemorySizeValueParser)obj;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }
    }

    private static class GroupSetting
    extends Setting<Settings> {
        private final String key;
        private final Consumer<Settings> validator;

        private GroupSetting(String key, Consumer<Settings> validator, Property ... properties) {
            super((Key)new GroupKey(key), (Settings s) -> "", (String s) -> null, properties);
            this.key = key;
            this.validator = validator;
        }

        private GroupSetting(String key, Setting<Settings> fallback, Consumer<Settings> validator, Property ... properties) {
            super((Key)new GroupKey(key), fallback, (String s) -> null, properties);
            this.key = key;
            this.validator = validator;
        }

        @Override
        public boolean isGroupSetting() {
            return true;
        }

        @Override
        public String innerGetRaw(Settings settings) {
            Settings subSettings = this.get(settings);
            try {
                XContentBuilder builder = XContentFactory.jsonBuilder();
                builder.startObject();
                subSettings.toXContent(builder, EMPTY_PARAMS);
                builder.endObject();
                return builder.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Settings get(Settings settings) {
            Settings byPrefix = settings.getByPrefix(this.getKey());
            if (byPrefix.size() == 0 && this.fallbackSetting != null) {
                byPrefix = (Settings)this.fallbackSetting.get(settings);
            }
            this.validator.accept(byPrefix);
            return byPrefix;
        }

        @Override
        public boolean exists(Settings settings) {
            for (String settingsKey : settings.keySet()) {
                if (!settingsKey.startsWith(this.key)) continue;
                return true;
            }
            if (this.fallbackSetting != null) {
                return this.fallbackSetting.exists(settings);
            }
            return false;
        }

        @Override
        public void diff(Settings.Builder builder, Settings source, Settings defaultSettings) {
            Set<String> leftGroup = this.get(source).keySet();
            Settings defaultGroup = this.get(defaultSettings);
            builder.put(Settings.builder().put(defaultGroup.filter(k -> !leftGroup.contains(k)), false).normalizePrefix(this.getKey()).build(), false);
        }

        @Override
        public AbstractScopedSettings.SettingUpdater<Settings> newUpdater(final Consumer<Settings> consumer, final Logger logger, final Consumer<Settings> validator) {
            if (!this.isDynamic()) {
                throw new IllegalStateException("setting [" + this.getKey() + "] is not dynamic");
            }
            final GroupSetting setting = this;
            return new AbstractScopedSettings.SettingUpdater<Settings>(){

                @Override
                public boolean hasChanged(Settings current, Settings previous) {
                    Settings previousSettings;
                    Settings currentSettings = this.get(current);
                    return !currentSettings.equals(previousSettings = this.get(previous));
                }

                @Override
                public Settings getValue(Settings current, Settings previous) {
                    Settings currentSettings = this.get(current);
                    Settings previousSettings = this.get(previous);
                    try {
                        validator.accept(currentSettings);
                    }
                    catch (AssertionError | Exception e) {
                        String err = "illegal value can't update [" + key + "]" + (String)(this.isFiltered() ? "" : " from [" + String.valueOf(previousSettings) + "] to [" + String.valueOf(currentSettings) + "]");
                        throw new IllegalArgumentException(err, (Throwable)e);
                    }
                    return currentSettings;
                }

                @Override
                public void apply(Settings value, Settings current, Settings previous) {
                    Setting.logSettingUpdate(this, current, previous, logger);
                    consumer.accept(value);
                }

                public String toString() {
                    return "Updater for: " + setting.toString();
                }
            };
        }
    }

    public static class MinTimeValueParser
    implements Function<String, TimeValue>,
    Writeable {
        private String key;
        private TimeValue minValue;
        private boolean isFiltered;

        public MinTimeValueParser(String key, TimeValue minValue, boolean isFiltered) {
            this.key = key;
            this.minValue = minValue;
            this.isFiltered = isFiltered;
        }

        public MinTimeValueParser(StreamInput in) throws IOException {
            this.key = in.readString();
            this.minValue = in.readTimeValue();
            this.isFiltered = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeTimeValue(this.minValue);
            out.writeBoolean(this.isFiltered);
        }

        public TimeValue getMin() {
            return this.minValue;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getFilterStatus() {
            return this.isFiltered;
        }

        @Override
        public TimeValue apply(String s) {
            return Setting.minTimeValueParser(this.key, this.minValue, this.isFiltered).apply(s);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MinTimeValueParser that = (MinTimeValueParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.isFiltered, that.isFiltered);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.minValue, this.isFiltered);
        }
    }

    public static class MinMaxTimeValueParser
    implements Function<String, TimeValue>,
    Writeable {
        private String key;
        private TimeValue minValue;
        private TimeValue maxValue;
        private boolean isFiltered;

        public MinMaxTimeValueParser(String key, TimeValue minValue, TimeValue maxValue, boolean isFiltered) {
            this.key = key;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.isFiltered = isFiltered;
        }

        public MinMaxTimeValueParser(StreamInput in) throws IOException {
            this.key = in.readString();
            this.minValue = in.readTimeValue();
            this.maxValue = in.readTimeValue();
            this.isFiltered = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.key);
            out.writeTimeValue(this.minValue);
            out.writeTimeValue(this.maxValue);
            out.writeBoolean(this.isFiltered);
        }

        public TimeValue getMin() {
            return this.minValue;
        }

        public TimeValue getMax() {
            return this.maxValue;
        }

        public String getKey() {
            return this.key;
        }

        public boolean getFilterStatus() {
            return this.isFiltered;
        }

        @Override
        public TimeValue apply(String s) {
            return Setting.minMaxTimeValueParser(this.key, this.minValue, this.maxValue, this.isFiltered).apply(s);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MinMaxTimeValueParser that = (MinMaxTimeValueParser)obj;
            return Objects.equals(this.key, that.key) && Objects.equals(this.minValue, that.minValue) && Objects.equals(this.maxValue, that.maxValue) && Objects.equals(this.isFiltered, that.isFiltered);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.minValue, this.maxValue, this.isFiltered);
        }
    }

    @PublicApi(since="1.0.0")
    public static final class AffixKey
    implements Key {
        private final Pattern pattern;
        private final String prefix;
        private final String suffix;

        AffixKey(String prefix) {
            this(prefix, null);
        }

        AffixKey(String prefix, String suffix) {
            assert (prefix != null || suffix != null) : "Either prefix or suffix must be non-null";
            this.prefix = prefix;
            if (!prefix.endsWith(".")) {
                throw new IllegalArgumentException("prefix must end with a '.'");
            }
            this.suffix = suffix;
            this.pattern = suffix == null ? Pattern.compile("(" + Pattern.quote(prefix) + "((?:[-\\w]+[.])*[-\\w]+$))") : Pattern.compile("(" + Pattern.quote(prefix) + "([-\\w]+)\\." + Pattern.quote(suffix) + ")(?:\\..*)?");
        }

        @Override
        public boolean match(String key) {
            return this.pattern.matcher(key).matches();
        }

        String getConcreteString(String key) {
            Matcher matcher = this.pattern.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalStateException("can't get concrete string for key " + key + " key doesn't match");
            }
            return matcher.group(1);
        }

        String getNamespace(String key) {
            Matcher matcher = this.pattern.matcher(key);
            if (!matcher.matches()) {
                throw new IllegalStateException("can't get concrete string for key " + key + " key doesn't match");
            }
            return matcher.group(2);
        }

        public SimpleKey toConcreteKey(String missingPart) {
            StringBuilder key = new StringBuilder();
            if (this.prefix != null) {
                key.append(this.prefix);
            }
            key.append(missingPart);
            if (this.suffix != null) {
                key.append(".");
                key.append(this.suffix);
            }
            return new SimpleKey(key.toString());
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.prefix != null) {
                sb.append(this.prefix);
            }
            if (this.suffix != null) {
                sb.append('*');
                sb.append('.');
                sb.append(this.suffix);
            }
            return sb.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AffixKey that = (AffixKey)o;
            return Objects.equals(this.prefix, that.prefix) && Objects.equals(this.suffix, that.suffix);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.suffix);
        }
    }

    @PublicApi(since="1.0.0")
    public static interface AffixSettingDependency
    extends SettingDependency {
        @Override
        public AffixSetting getSetting();
    }

    public static final class ListKey
    extends SimpleKey {
        private final Pattern pattern;

        public ListKey(String key) {
            super(key);
            this.pattern = Pattern.compile(Pattern.quote(key) + "(\\.\\d+)?");
        }

        @Override
        public boolean match(String toTest) {
            return this.pattern.matcher(toTest).matches();
        }
    }

    public static final class GroupKey
    extends SimpleKey {
        public GroupKey(String key) {
            super(key);
            if (!key.endsWith(".")) {
                throw new IllegalArgumentException("key must end with a '.'");
            }
        }

        @Override
        public boolean match(String toTest) {
            return Regex.simpleMatch(this.key + "*", toTest);
        }
    }

    public static class RegexValidator
    implements Writeable,
    Validator<String> {
        private Pattern pattern;
        private boolean isMatching;

        public RegexValidator(String regex) {
            this(regex, true);
        }

        public RegexValidator(String regex, boolean isMatching) {
            this.pattern = Pattern.compile(regex);
            this.isMatching = isMatching;
        }

        public RegexValidator(StreamInput in) throws IOException {
            this.pattern = Pattern.compile(in.readString());
            this.isMatching = in.readBoolean();
        }

        Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public void validate(String value) {
            if (this.isMatching && !this.pattern.matcher(value).find()) {
                throw new IllegalArgumentException("Setting [" + value + "] does not match regex [" + this.pattern.pattern() + "]");
            }
            if (!this.isMatching && this.pattern.matcher(value).find()) {
                throw new IllegalArgumentException("Setting [" + value + "] must match regex [" + this.pattern.pattern() + "]");
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.pattern.pattern());
            out.writeBoolean(this.isMatching);
        }
    }

    @PublicApi(since="1.0.0")
    public static interface SettingDependency {
        public Setting getSetting();

        default public void validate(String key, Object value, Object dependency) {
        }
    }
}

