/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.query;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;
import org.opensearch.common.SetOnce;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilderVisitor;

public final class QueryShapeVisitor
implements QueryBuilderVisitor {
    private final SetOnce<String> queryType = new SetOnce();
    private final Map<BooleanClause.Occur, List<QueryShapeVisitor>> childVisitors = new EnumMap<BooleanClause.Occur, List<QueryShapeVisitor>>(BooleanClause.Occur.class);

    @Override
    public void accept(QueryBuilder qb) {
        this.queryType.set((Object)qb.getName());
    }

    @Override
    public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
        if (this.childVisitors.containsKey(occur)) {
            throw new IllegalStateException("child visitor already called for " + String.valueOf(occur));
        }
        final ArrayList childVisitorList = new ArrayList();
        QueryBuilderVisitor childVisitorWrapper = new QueryBuilderVisitor(){
            QueryShapeVisitor currentChild;

            @Override
            public void accept(QueryBuilder qb) {
                this.currentChild = new QueryShapeVisitor();
                childVisitorList.add(this.currentChild);
                this.currentChild.accept(qb);
            }

            @Override
            public QueryBuilderVisitor getChildVisitor(BooleanClause.Occur occur) {
                return this.currentChild.getChildVisitor(occur);
            }
        };
        this.childVisitors.put(occur, childVisitorList);
        return childVisitorWrapper;
    }

    String toJson() {
        StringBuilder outputBuilder = new StringBuilder("{\"type\":\"").append((String)this.queryType.get()).append("\"");
        for (Map.Entry<BooleanClause.Occur, List<QueryShapeVisitor>> entry : this.childVisitors.entrySet()) {
            outputBuilder.append(",\"").append(entry.getKey().name().toLowerCase(Locale.ROOT)).append("\"[");
            boolean first = true;
            for (QueryShapeVisitor child : entry.getValue()) {
                if (!first) {
                    outputBuilder.append(",");
                }
                outputBuilder.append(child.toJson());
                first = false;
            }
            outputBuilder.append("]");
        }
        outputBuilder.append("}");
        return outputBuilder.toString();
    }

    public String prettyPrintTree(String indent) {
        StringBuilder outputBuilder = new StringBuilder(indent).append((String)this.queryType.get()).append("\n");
        for (Map.Entry<BooleanClause.Occur, List<QueryShapeVisitor>> entry : this.childVisitors.entrySet()) {
            outputBuilder.append(indent).append("  ").append(entry.getKey().name().toLowerCase(Locale.ROOT)).append(":\n");
            for (QueryShapeVisitor child : entry.getValue()) {
                outputBuilder.append(child.prettyPrintTree(indent + "    "));
            }
        }
        return outputBuilder.toString();
    }
}

