/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.index.store.lockmanager;

import java.io.IOException;
import java.util.function.Supplier;
import org.opensearch.common.annotation.PublicApi;
import org.opensearch.common.blobstore.BlobContainer;
import org.opensearch.common.blobstore.BlobPath;
import org.opensearch.index.store.RemoteBufferedOutputDirectory;
import org.opensearch.index.store.lockmanager.RemoteStoreLockManager;
import org.opensearch.index.store.lockmanager.RemoteStoreMetadataLockManager;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryMissingException;
import org.opensearch.repositories.blobstore.BlobStoreRepository;

@PublicApi(since="2.8.0")
public class RemoteStoreLockManagerFactory {
    private static final String SEGMENTS = "segments";
    private static final String LOCK_FILES = "lock_files";
    private final Supplier<RepositoriesService> repositoriesService;

    public RemoteStoreLockManagerFactory(Supplier<RepositoriesService> repositoriesService) {
        this.repositoriesService = repositoriesService;
    }

    public RemoteStoreLockManager newLockManager(String repositoryName, String indexUUID, String shardId) throws IOException {
        return RemoteStoreLockManagerFactory.newLockManager(this.repositoriesService.get(), repositoryName, indexUUID, shardId);
    }

    public static RemoteStoreMetadataLockManager newLockManager(RepositoriesService repositoriesService, String repositoryName, String indexUUID, String shardId) throws IOException {
        RemoteStoreMetadataLockManager remoteStoreMetadataLockManager;
        block9: {
            Repository repository = repositoriesService.repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobPath shardLevelBlobPath = ((BlobStoreRepository)repository).basePath().add(indexUUID).add(shardId).add(SEGMENTS);
                RemoteBufferedOutputDirectory shardMDLockDirectory = RemoteStoreLockManagerFactory.createRemoteBufferedOutputDirectory(repository, shardLevelBlobPath, LOCK_FILES);
                remoteStoreMetadataLockManager = new RemoteStoreMetadataLockManager(shardMDLockDirectory);
                if (repository == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be present to acquire/release lock", (Throwable)((Object)e));
                }
            }
            repository.close();
        }
        return remoteStoreMetadataLockManager;
    }

    public Supplier<RepositoriesService> getRepositoriesService() {
        return this.repositoriesService;
    }

    private static RemoteBufferedOutputDirectory createRemoteBufferedOutputDirectory(Repository repository, BlobPath commonBlobPath, String extention) {
        BlobPath extendedPath = commonBlobPath.add(extention);
        BlobContainer dataBlobContainer = ((BlobStoreRepository)repository).blobStore().blobContainer(extendedPath);
        return new RemoteBufferedOutputDirectory(dataBlobContainer);
    }
}

