/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.node.remotestore;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.cluster.metadata.RepositoriesMetadata;
import org.opensearch.cluster.metadata.RepositoryMetadata;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.common.settings.Setting;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.repositories.Repository;
import org.opensearch.repositories.RepositoryException;
import org.opensearch.threadpool.ThreadPool;

public class RemoteStoreNodeService {
    private static final Logger logger = LogManager.getLogger(RemoteStoreNodeService.class);
    private final Supplier<RepositoriesService> repositoriesService;
    private final ThreadPool threadPool;
    public static final Setting<CompatibilityMode> REMOTE_STORE_COMPATIBILITY_MODE_SETTING = new Setting<CompatibilityMode>("remote_store.compatibility_mode", CompatibilityMode.STRICT.name(), CompatibilityMode::parseString, Setting.Property.Dynamic, Setting.Property.NodeScope);

    public RemoteStoreNodeService(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool) {
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
    }

    public void createAndVerifyRepositories(DiscoveryNode localNode) {
        RemoteStoreNodeAttribute nodeAttribute = new RemoteStoreNodeAttribute(localNode);
        RepositoriesService reposService = this.repositoriesService.get();
        HashMap<String, Repository> repositories = new HashMap<String, Repository>();
        for (RepositoryMetadata repositoryMetadata : nodeAttribute.getRepositoriesMetadata().repositories()) {
            String repositoryName = repositoryMetadata.name();
            RepositoriesService.validate(repositoryName);
            Repository repository = reposService.createRepository(repositoryMetadata);
            logger.info("remote backed storage repository with name [{}] and type [{}] created", (Object)repository.getMetadata().name(), (Object)repository.getMetadata().type());
            String verificationToken = repository.startVerification();
            repository.verify(verificationToken, localNode);
            repository.endVerification(verificationToken);
            logger.info(() -> new ParameterizedMessage("successfully verified [{}] repository", (Object)repositoryName));
            repositories.put(repositoryName, repository);
        }
        reposService.updateRepositoriesMap(repositories);
    }

    public RepositoriesMetadata updateRepositoriesMetadata(DiscoveryNode joiningNode, RepositoriesMetadata existingRepositories) {
        if (joiningNode.isRemoteStoreNode()) {
            ArrayList<RepositoryMetadata> updatedRepositoryMetadataList = new ArrayList<RepositoryMetadata>();
            List<RepositoryMetadata> newRepositoryMetadataList = new RemoteStoreNodeAttribute(joiningNode).getRepositoriesMetadata().repositories();
            if (existingRepositories == null) {
                return new RepositoriesMetadata(newRepositoryMetadataList);
            }
            updatedRepositoryMetadataList.addAll(existingRepositories.repositories());
            for (RepositoryMetadata newRepositoryMetadata : newRepositoryMetadataList) {
                boolean repositoryAlreadyPresent = false;
                for (RepositoryMetadata existingRepositoryMetadata : existingRepositories.repositories()) {
                    if (!newRepositoryMetadata.name().equals(existingRepositoryMetadata.name())) continue;
                    try {
                        this.repositoriesService.get().ensureValidSystemRepositoryUpdate(newRepositoryMetadata, existingRepositoryMetadata);
                        newRepositoryMetadata = existingRepositoryMetadata;
                        repositoryAlreadyPresent = true;
                        break;
                    }
                    catch (RepositoryException e) {
                        throw new IllegalStateException("new repository metadata [" + String.valueOf(newRepositoryMetadata) + "] supplied by joining node is different from existing repository metadata [" + String.valueOf(existingRepositoryMetadata) + "].");
                    }
                }
                if (repositoryAlreadyPresent) continue;
                updatedRepositoryMetadataList.add(newRepositoryMetadata);
            }
            return new RepositoriesMetadata(updatedRepositoryMetadataList);
        }
        return existingRepositories;
    }

    public static enum CompatibilityMode {
        STRICT("strict");

        public final String mode;

        private CompatibilityMode(String mode) {
            this.mode = mode;
        }

        public static CompatibilityMode parseString(String compatibilityMode) {
            try {
                return CompatibilityMode.valueOf(compatibilityMode.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("[" + compatibilityMode + "] compatibility mode is not supported. supported modes are [" + CompatibilityMode.values().toString() + "]");
            }
        }
    }
}

