/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongToIntFunction;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.util.CollectionUtil;
import org.opensearch.common.Rounding;
import org.opensearch.common.lease.Releasable;
import org.opensearch.common.lease.Releasables;
import org.opensearch.common.util.IntArray;
import org.opensearch.common.util.LongArray;
import org.opensearch.core.common.util.ByteArray;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.search.DocValueFormat;
import org.opensearch.search.aggregations.Aggregator;
import org.opensearch.search.aggregations.AggregatorFactories;
import org.opensearch.search.aggregations.BucketOrder;
import org.opensearch.search.aggregations.CardinalityUpperBound;
import org.opensearch.search.aggregations.InternalAggregation;
import org.opensearch.search.aggregations.LeafBucketCollector;
import org.opensearch.search.aggregations.LeafBucketCollectorBase;
import org.opensearch.search.aggregations.bucket.DeferableBucketAggregator;
import org.opensearch.search.aggregations.bucket.DeferringBucketCollector;
import org.opensearch.search.aggregations.bucket.FastFilterRewriteHelper;
import org.opensearch.search.aggregations.bucket.MergingBucketsDeferringCollector;
import org.opensearch.search.aggregations.bucket.histogram.AutoDateHistogramAggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.InternalAutoDateHistogram;
import org.opensearch.search.aggregations.bucket.terms.LongKeyedBucketOrds;
import org.opensearch.search.aggregations.support.ValuesSource;
import org.opensearch.search.aggregations.support.ValuesSourceConfig;
import org.opensearch.search.internal.SearchContext;

abstract class AutoDateHistogramAggregator
extends DeferableBucketAggregator {
    private final ValuesSource.Numeric valuesSource;
    private final DocValueFormat formatter;
    private final Function<Rounding, Rounding.Prepared> roundingPreparer;
    private MergingBucketsDeferringCollector deferringCollector;
    protected final AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos;
    protected final int targetBuckets;
    protected int roundingIdx;
    protected Rounding.Prepared preparedRounding;
    private final FastFilterRewriteHelper.FastFilterContext fastFilterContext;

    static AutoDateHistogramAggregator build(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return cardinality == CardinalityUpperBound.ONE ? new FromSingle(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata) : new FromMany(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata);
    }

    private AutoDateHistogramAggregator(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        super(name, factories, aggregationContext, parent, metadata);
        this.targetBuckets = targetBuckets;
        this.valuesSource = valuesSourceConfig.hasValues() ? (ValuesSource.Numeric)valuesSourceConfig.getValuesSource() : null;
        this.formatter = valuesSourceConfig.format();
        this.roundingInfos = roundingInfos;
        this.roundingPreparer = roundingPreparer;
        this.preparedRounding = this.prepareRounding(0);
        this.fastFilterContext = new FastFilterRewriteHelper.FastFilterContext(this.context);
        this.fastFilterContext.setAggregationType(new AutoHistogramAggregationType(valuesSourceConfig.fieldType(), valuesSourceConfig.missing() != null, valuesSourceConfig.script() != null));
        if (this.fastFilterContext.isRewriteable(parent, this.subAggregators.length)) {
            this.fastFilterContext.buildFastFilter();
        }
    }

    protected abstract LongKeyedBucketOrds getBucketOrds();

    @Override
    public final ScoreMode scoreMode() {
        if (this.valuesSource != null && this.valuesSource.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    @Override
    protected final boolean shouldDefer(Aggregator aggregator) {
        return true;
    }

    @Override
    public final DeferringBucketCollector getDeferringCollector() {
        this.deferringCollector = new MergingBucketsDeferringCollector(this.context, AutoDateHistogramAggregator.descendsFromGlobalAggregator(this.parent()));
        return this.deferringCollector;
    }

    protected abstract LeafBucketCollector getLeafCollector(SortedNumericDocValues var1, LeafBucketCollector var2) throws IOException;

    @Override
    public final LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSource == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        boolean optimized = FastFilterRewriteHelper.tryFastFilterAggregation(ctx, this.fastFilterContext, (key, count) -> this.incrementBucketDocCount(FastFilterRewriteHelper.getBucketOrd(this.getBucketOrds().add(0L, this.preparedRounding.round((long)key))), count.intValue()));
        if (optimized) {
            throw new CollectionTerminatedException();
        }
        SortedNumericDocValues values = this.valuesSource.longValues(ctx);
        final LeafBucketCollector iteratingCollector = this.getLeafCollector(values, sub);
        return new LeafBucketCollectorBase(sub, values){

            @Override
            public void collect(int doc, long owningBucketOrd) throws IOException {
                iteratingCollector.collect(doc, owningBucketOrd);
            }
        };
    }

    protected final InternalAggregation[] buildAggregations(LongKeyedBucketOrds bucketOrds, LongToIntFunction roundingIndexFor, long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForVariableBuckets(owningBucketOrds, bucketOrds, (bucketValue, docCount, subAggregationResults) -> new InternalAutoDateHistogram.Bucket(bucketValue, docCount, this.formatter, subAggregationResults), (owningBucketOrd, buckets) -> {
            CollectionUtil.introSort((List)buckets, BucketOrder.key(true).comparator());
            InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, roundingIndexFor.applyAsInt(owningBucketOrd), this.buildEmptySubAggregations());
            return new InternalAutoDateHistogram(this.name, buckets, this.targetBuckets, emptyBucketInfo, this.formatter, this.metadata(), 1L);
        });
    }

    @Override
    public final InternalAggregation buildEmptyAggregation() {
        InternalAutoDateHistogram.BucketInfo emptyBucketInfo = new InternalAutoDateHistogram.BucketInfo(this.roundingInfos, 0, this.buildEmptySubAggregations());
        return new InternalAutoDateHistogram(this.name, Collections.emptyList(), this.targetBuckets, emptyBucketInfo, this.formatter, this.metadata(), 1L);
    }

    protected final Rounding.Prepared prepareRounding(int index) {
        return this.roundingPreparer.apply(this.roundingInfos[index].rounding);
    }

    protected final void merge(long[] mergeMap, long newNumBuckets) {
        this.mergeBuckets(mergeMap, newNumBuckets);
        if (this.deferringCollector != null) {
            this.deferringCollector.mergeBuckets(mergeMap);
        }
    }

    private static class FromSingle
    extends AutoDateHistogramAggregator {
        private LongKeyedBucketOrds.FromSingle bucketOrds;
        private long min = Long.MAX_VALUE;
        private long max = Long.MIN_VALUE;

        FromSingle(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata);
            this.bucketOrds = new LongKeyedBucketOrds.FromSingle(this.context.bigArrays());
        }

        @Override
        protected LongKeyedBucketOrds getBucketOrds() {
            return this.bucketOrds;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) throws IOException {
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    assert (owningBucketOrd == 0L);
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = preparedRounding.round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        this.collectValue(doc, rounded);
                        previousRounded = rounded;
                    }
                }

                private void collectValue(int doc, long rounded) throws IOException {
                    long bucketOrd = bucketOrds.add(0L, rounded);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        this.collectExistingBucket(sub, doc, bucketOrd);
                        return;
                    }
                    this.collectBucket(sub, doc, bucketOrd);
                    this.increaseRoundingIfNeeded(rounded);
                }

                private void increaseRoundingIfNeeded(long rounded) {
                    if (roundingIdx >= roundingInfos.length - 1) {
                        return;
                    }
                    min = Math.min(min, rounded);
                    max = Math.max(max, rounded);
                    if (bucketOrds.size() <= (long)(targetBuckets * roundingInfos[roundingIdx].getMaximumInnerInterval()) && max - min <= (long)targetBuckets * roundingInfos[roundingIdx].getMaximumRoughEstimateDurationMillis()) {
                        return;
                    }
                    do {
                        try (LongKeyedBucketOrds.FromSingle oldOrds = bucketOrds;){
                            preparedRounding = this.prepareRounding(++roundingIdx);
                            long[] mergeMap = new long[Math.toIntExact(((LongKeyedBucketOrds)oldOrds).size())];
                            bucketOrds = new LongKeyedBucketOrds.FromSingle(context.bigArrays());
                            LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = ((LongKeyedBucketOrds)oldOrds).ordsEnum(0L);
                            while (ordsEnum.next()) {
                                long oldKey = ordsEnum.value();
                                long newKey = preparedRounding.round(oldKey);
                                long newBucketOrd = bucketOrds.add(0L, newKey);
                                mergeMap[(int)ordsEnum.ord()] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                            }
                            this.merge(mergeMap, bucketOrds.size());
                        }
                    } while (roundingIdx < roundingInfos.length - 1 && (bucketOrds.size() > (long)(targetBuckets * roundingInfos[roundingIdx].getMaximumInnerInterval()) || max - min > (long)targetBuckets * roundingInfos[roundingIdx].getMaximumRoughEstimateDurationMillis()));
                }
            };
        }

        @Override
        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            return this.buildAggregations(this.bucketOrds, l -> this.roundingIdx, owningBucketOrds);
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("surviving_buckets", this.bucketOrds.size());
        }

        @Override
        protected void doClose() {
            Releasables.close((Releasable)this.bucketOrds);
        }
    }

    private static class FromMany
    extends AutoDateHistogramAggregator {
        private final Rounding.Prepared[] preparedRoundings;
        private LongKeyedBucketOrds.FromMany bucketOrds;
        private ByteArray roundingIndices;
        private LongArray mins;
        private LongArray maxes;
        private IntArray liveBucketCountUnderestimate;
        private long wastedBucketsOverestimate = 0L;
        private long nextRebucketAt = 1000L;
        private int rebucketCount = 0;

        FromMany(String name, AggregatorFactories factories, int targetBuckets, AutoDateHistogramAggregationBuilder.RoundingInfo[] roundingInfos, Function<Rounding, Rounding.Prepared> roundingPreparer, ValuesSourceConfig valuesSourceConfig, SearchContext aggregationContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
            super(name, factories, targetBuckets, roundingInfos, roundingPreparer, valuesSourceConfig, aggregationContext, parent, metadata);
            assert (roundingInfos.length < 127) : "Rounding must fit in a signed byte";
            this.roundingIndices = this.context.bigArrays().newByteArray(1L, true);
            this.mins = this.context.bigArrays().newLongArray(1L, false);
            this.mins.set(0L, Long.MAX_VALUE);
            this.maxes = this.context.bigArrays().newLongArray(1L, false);
            this.maxes.set(0L, Long.MIN_VALUE);
            this.preparedRoundings = new Rounding.Prepared[roundingInfos.length];
            this.preparedRoundings[0] = roundingPreparer.apply(roundingInfos[0].rounding);
            this.bucketOrds = new LongKeyedBucketOrds.FromMany(this.context.bigArrays());
            this.liveBucketCountUnderestimate = this.context.bigArrays().newIntArray(1L, true);
        }

        @Override
        protected LongKeyedBucketOrds getBucketOrds() {
            return this.bucketOrds;
        }

        @Override
        protected LeafBucketCollector getLeafCollector(final SortedNumericDocValues values, final LeafBucketCollector sub) throws IOException {
            return new LeafBucketCollectorBase(sub, values){

                @Override
                public void collect(int doc, long owningBucketOrd) throws IOException {
                    if (!values.advanceExact(doc)) {
                        return;
                    }
                    int valuesCount = values.docValueCount();
                    long previousRounded = Long.MIN_VALUE;
                    int roundingIdx = this.roundingIndexFor(owningBucketOrd);
                    for (int i = 0; i < valuesCount; ++i) {
                        long value = values.nextValue();
                        long rounded = preparedRoundings[roundingIdx].round(value);
                        assert (rounded >= previousRounded);
                        if (rounded == previousRounded) continue;
                        roundingIdx = this.collectValue(owningBucketOrd, roundingIdx, doc, rounded);
                        previousRounded = rounded;
                    }
                }

                private int collectValue(long owningBucketOrd, int roundingIdx, int doc, long rounded) throws IOException {
                    long bucketOrd = bucketOrds.add(owningBucketOrd, rounded);
                    if (bucketOrd < 0L) {
                        bucketOrd = -1L - bucketOrd;
                        this.collectExistingBucket(sub, doc, bucketOrd);
                        return roundingIdx;
                    }
                    this.collectBucket(sub, doc, bucketOrd);
                    liveBucketCountUnderestimate = context.bigArrays().grow(liveBucketCountUnderestimate, owningBucketOrd + 1L);
                    int estimatedBucketCount = liveBucketCountUnderestimate.increment(owningBucketOrd, 1);
                    return this.increaseRoundingIfNeeded(owningBucketOrd, estimatedBucketCount, rounded, roundingIdx);
                }

                private int increaseRoundingIfNeeded(long owningBucketOrd, int oldEstimatedBucketCount, long newKey, int oldRounding) {
                    int newEstimatedBucketCount;
                    long oldSize;
                    if (oldRounding >= roundingInfos.length - 1) {
                        return oldRounding;
                    }
                    if (mins.size() < owningBucketOrd + 1L) {
                        oldSize = mins.size();
                        mins = context.bigArrays().grow(mins, owningBucketOrd + 1L);
                        mins.fill(oldSize, mins.size(), Long.MAX_VALUE);
                    }
                    if (maxes.size() < owningBucketOrd + 1L) {
                        oldSize = maxes.size();
                        maxes = context.bigArrays().grow(maxes, owningBucketOrd + 1L);
                        maxes.fill(oldSize, maxes.size(), Long.MIN_VALUE);
                    }
                    long min = Math.min(mins.get(owningBucketOrd), newKey);
                    mins.set(owningBucketOrd, min);
                    long max = Math.max(maxes.get(owningBucketOrd), newKey);
                    maxes.set(owningBucketOrd, max);
                    if (oldEstimatedBucketCount <= targetBuckets * roundingInfos[oldRounding].getMaximumInnerInterval() && max - min <= (long)targetBuckets * roundingInfos[oldRounding].getMaximumRoughEstimateDurationMillis()) {
                        return oldRounding;
                    }
                    long oldRoughDuration = roundingInfos[oldRounding].roughEstimateDurationMillis;
                    int newRounding = oldRounding;
                    do {
                        double ratio = (double)oldRoughDuration / (double)roundingInfos[++newRounding].getRoughEstimateDurationMillis();
                        newEstimatedBucketCount = (int)Math.ceil((double)oldEstimatedBucketCount * ratio);
                    } while (newRounding < roundingInfos.length - 1 && (newEstimatedBucketCount > targetBuckets * roundingInfos[newRounding].getMaximumInnerInterval() || max - min > (long)targetBuckets * roundingInfos[newRounding].getMaximumRoughEstimateDurationMillis()));
                    this.setRounding(owningBucketOrd, newRounding);
                    mins.set(owningBucketOrd, preparedRoundings[newRounding].round(mins.get(owningBucketOrd)));
                    maxes.set(owningBucketOrd, preparedRoundings[newRounding].round(maxes.get(owningBucketOrd)));
                    wastedBucketsOverestimate += (long)(oldEstimatedBucketCount - newEstimatedBucketCount);
                    if (wastedBucketsOverestimate > nextRebucketAt) {
                        this.rebucket();
                        wastedBucketsOverestimate = 0L;
                        nextRebucketAt *= 2L;
                    } else {
                        liveBucketCountUnderestimate.set(owningBucketOrd, newEstimatedBucketCount);
                    }
                    return newRounding;
                }
            };
        }

        private void rebucket() {
            ++this.rebucketCount;
            try (LongKeyedBucketOrds.FromMany oldOrds = this.bucketOrds;){
                long[] mergeMap = new long[Math.toIntExact(((LongKeyedBucketOrds)oldOrds).size())];
                this.bucketOrds = new LongKeyedBucketOrds.FromMany(this.context.bigArrays());
                for (long owningBucketOrd = 0L; owningBucketOrd <= ((LongKeyedBucketOrds)oldOrds).maxOwningBucketOrd(); ++owningBucketOrd) {
                    LongKeyedBucketOrds.BucketOrdsEnum ordsEnum = ((LongKeyedBucketOrds)oldOrds).ordsEnum(owningBucketOrd);
                    Rounding.Prepared preparedRounding = this.preparedRoundings[this.roundingIndexFor(owningBucketOrd)];
                    while (ordsEnum.next()) {
                        long oldKey = ordsEnum.value();
                        long newKey = preparedRounding.round(oldKey);
                        long newBucketOrd = this.bucketOrds.add(owningBucketOrd, newKey);
                        mergeMap[(int)ordsEnum.ord()] = newBucketOrd >= 0L ? newBucketOrd : -1L - newBucketOrd;
                    }
                    this.liveBucketCountUnderestimate = this.context.bigArrays().grow(this.liveBucketCountUnderestimate, owningBucketOrd + 1L);
                    this.liveBucketCountUnderestimate.set(owningBucketOrd, Math.toIntExact(this.bucketOrds.bucketsInOrd(owningBucketOrd)));
                }
                this.merge(mergeMap, this.bucketOrds.size());
            }
        }

        @Override
        public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
            this.rebucket();
            return this.buildAggregations(this.bucketOrds, this::roundingIndexFor, owningBucketOrds);
        }

        @Override
        public void collectDebugInfo(BiConsumer<String, Object> add) {
            super.collectDebugInfo(add);
            add.accept("surviving_buckets", this.bucketOrds.size());
            add.accept("wasted_buckets_overestimate", this.wastedBucketsOverestimate);
            add.accept("next_rebucket_at", this.nextRebucketAt);
            add.accept("rebucket_count", this.rebucketCount);
        }

        private void setRounding(long owningBucketOrd, int newRounding) {
            this.roundingIndices = this.context.bigArrays().grow(this.roundingIndices, owningBucketOrd + 1L);
            this.roundingIndices.set(owningBucketOrd, (byte)newRounding);
            if (this.preparedRoundings[newRounding] == null) {
                this.preparedRoundings[newRounding] = this.prepareRounding(newRounding);
            }
        }

        private int roundingIndexFor(long owningBucketOrd) {
            return owningBucketOrd < this.roundingIndices.size() ? (int)this.roundingIndices.get(owningBucketOrd) : 0;
        }

        @Override
        public void doClose() {
            Releasables.close((Releasable[])new Releasable[]{this.bucketOrds, this.roundingIndices, this.mins, this.maxes, this.liveBucketCountUnderestimate});
        }
    }

    private class AutoHistogramAggregationType
    extends FastFilterRewriteHelper.AbstractDateHistogramAggregationType {
        public AutoHistogramAggregationType(MappedFieldType fieldType, boolean missing, boolean hasScript) {
            super(fieldType, missing, hasScript);
        }

        @Override
        protected Rounding getRounding(long low, long high) {
            long bestDuration = (high - low) / (long)AutoDateHistogramAggregator.this.targetBuckets;
            AutoDateHistogramAggregator.this.roundingIdx = 0;
            while (AutoDateHistogramAggregator.this.roundingIdx < AutoDateHistogramAggregator.this.roundingInfos.length - 1) {
                AutoDateHistogramAggregationBuilder.RoundingInfo curRoundingInfo = AutoDateHistogramAggregator.this.roundingInfos[AutoDateHistogramAggregator.this.roundingIdx];
                int temp = curRoundingInfo.innerIntervals[curRoundingInfo.innerIntervals.length - 1];
                if (bestDuration <= (long)temp * curRoundingInfo.roughEstimateDurationMillis) break;
                ++AutoDateHistogramAggregator.this.roundingIdx;
            }
            AutoDateHistogramAggregator.this.preparedRounding = AutoDateHistogramAggregator.this.prepareRounding(AutoDateHistogramAggregator.this.roundingIdx);
            return AutoDateHistogramAggregator.this.roundingInfos[AutoDateHistogramAggregator.this.roundingIdx].rounding;
        }

        @Override
        protected Rounding.Prepared getRoundingPrepared() {
            return AutoDateHistogramAggregator.this.preparedRounding;
        }
    }
}

