/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.backpressure.trackers;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.LongSupplier;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTracker;
import org.opensearch.search.backpressure.trackers.TaskResourceUsageTrackerType;
import org.opensearch.tasks.Task;
import org.opensearch.tasks.TaskCancellation;

public class ElapsedTimeTracker
extends TaskResourceUsageTracker {
    private final LongSupplier thresholdSupplier;
    private final LongSupplier timeNanosSupplier;

    public ElapsedTimeTracker(LongSupplier thresholdSupplier, LongSupplier timeNanosSupplier) {
        this.thresholdSupplier = thresholdSupplier;
        this.timeNanosSupplier = timeNanosSupplier;
    }

    @Override
    public String name() {
        return TaskResourceUsageTrackerType.ELAPSED_TIME_TRACKER.getName();
    }

    @Override
    public Optional<TaskCancellation.Reason> checkAndMaybeGetCancellationReason(Task task) {
        long threshold;
        long usage = this.timeNanosSupplier.getAsLong() - task.getStartTimeNanos();
        if (usage < (threshold = this.thresholdSupplier.getAsLong())) {
            return Optional.empty();
        }
        return Optional.of(new TaskCancellation.Reason("elapsed time exceeded [" + String.valueOf(new TimeValue(usage, TimeUnit.NANOSECONDS)) + " >= " + String.valueOf(new TimeValue(threshold, TimeUnit.NANOSECONDS)) + "]", 1));
    }

    @Override
    public TaskResourceUsageTracker.Stats stats(List<? extends Task> activeTasks) {
        long now = this.timeNanosSupplier.getAsLong();
        long currentMax = activeTasks.stream().mapToLong(t -> now - t.getStartTimeNanos()).max().orElse(0L);
        long currentAvg = (long)activeTasks.stream().mapToLong(t -> now - t.getStartTimeNanos()).average().orElse(0.0);
        return new Stats(this.getCancellations(), currentMax, currentAvg);
    }

    public static class Stats
    implements TaskResourceUsageTracker.Stats {
        private final long cancellationCount;
        private final long currentMax;
        private final long currentAvg;

        public Stats(long cancellationCount, long currentMax, long currentAvg) {
            this.cancellationCount = cancellationCount;
            this.currentMax = currentMax;
            this.currentAvg = currentAvg;
        }

        public Stats(StreamInput in) throws IOException {
            this(in.readVLong(), in.readVLong(), in.readVLong());
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().field("cancellation_count", this.cancellationCount).humanReadableField("current_max_millis", "current_max", (Object)new TimeValue(this.currentMax, TimeUnit.NANOSECONDS)).humanReadableField("current_avg_millis", "current_avg", (Object)new TimeValue(this.currentAvg, TimeUnit.NANOSECONDS)).endObject();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.cancellationCount);
            out.writeVLong(this.currentMax);
            out.writeVLong(this.currentAvg);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Stats stats = (Stats)o;
            return this.cancellationCount == stats.cancellationCount && this.currentMax == stats.currentMax && this.currentAvg == stats.currentAvg;
        }

        public int hashCode() {
            return Objects.hash(this.cancellationCount, this.currentMax, this.currentAvg);
        }
    }
}

