/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.cluster.metadata;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.opensearch.LegacyESVersion;
import org.opensearch.OpenSearchException;
import org.opensearch.ResourceAlreadyExistsException;
import org.opensearch.Version;
import org.opensearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.action.admin.indices.create.CreateIndexClusterStateUpdateRequest;
import org.opensearch.action.admin.indices.shrink.ResizeType;
import org.opensearch.action.support.ActiveShardCount;
import org.opensearch.action.support.ActiveShardsObserver;
import org.opensearch.cluster.AckedClusterStateUpdateTask;
import org.opensearch.cluster.ClusterState;
import org.opensearch.cluster.ack.AckedRequest;
import org.opensearch.cluster.ack.ClusterStateUpdateResponse;
import org.opensearch.cluster.ack.CreateIndexClusterStateUpdateResponse;
import org.opensearch.cluster.applicationtemplates.SystemTemplatesService;
import org.opensearch.cluster.block.ClusterBlock;
import org.opensearch.cluster.block.ClusterBlockLevel;
import org.opensearch.cluster.block.ClusterBlocks;
import org.opensearch.cluster.metadata.AliasMetadata;
import org.opensearch.cluster.metadata.AliasValidator;
import org.opensearch.cluster.metadata.AutoExpandReplicas;
import org.opensearch.cluster.metadata.ComponentTemplate;
import org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.opensearch.cluster.metadata.Context;
import org.opensearch.cluster.metadata.DiffableStringMap;
import org.opensearch.cluster.metadata.IndexAbstraction;
import org.opensearch.cluster.metadata.IndexMetadata;
import org.opensearch.cluster.metadata.IndexTemplateMetadata;
import org.opensearch.cluster.metadata.MappingMetadata;
import org.opensearch.cluster.metadata.Metadata;
import org.opensearch.cluster.metadata.MetadataCreateDataStreamService;
import org.opensearch.cluster.metadata.MetadataIndexTemplateService;
import org.opensearch.cluster.metadata.Template;
import org.opensearch.cluster.node.DiscoveryNode;
import org.opensearch.cluster.node.DiscoveryNodes;
import org.opensearch.cluster.routing.IndexRoutingTable;
import org.opensearch.cluster.routing.RoutingTable;
import org.opensearch.cluster.routing.ShardRouting;
import org.opensearch.cluster.routing.ShardRoutingState;
import org.opensearch.cluster.routing.allocation.AllocationService;
import org.opensearch.cluster.routing.allocation.AwarenessReplicaBalance;
import org.opensearch.cluster.service.ClusterManagerTaskThrottler;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.Nullable;
import org.opensearch.common.Priority;
import org.opensearch.common.UUIDs;
import org.opensearch.common.ValidationException;
import org.opensearch.common.compress.CompressedXContent;
import org.opensearch.common.io.PathUtils;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.settings.ClusterSettings;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Setting;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.common.util.FeatureFlags;
import org.opensearch.common.util.set.Sets;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.index.Index;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.env.Environment;
import org.opensearch.index.IndexModule;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.index.IndexService;
import org.opensearch.index.IndexSettings;
import org.opensearch.index.compositeindex.CompositeIndexSettings;
import org.opensearch.index.compositeindex.CompositeIndexValidator;
import org.opensearch.index.compositeindex.datacube.startree.StarTreeIndexSettings;
import org.opensearch.index.mapper.DocumentMapper;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.remote.RemoteStoreCustomMetadataResolver;
import org.opensearch.index.remote.RemoteStorePathStrategy;
import org.opensearch.index.shard.IndexSettingProvider;
import org.opensearch.index.translog.Translog;
import org.opensearch.indices.IndexCreationException;
import org.opensearch.indices.IndicesService;
import org.opensearch.indices.InvalidIndexContextException;
import org.opensearch.indices.InvalidIndexNameException;
import org.opensearch.indices.RemoteStoreSettings;
import org.opensearch.indices.ShardLimitValidator;
import org.opensearch.indices.SystemIndices;
import org.opensearch.indices.replication.common.ReplicationType;
import org.opensearch.node.remotestore.RemoteStoreNodeAttribute;
import org.opensearch.node.remotestore.RemoteStoreNodeService;
import org.opensearch.repositories.RepositoriesService;
import org.opensearch.threadpool.ThreadPool;

public class MetadataCreateIndexService {
    private static final Logger logger = LogManager.getLogger(MetadataCreateIndexService.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(MetadataCreateIndexService.class);
    public static final int MAX_INDEX_NAME_BYTES = 255;
    private final Settings settings;
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AllocationService allocationService;
    private final AliasValidator aliasValidator;
    private final Environment env;
    private final IndexScopedSettings indexScopedSettings;
    private final ActiveShardsObserver activeShardsObserver;
    private final NamedXContentRegistry xContentRegistry;
    private final SystemIndices systemIndices;
    private final ShardLimitValidator shardLimitValidator;
    private final boolean forbidPrivateIndexSettings;
    private final Set<IndexSettingProvider> indexSettingProviders = new HashSet<IndexSettingProvider>();
    private final ClusterManagerTaskThrottler.ThrottlingKey createIndexTaskKey;
    private AwarenessReplicaBalance awarenessReplicaBalance;
    @Nullable
    private final RemoteStoreCustomMetadataResolver remoteStoreCustomMetadataResolver;

    public MetadataCreateIndexService(Settings settings, ClusterService clusterService, IndicesService indicesService, AllocationService allocationService, AliasValidator aliasValidator, ShardLimitValidator shardLimitValidator, Environment env, IndexScopedSettings indexScopedSettings, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, SystemIndices systemIndices, boolean forbidPrivateIndexSettings, AwarenessReplicaBalance awarenessReplicaBalance, RemoteStoreSettings remoteStoreSettings, Supplier<RepositoriesService> repositoriesServiceSupplier) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.allocationService = allocationService;
        this.aliasValidator = aliasValidator;
        this.env = env;
        this.indexScopedSettings = indexScopedSettings;
        this.activeShardsObserver = new ActiveShardsObserver(clusterService, threadPool);
        this.xContentRegistry = xContentRegistry;
        this.systemIndices = systemIndices;
        this.forbidPrivateIndexSettings = forbidPrivateIndexSettings;
        this.shardLimitValidator = shardLimitValidator;
        this.awarenessReplicaBalance = awarenessReplicaBalance;
        this.createIndexTaskKey = clusterService.registerClusterManagerTask("create-index", true);
        Supplier<Version> minNodeVersionSupplier = () -> clusterService.state().nodes().getMinNodeVersion();
        this.remoteStoreCustomMetadataResolver = RemoteStoreNodeAttribute.isRemoteDataAttributePresent(settings) ? new RemoteStoreCustomMetadataResolver(remoteStoreSettings, minNodeVersionSupplier, repositoriesServiceSupplier, settings) : null;
    }

    public IndexScopedSettings getIndexScopedSettings() {
        return this.indexScopedSettings;
    }

    public void addAdditionalIndexSettingProvider(IndexSettingProvider provider) {
        if (provider == null) {
            throw new IllegalArgumentException("provider must not be null");
        }
        if (this.indexSettingProviders.contains(provider)) {
            throw new IllegalArgumentException("provider already added");
        }
        this.indexSettingProviders.add(provider);
    }

    public void validateIndexName(String index, ClusterState state) {
        MetadataCreateIndexService.validateIndexOrAliasName(index, InvalidIndexNameException::new);
        if (!index.toLowerCase(Locale.ROOT).equals(index)) {
            throw new InvalidIndexNameException(index, "must be lowercase");
        }
        if (state.routingTable().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.routingTable().index(index).getIndex());
        }
        if (state.metadata().hasIndex(index)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(index).getIndex());
        }
        if (state.metadata().hasAlias(index)) {
            throw new InvalidIndexNameException(index, "already exists as alias");
        }
    }

    public boolean validateDotIndex(String index, @Nullable Boolean isHidden) {
        if (index.charAt(0) == '.') {
            if (this.systemIndices.validateSystemIndex(index)) {
                return true;
            }
            if (isHidden.booleanValue()) {
                logger.trace("index [{}] is a hidden index", (Object)index);
            } else {
                DEPRECATION_LOGGER.deprecate("index_name_starts_with_dot", "index name [{}] starts with a dot '.', in the next major version, index names starting with a dot are reserved for hidden indices and system indices", index);
            }
        }
        return false;
    }

    public static void validateIndexOrAliasName(String index, BiFunction<String, String, ? extends RuntimeException> exceptionCtor) {
        if (!Strings.validFileName((String)index)) {
            throw exceptionCtor.apply(index, "must not contain the following characters " + String.valueOf(Strings.INVALID_FILENAME_CHARS));
        }
        if (index.isEmpty()) {
            throw exceptionCtor.apply(index, "must not be empty");
        }
        if (index.contains("#")) {
            throw exceptionCtor.apply(index, "must not contain '#'");
        }
        if (index.contains(":")) {
            throw exceptionCtor.apply(index, "must not contain ':'");
        }
        if (index.charAt(0) == '_' || index.charAt(0) == '-' || index.charAt(0) == '+') {
            throw exceptionCtor.apply(index, "must not start with '_', '-', or '+'");
        }
        int byteCount = 0;
        try {
            byteCount = index.getBytes("UTF-8").length;
        }
        catch (UnsupportedEncodingException e) {
            throw new OpenSearchException("Unable to determine length of index name", (Throwable)e, new Object[0]);
        }
        if (byteCount > 255) {
            throw exceptionCtor.apply(index, "index name is too long, (" + byteCount + " > 255)");
        }
        if (index.equals(".") || index.equals("..")) {
            throw exceptionCtor.apply(index, "must not be '.' or '..'");
        }
    }

    public void createIndex(CreateIndexClusterStateUpdateRequest request, ActionListener<CreateIndexClusterStateUpdateResponse> listener) {
        this.onlyCreateIndex(request, (ActionListener<ClusterStateUpdateResponse>)ActionListener.wrap(response -> {
            if (response.isAcknowledged()) {
                this.activeShardsObserver.waitForActiveShards(new String[]{request.index()}, request.waitForActiveShards(), request.ackTimeout(), shardsAcknowledged -> {
                    if (!shardsAcknowledged.booleanValue()) {
                        logger.debug("[{}] index created, but the operation timed out while waiting for enough shards to be started.", (Object)request.index());
                    }
                    listener.onResponse((Object)new CreateIndexClusterStateUpdateResponse(response.isAcknowledged(), (boolean)shardsAcknowledged));
                }, arg_0 -> ((ActionListener)listener).onFailure(arg_0));
            } else {
                listener.onResponse((Object)new CreateIndexClusterStateUpdateResponse(false, false));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private void onlyCreateIndex(final CreateIndexClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.normalizeRequestSetting(request);
        this.clusterService.submitStateUpdateTask("create-index [" + request.index() + "], cause [" + request.cause() + "]", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, listener){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterManagerTaskThrottler.ThrottlingKey getClusterManagerThrottlingKey() {
                return MetadataCreateIndexService.this.createIndexTaskKey;
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                return MetadataCreateIndexService.this.applyCreateIndexRequest(currentState, request, false);
            }

            @Override
            public void onFailure(String source, Exception e) {
                if (e instanceof ResourceAlreadyExistsException) {
                    logger.trace(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                } else {
                    logger.debug(() -> new ParameterizedMessage("[{}] failed to create", (Object)request.index()), (Throwable)e);
                }
                super.onFailure(source, e);
            }
        });
    }

    private void normalizeRequestSetting(CreateIndexClusterStateUpdateRequest createIndexClusterStateRequest) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        Settings build = updatedSettingsBuilder.put(createIndexClusterStateRequest.settings()).normalizePrefix("index.").build();
        this.indexScopedSettings.validate(build, true);
        createIndexClusterStateRequest.settings(build);
    }

    public ClusterState applyCreateIndexRequest(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        String name;
        IndexMetadata sourceMetadata;
        this.normalizeRequestSetting(request);
        logger.trace("executing IndexCreationTask for [{}] against cluster state version [{}]", (Object)request, (Object)currentState.version());
        this.validate(request, currentState);
        Index recoverFromIndex = request.recoverFrom();
        IndexMetadata indexMetadata = sourceMetadata = recoverFromIndex == null ? null : currentState.metadata().getIndexSafe(recoverFromIndex);
        if (sourceMetadata != null) {
            return this.applyCreateIndexRequestWithExistingMetadata(currentState, request, silent, sourceMetadata, metadataTransformer);
        }
        String string = name = request.dataStreamName() != null ? request.dataStreamName() : request.index();
        if (this.systemIndices.isSystemIndex(name)) {
            return this.applyCreateIndexRequestWithNoTemplates(currentState, request, silent, metadataTransformer);
        }
        Boolean isHiddenFromRequest = IndexMetadata.INDEX_HIDDEN_SETTING.exists(request.settings()) ? IndexMetadata.INDEX_HIDDEN_SETTING.get(request.settings()) : null;
        String v2Template = MetadataIndexTemplateService.findV2Template(currentState.metadata(), name, isHiddenFromRequest == null ? false : isHiddenFromRequest);
        if (v2Template != null) {
            return this.applyCreateIndexRequestWithV2Template(currentState, request, silent, v2Template, metadataTransformer);
        }
        List<IndexTemplateMetadata> v1Templates = MetadataIndexTemplateService.findV1Templates(currentState.metadata(), request.index(), isHiddenFromRequest);
        if (v1Templates.size() > 1) {
            DEPRECATION_LOGGER.deprecate("index_template_multiple_match", "index [{}] matches multiple legacy templates [{}], composable templates will only match a single template", request.index(), v1Templates.stream().map(IndexTemplateMetadata::name).sorted().collect(Collectors.joining(", ")));
        }
        return this.applyCreateIndexRequestWithV1Templates(currentState, request, silent, v1Templates, metadataTransformer);
    }

    public ClusterState applyCreateIndexRequest(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent) throws Exception {
        return this.applyCreateIndexRequest(currentState, request, silent, null);
    }

    private ClusterState applyCreateIndexWithTemporaryService(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, IndexMetadata sourceMetadata, IndexMetadata temporaryIndexMeta, List<Map<String, Object>> mappings, BiFunction<IndexService, Map<String, AliasMetadata>, List<AliasMetadata>> aliasSupplier, List<String> templatesApplied, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        return (ClusterState)this.indicesService.withTempIndexService(temporaryIndexMeta, indexService -> {
            IndexMetadata indexMetadata;
            Settings.Builder tmpSettingsBuilder = Settings.builder().put(temporaryIndexMeta.getSettings());
            ArrayList<Map<String, Object>> updatedMappings = new ArrayList<Map<String, Object>>();
            updatedMappings.addAll(mappings);
            Template contextTemplate = this.applyContext(request, currentState, updatedMappings, tmpSettingsBuilder);
            try {
                MetadataCreateIndexService.updateIndexMappingsAndBuildSortOrder(indexService, request, updatedMappings, sourceMetadata);
            }
            catch (Exception e) {
                logger.log(silent ? Level.DEBUG : Level.INFO, "failed on parsing mappings on index creation [{}]", (Object)request.index(), (Object)e);
                throw e;
            }
            List aliases = (List)aliasSupplier.apply((IndexService)indexService, Optional.ofNullable(contextTemplate).map(Template::aliases).orElse(Map.of()));
            try {
                indexMetadata = MetadataCreateIndexService.buildIndexMetadata(request.index(), aliases, indexService.mapperService()::documentMapper, tmpSettingsBuilder.build(), temporaryIndexMeta.getRoutingNumShards(), sourceMetadata, temporaryIndexMeta.isSystem(), temporaryIndexMeta.getCustomData(), temporaryIndexMeta.context());
            }
            catch (Exception e) {
                logger.info("failed to build index metadata [{}]", (Object)request.index());
                throw e;
            }
            logger.log(silent ? Level.DEBUG : Level.INFO, "[{}] creating index, cause [{}], templates {}, shards [{}]/[{}]", (Object)request.index(), (Object)request.cause(), (Object)templatesApplied, (Object)indexMetadata.getNumberOfShards(), (Object)indexMetadata.getNumberOfReplicas());
            indexService.getIndexEventListener().beforeIndexAddedToCluster(indexMetadata.getIndex(), indexMetadata.getSettings());
            return MetadataCreateIndexService.clusterStateCreateIndex(currentState, request.blocks(), indexMetadata, this.allocationService::reroute, metadataTransformer);
        });
    }

    Template applyContext(CreateIndexClusterStateUpdateRequest request, ClusterState currentState, List<Map<String, Object>> mappings, Settings.Builder settingsBuilder) throws IOException {
        if (request.context() != null) {
            ComponentTemplate componentTemplate = MetadataIndexTemplateService.findComponentTemplate(currentState.metadata(), request.context());
            if (componentTemplate.template().mappings() != null) {
                mappings.add(MapperService.parseMapping(this.xContentRegistry, componentTemplate.template().mappings().toString()));
            }
            if (componentTemplate.template().settings() != null) {
                MetadataCreateIndexService.validateOverlap(settingsBuilder.keys(), componentTemplate.template().settings(), request.index()).ifPresent(message -> {
                    ValidationException validationException = new ValidationException();
                    validationException.addValidationError(message);
                    throw validationException;
                });
                settingsBuilder.put(componentTemplate.template().settings());
            }
            settingsBuilder.put(IndexSettings.INDEX_CONTEXT_CREATED_VERSION.getKey(), componentTemplate.version());
            settingsBuilder.put(IndexSettings.INDEX_CONTEXT_CURRENT_VERSION.getKey(), componentTemplate.version());
            return componentTemplate.template();
        }
        return null;
    }

    static Optional<String> validateOverlap(Set<String> requestSettings, Settings contextTemplateSettings, String indexName) {
        if (requestSettings.stream().anyMatch(contextTemplateSettings::hasValue)) {
            return Optional.of("Cannot apply context template as user provide settings have overlap with the included context template.Please remove the settings [" + String.valueOf(Sets.intersection(requestSettings, contextTemplateSettings.keySet())) + "] to continue using the context for index: " + indexName);
        }
        return Optional.empty();
    }

    IndexMetadata buildAndValidateTemporaryIndexMetadata(Settings aggregatedIndexSettings, CreateIndexClusterStateUpdateRequest request, int routingNumShards) {
        boolean isHiddenAfterTemplates = IndexMetadata.INDEX_HIDDEN_SETTING.get(aggregatedIndexSettings);
        boolean isSystem = this.validateDotIndex(request.index(), isHiddenAfterTemplates);
        IndexMetadata.Builder tmpImdBuilder = IndexMetadata.builder(request.index());
        tmpImdBuilder.setRoutingNumShards(routingNumShards);
        tmpImdBuilder.settings(aggregatedIndexSettings);
        tmpImdBuilder.system(isSystem);
        this.addRemoteStoreCustomMetadata(tmpImdBuilder, true);
        if (request.context() != null) {
            tmpImdBuilder.context(request.context());
        }
        IndexMetadata tempMetadata = tmpImdBuilder.build();
        MetadataCreateIndexService.validateActiveShardCount(request.waitForActiveShards(), tempMetadata);
        return tempMetadata;
    }

    public void addRemoteStoreCustomMetadata(IndexMetadata.Builder tmpImdBuilder, boolean assertNullOldType) {
        if (this.remoteStoreCustomMetadataResolver == null) {
            return;
        }
        Map<String, String> existingCustomData = tmpImdBuilder.removeCustom("remote_store");
        assert (!assertNullOldType || Objects.isNull(existingCustomData));
        HashMap<String, String> remoteCustomData = new HashMap<String, String>();
        boolean isTranslogMetadataEnabled = this.remoteStoreCustomMetadataResolver.isTranslogMetadataEnabled();
        remoteCustomData.put("translog_metadata", Boolean.toString(isTranslogMetadataEnabled));
        RemoteStorePathStrategy newPathStrategy = this.remoteStoreCustomMetadataResolver.getPathStrategy();
        remoteCustomData.put("path_type", newPathStrategy.getType().name());
        if (Objects.nonNull((Object)newPathStrategy.getHashAlgorithm())) {
            remoteCustomData.put("path_hash_algorithm", newPathStrategy.getHashAlgorithm().name());
        }
        logger.trace(() -> new ParameterizedMessage("Added newCustomData={}, replaced oldCustomData={}", (Object)remoteCustomData, (Object)existingCustomData));
        tmpImdBuilder.putCustom("remote_store", remoteCustomData);
    }

    private ClusterState applyCreateIndexRequestWithNoTemplates(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        return this.applyCreateIndexRequestWithV1Templates(currentState, request, silent, Collections.emptyList(), metadataTransformer);
    }

    private ClusterState applyCreateIndexRequestWithV1Templates(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, List<IndexTemplateMetadata> templates, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        logger.debug("applying create index request using legacy templates {}", templates.stream().map(IndexTemplateMetadata::name).collect(Collectors.toList()));
        Map<String, Object> mappings = Collections.unmodifiableMap(MetadataCreateIndexService.parseV1Mappings(request.mappings(), templates.stream().map(IndexTemplateMetadata::getMappings).collect(Collectors.toList()), this.xContentRegistry));
        Settings aggregatedIndexSettings = MetadataCreateIndexService.aggregateIndexSettings(currentState, request, MetadataIndexTemplateService.resolveSettings(templates), null, this.settings, this.indexScopedSettings, this.shardLimitValidator, this.indexSettingProviders, this.clusterService.getClusterSettings());
        int routingNumShards = MetadataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, null);
        IndexMetadata tmpImd = this.buildAndValidateTemporaryIndexMetadata(aggregatedIndexSettings, request, routingNumShards);
        return this.applyCreateIndexWithTemporaryService(currentState, request, silent, null, tmpImd, Collections.singletonList(mappings), (indexService, contextAlias) -> MetadataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), Stream.concat(Stream.of(contextAlias), MetadataIndexTemplateService.resolveAliases(templates).stream()).collect(Collectors.toList()), currentState.metadata(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)), templates.stream().map(IndexTemplateMetadata::getName).collect(Collectors.toList()), metadataTransformer);
    }

    private ClusterState applyCreateIndexRequestWithV2Template(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, String templateName, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        logger.debug("applying create index request using composable template [{}]", (Object)templateName);
        ComposableIndexTemplate template = currentState.getMetadata().templatesV2().get(templateName);
        if (request.dataStreamName() == null && template.getDataStreamTemplate() != null) {
            throw new IllegalArgumentException("cannot create index with name [" + request.index() + "], because it matches with template [" + templateName + "] that creates data streams only, use create data stream api instead");
        }
        List<Map<String, Object>> mappings = MetadataCreateIndexService.collectV2Mappings(request.mappings(), currentState, templateName, this.xContentRegistry, request.index());
        Settings aggregatedIndexSettings = MetadataCreateIndexService.aggregateIndexSettings(currentState, request, MetadataIndexTemplateService.resolveSettings(currentState.metadata(), templateName), null, this.settings, this.indexScopedSettings, this.shardLimitValidator, this.indexSettingProviders, this.clusterService.getClusterSettings());
        int routingNumShards = MetadataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, null);
        IndexMetadata tmpImd = this.buildAndValidateTemporaryIndexMetadata(aggregatedIndexSettings, request, routingNumShards);
        return this.applyCreateIndexWithTemporaryService(currentState, request, silent, null, tmpImd, mappings, (indexService, contextAlias) -> MetadataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), Stream.concat(Stream.of(contextAlias), MetadataIndexTemplateService.resolveAliases(currentState.metadata(), templateName).stream()).collect(Collectors.toList()), currentState.metadata(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)), Collections.singletonList(templateName), metadataTransformer);
    }

    public static List<Map<String, Object>> collectV2Mappings(String requestMappings, ClusterState currentState, String templateName, NamedXContentRegistry xContentRegistry, String indexName) throws Exception {
        List<CompressedXContent> templateMappings = MetadataIndexTemplateService.collectMappings(currentState, templateName, indexName);
        return MetadataCreateIndexService.collectV2Mappings(requestMappings, templateMappings, xContentRegistry);
    }

    public static List<Map<String, Object>> collectV2Mappings(String requestMappings, List<CompressedXContent> templateMappings, NamedXContentRegistry xContentRegistry) throws Exception {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (CompressedXContent templateMapping : templateMappings) {
            Map<String, Object> parsedTemplateMapping = MapperService.parseMapping(xContentRegistry, templateMapping.string());
            result.add(parsedTemplateMapping);
        }
        Map<String, Object> parsedRequestMappings = MapperService.parseMapping(xContentRegistry, requestMappings);
        result.add(parsedRequestMappings);
        return result;
    }

    private ClusterState applyCreateIndexRequestWithExistingMetadata(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, boolean silent, IndexMetadata sourceMetadata, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) throws Exception {
        logger.info("applying create index request using existing index [{}] metadata", (Object)sourceMetadata.getIndex().getName());
        Map<String, Object> mappings = MapperService.parseMapping(this.xContentRegistry, request.mappings());
        if (!mappings.isEmpty()) {
            throw new IllegalArgumentException("mappings are not allowed when creating an index from a source index, all mappings are copied from the source index");
        }
        Settings aggregatedIndexSettings = MetadataCreateIndexService.aggregateIndexSettings(currentState, request, Settings.EMPTY, sourceMetadata, this.settings, this.indexScopedSettings, this.shardLimitValidator, this.indexSettingProviders, this.clusterService.getClusterSettings());
        int routingNumShards = MetadataCreateIndexService.getIndexNumberOfRoutingShards(aggregatedIndexSettings, sourceMetadata);
        IndexMetadata tmpImd = this.buildAndValidateTemporaryIndexMetadata(aggregatedIndexSettings, request, routingNumShards);
        return this.applyCreateIndexWithTemporaryService(currentState, request, silent, sourceMetadata, tmpImd, Collections.singletonList(mappings), (indexService, contextTemplate) -> MetadataCreateIndexService.resolveAndValidateAliases(request.index(), request.aliases(), Collections.emptyList(), currentState.metadata(), this.aliasValidator, this.xContentRegistry, indexService.newQueryShardContext(0, null, () -> 0L, null)), List.of(), metadataTransformer);
    }

    static Map<String, Object> parseV1Mappings(String requestMappings, List<CompressedXContent> templateMappings, NamedXContentRegistry xContentRegistry) throws Exception {
        Map<String, Object> mappings = MapperService.parseMapping(xContentRegistry, requestMappings);
        for (CompressedXContent mapping : templateMappings) {
            Map<String, Object> templateMapping;
            if (mapping == null || (templateMapping = MapperService.parseMapping(xContentRegistry, mapping.string())).isEmpty()) continue;
            assert (templateMapping.size() == 1) : "expected exactly one mapping value, got: " + String.valueOf(templateMapping);
            templateMapping = Collections.singletonMap("_doc", templateMapping.values().iterator().next());
            if (mappings.isEmpty()) {
                mappings = templateMapping;
                continue;
            }
            XContentHelper.mergeDefaults(mappings, templateMapping);
        }
        return mappings;
    }

    static Settings aggregateIndexSettings(ClusterState currentState, CreateIndexClusterStateUpdateRequest request, Settings combinedTemplateSettings, @Nullable IndexMetadata sourceMetadata, Settings settings, IndexScopedSettings indexScopedSettings, ShardLimitValidator shardLimitValidator, Set<IndexSettingProvider> indexSettingProviders, ClusterSettings clusterSettings) {
        Settings.Builder templateSettings = Settings.builder().put(combinedTemplateSettings);
        Settings.Builder requestSettings = Settings.builder().put(request.settings());
        Settings.Builder indexSettingsBuilder = Settings.builder();
        String storeTypeSetting = request.settings().get(IndexModule.INDEX_STORE_TYPE_SETTING.getKey());
        if (storeTypeSetting != null && storeTypeSetting.equals(RestoreSnapshotRequest.StorageType.REMOTE_SNAPSHOT.toString())) {
            throw new IllegalArgumentException("cannot create index with index setting \"index.store.type\" set to \"remote_snapshot\". Store type can be set to \"remote_snapshot\" only when restoring a remote snapshot by using \"storage_type\": \"remote_snapshot\"");
        }
        if (sourceMetadata == null) {
            Settings.Builder additionalIndexSettings = Settings.builder();
            Settings templateAndRequestSettings = Settings.builder().put(combinedTemplateSettings).put(request.settings()).build();
            boolean isDataStreamIndex = request.dataStreamName() != null;
            for (IndexSettingProvider provider : indexSettingProviders) {
                additionalIndexSettings.put(provider.getAdditionalIndexSettings(request.index(), isDataStreamIndex, templateAndRequestSettings));
            }
            for (String explicitSetting : additionalIndexSettings.keys()) {
                if (templateSettings.keys().contains(explicitSetting) && templateSettings.get(explicitSetting) == null) {
                    logger.debug("removing default [{}] setting as it in set to null in a template for [{}] creation", (Object)explicitSetting, (Object)request.index());
                    additionalIndexSettings.remove(explicitSetting);
                    templateSettings.remove(explicitSetting);
                }
                if (!requestSettings.keys().contains(explicitSetting) || requestSettings.get(explicitSetting) != null) continue;
                logger.debug("removing default [{}] setting as it in set to null in the request for [{}] creation", (Object)explicitSetting, (Object)request.index());
                additionalIndexSettings.remove(explicitSetting);
                requestSettings.remove(explicitSetting);
            }
            indexSettingsBuilder.put(additionalIndexSettings.build());
            indexSettingsBuilder.put(templateSettings.build());
        }
        indexSettingsBuilder.put(requestSettings.build());
        if (indexSettingsBuilder.get(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey()) == null) {
            DiscoveryNodes nodes = currentState.nodes();
            Version createdVersion = Version.min((Version)Version.CURRENT, (Version)nodes.getSmallestNonClientNodeVersion());
            indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), createdVersion);
        }
        if (!IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(indexSettingsBuilder)) {
            int numberOfShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(settings) ? IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(settings) : MetadataCreateIndexService.getNumberOfShards(indexSettingsBuilder);
            indexSettingsBuilder.put("index.number_of_shards", numberOfShards);
        }
        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettingsBuilder) || indexSettingsBuilder.get("index.number_of_replicas") == null) {
            indexSettingsBuilder.put("index.number_of_replicas", Metadata.DEFAULT_REPLICA_COUNT_SETTING.get(currentState.metadata().settings()));
        }
        if (settings.get("index.auto_expand_replicas") != null && indexSettingsBuilder.get("index.auto_expand_replicas") == null) {
            indexSettingsBuilder.put("index.auto_expand_replicas", settings.get("index.auto_expand_replicas"));
        }
        if (indexSettingsBuilder.get("index.creation_date") == null) {
            indexSettingsBuilder.put("index.creation_date", Instant.now().toEpochMilli());
        }
        indexSettingsBuilder.put("index.provided_name", request.getProvidedName());
        indexSettingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
        MetadataCreateIndexService.updateReplicationStrategy(indexSettingsBuilder, request.settings(), settings, combinedTemplateSettings, clusterSettings);
        MetadataCreateIndexService.updateRemoteStoreSettings(indexSettingsBuilder, currentState, clusterSettings, settings, request.index());
        if (FeatureFlags.isEnabled(FeatureFlags.READER_WRITER_SPLIT_EXPERIMENTAL_SETTING)) {
            MetadataCreateIndexService.updateSearchOnlyReplicas(request.settings(), indexSettingsBuilder);
        }
        if (sourceMetadata != null) {
            assert (request.resizeType() != null);
            MetadataCreateIndexService.prepareResizeIndexSettings(currentState, indexSettingsBuilder, request.recoverFrom(), request.index(), request.resizeType(), request.copySettings(), indexScopedSettings);
        }
        ArrayList<String> validationErrors = new ArrayList<String>();
        MetadataCreateIndexService.validateIndexReplicationTypeSettings(indexSettingsBuilder.build(), clusterSettings).ifPresent(validationErrors::add);
        MetadataCreateIndexService.validateErrors(request.index(), validationErrors);
        Settings indexSettings = indexSettingsBuilder.build();
        shardLimitValidator.validateShardLimit(request.index(), indexSettings, currentState);
        if (!IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexSettings).booleanValue() && IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexSettings).onOrAfter(Version.V_2_0_0)) {
            throw new IllegalArgumentException("Creating indices with soft-deletes disabled is no longer supported. Please do not specify a value for setting [index.soft_deletes.enabled].");
        }
        MetadataCreateIndexService.validateTranslogRetentionSettings(indexSettings);
        MetadataCreateIndexService.validateStoreTypeSettings(indexSettings);
        MetadataCreateIndexService.validateRefreshIntervalSettings(request.settings(), clusterSettings);
        MetadataCreateIndexService.validateTranslogFlushIntervalSettingsForCompositeIndex(request.settings(), clusterSettings);
        MetadataCreateIndexService.validateTranslogDurabilitySettings(request.settings(), clusterSettings, settings);
        return indexSettings;
    }

    private static void updateSearchOnlyReplicas(Settings requestSettings, Settings.Builder builder) {
        if (IndexMetadata.INDEX_NUMBER_OF_SEARCH_REPLICAS_SETTING.exists(builder) && builder.get("index.number_of_search_only_replicas") != null) {
            if (IndexMetadata.INDEX_NUMBER_OF_SEARCH_REPLICAS_SETTING.get(requestSettings) > 0 && !Boolean.parseBoolean(builder.get("index.remote_store.enabled"))) {
                throw new IllegalArgumentException("To set index.number_of_search_only_replicas, index.remote_store.enabled must be set to true");
            }
            builder.put("index.number_of_search_only_replicas", IndexMetadata.INDEX_NUMBER_OF_SEARCH_REPLICAS_SETTING.get(requestSettings));
        }
    }

    public static void updateReplicationStrategy(Settings.Builder settingsBuilder, Settings requestSettings, Settings nodeSettings, Settings combinedTemplateSettings, ClusterSettings clusterSettings) {
        ReplicationType indexReplicationType = RemoteStoreNodeService.isMigratingToRemoteStore(clusterSettings) ? ReplicationType.SEGMENT : (IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.exists(requestSettings) ? IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.get(requestSettings) : (combinedTemplateSettings != null && IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.exists(combinedTemplateSettings) ? IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.get(combinedTemplateSettings) : (IndicesService.CLUSTER_REPLICATION_TYPE_SETTING.exists(nodeSettings) ? IndicesService.CLUSTER_REPLICATION_TYPE_SETTING.get(nodeSettings) : (RemoteStoreNodeAttribute.isRemoteDataAttributePresent(nodeSettings) ? ReplicationType.SEGMENT : IndicesService.CLUSTER_REPLICATION_TYPE_SETTING.getDefault(nodeSettings)))));
        settingsBuilder.put("index.replication.type", indexReplicationType);
    }

    public static void updateRemoteStoreSettings(Settings.Builder settingsBuilder, ClusterState clusterState, ClusterSettings clusterSettings, Settings nodeSettings, String indexName) {
        Optional<DiscoveryNode> remoteNode;
        if ((RemoteStoreNodeAttribute.isRemoteDataAttributePresent(nodeSettings) && clusterSettings.get(RemoteStoreNodeService.REMOTE_STORE_COMPATIBILITY_MODE_SETTING).equals((Object)RemoteStoreNodeService.CompatibilityMode.STRICT) || RemoteStoreNodeService.isMigratingToRemoteStore(clusterSettings)) && (remoteNode = clusterState.nodes().getNodes().values().stream().filter(DiscoveryNode::isRemoteStoreNode).findFirst()).isPresent()) {
            String translogRepo = RemoteStoreNodeAttribute.getTranslogRepoName(remoteNode.get().getAttributes());
            String segmentRepo = RemoteStoreNodeAttribute.getSegmentRepoName(remoteNode.get().getAttributes());
            if (segmentRepo != null && translogRepo != null) {
                settingsBuilder.put("index.remote_store.enabled", true).put("index.remote_store.segment.repository", segmentRepo).put("index.remote_store.translog.repository", translogRepo);
            } else {
                ValidationException validationException = new ValidationException();
                validationException.addValidationErrors(Collections.singletonList("Cluster is migrating to remote store but no remote node found, failing index creation"));
                throw new IndexCreationException(indexName, (Throwable)validationException);
            }
        }
    }

    public static void validateStoreTypeSettings(Settings settings) {
        if (IndexModule.Type.SIMPLEFS.match(IndexModule.INDEX_STORE_TYPE_SETTING.get(settings))) {
            DEPRECATION_LOGGER.deprecate("store_type_setting", "[simplefs] is deprecated and will be removed in 2.0. Use [niofs], which offers equal or better performance, or other file systems instead.", new Object[0]);
        }
    }

    static int getNumberOfShards(Settings.Builder indexSettingsBuilder) {
        assert (Version.CURRENT.major == 1 || Version.CURRENT.major == 2);
        Version indexVersionCreated = Version.fromId((int)Integer.parseInt(indexSettingsBuilder.get(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey())));
        int numberOfShards = indexVersionCreated.before((Version)LegacyESVersion.V_7_0_0) ? 5 : IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.getDefault(Settings.EMPTY);
        return numberOfShards;
    }

    static int getIndexNumberOfRoutingShards(Settings indexSettings, @Nullable IndexMetadata sourceMetadata) {
        int routingNumShards;
        int numTargetShards = IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(indexSettings);
        Version indexVersionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexSettings);
        if (sourceMetadata == null || sourceMetadata.getNumberOfShards() == 1) {
            routingNumShards = indexSettings.get(IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.getKey()) != null ? IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.get(indexSettings) : MetadataCreateIndexService.calculateNumRoutingShards(numTargetShards, indexVersionCreated);
        } else {
            assert (!IndexMetadata.INDEX_NUMBER_OF_ROUTING_SHARDS_SETTING.exists(indexSettings)) : "index.number_of_routing_shards should not be present on the target index on resize";
            routingNumShards = sourceMetadata.getRoutingNumShards();
        }
        return routingNumShards;
    }

    public static List<AliasMetadata> resolveAndValidateAliases(String index, Set<Alias> aliases, List<Map<String, AliasMetadata>> templateAliases, Metadata metadata, AliasValidator aliasValidator, NamedXContentRegistry xContentRegistry, QueryShardContext queryShardContext) {
        ArrayList<AliasMetadata> resolvedAliases = new ArrayList<AliasMetadata>();
        for (Alias alias : aliases) {
            aliasValidator.validateAlias(alias, index, metadata);
            if (Strings.hasLength((String)alias.filter())) {
                aliasValidator.validateAliasFilter(alias.name(), alias.filter(), queryShardContext, xContentRegistry);
            }
            AliasMetadata aliasMetadata = AliasMetadata.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).writeIndex(alias.writeIndex()).isHidden(alias.isHidden()).build();
            resolvedAliases.add(aliasMetadata);
        }
        HashMap<String, AliasMetadata> templatesAliases = new HashMap<String, AliasMetadata>();
        for (Map<String, AliasMetadata> templateAliasConfig : templateAliases) {
            for (Map.Entry<String, AliasMetadata> entry : templateAliasConfig.entrySet()) {
                AliasMetadata aliasMetadata = entry.getValue();
                if (aliases.contains(new Alias(aliasMetadata.alias())) || templatesAliases.containsKey(entry.getKey())) continue;
                if (aliasMetadata.alias().contains("{index}")) {
                    String templatedAlias = aliasMetadata.alias().replace("{index}", index);
                    aliasMetadata = AliasMetadata.newAliasMetadata(aliasMetadata, templatedAlias);
                }
                aliasValidator.validateAliasMetadata(aliasMetadata, index, metadata);
                if (aliasMetadata.filter() != null) {
                    aliasValidator.validateAliasFilter(aliasMetadata.alias(), aliasMetadata.filter().uncompressed(), queryShardContext, xContentRegistry);
                }
                templatesAliases.put(aliasMetadata.alias(), aliasMetadata);
                resolvedAliases.add(aliasMetadata);
            }
        }
        return resolvedAliases;
    }

    static ClusterState clusterStateCreateIndex(ClusterState currentState, Set<ClusterBlock> clusterBlocks, IndexMetadata indexMetadata, BiFunction<ClusterState, String, ClusterState> rerouteRoutingTable, BiConsumer<Metadata.Builder, IndexMetadata> metadataTransformer) {
        Metadata.Builder builder = Metadata.builder(currentState.metadata()).put(indexMetadata, false);
        if (metadataTransformer != null) {
            metadataTransformer.accept(builder, indexMetadata);
        }
        Metadata newMetadata = builder.build();
        String indexName = indexMetadata.getIndex().getName();
        ClusterBlocks.Builder blocks = MetadataCreateIndexService.createClusterBlocksBuilder(currentState, indexName, clusterBlocks);
        blocks.updateBlocks(indexMetadata);
        ClusterState updatedState = ClusterState.builder(currentState).blocks(blocks).metadata(newMetadata).build();
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(updatedState.routingTable()).addAsNew(updatedState.metadata().index(indexName));
        updatedState = ClusterState.builder(updatedState).routingTable(routingTableBuilder.build()).build();
        return rerouteRoutingTable.apply(updatedState, "index [" + indexName + "] created");
    }

    static IndexMetadata buildIndexMetadata(String indexName, List<AliasMetadata> aliases, Supplier<DocumentMapper> documentMapperSupplier, Settings indexSettings, int routingNumShards, @Nullable IndexMetadata sourceMetadata, boolean isSystem, Map<String, DiffableStringMap> customData, Context context) {
        IndexMetadata.Builder indexMetadataBuilder = MetadataCreateIndexService.createIndexMetadataBuilder(indexName, sourceMetadata, indexSettings, routingNumShards);
        indexMetadataBuilder.system(isSystem);
        HashMap<String, Object> mappingsMetadata = new HashMap<String, Object>();
        DocumentMapper mapper = documentMapperSupplier.get();
        if (mapper != null) {
            MappingMetadata mappingMd = new MappingMetadata(mapper);
            mappingsMetadata.put(mapper.type(), mappingMd);
        }
        for (MappingMetadata mappingMd : mappingsMetadata.values()) {
            indexMetadataBuilder.putMapping(mappingMd);
        }
        for (int i = aliases.size() - 1; i >= 0; --i) {
            indexMetadataBuilder.putAlias(aliases.get(i));
        }
        for (Map.Entry<String, DiffableStringMap> entry : customData.entrySet()) {
            indexMetadataBuilder.putCustom(entry.getKey(), entry.getValue());
        }
        indexMetadataBuilder.context(context);
        indexMetadataBuilder.state(IndexMetadata.State.OPEN);
        return indexMetadataBuilder.build();
    }

    private static IndexMetadata.Builder createIndexMetadataBuilder(String indexName, @Nullable IndexMetadata sourceMetadata, Settings indexSettings, int routingNumShards) {
        IndexMetadata.Builder builder = IndexMetadata.builder(indexName);
        builder.setRoutingNumShards(routingNumShards);
        builder.settings(indexSettings);
        if (sourceMetadata != null) {
            long primaryTerm = IntStream.range(0, sourceMetadata.getNumberOfShards()).mapToLong(sourceMetadata::primaryTerm).max().getAsLong();
            for (int shardId = 0; shardId < builder.numberOfShards(); ++shardId) {
                builder.primaryTerm(shardId, primaryTerm);
            }
        }
        return builder;
    }

    private static ClusterBlocks.Builder createClusterBlocksBuilder(ClusterState currentState, String index, Set<ClusterBlock> blocks) {
        ClusterBlocks.Builder blocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
        if (!blocks.isEmpty()) {
            for (ClusterBlock block : blocks) {
                blocksBuilder.addIndexBlock(index, block);
            }
        }
        return blocksBuilder;
    }

    private static void updateIndexMappingsAndBuildSortOrder(IndexService indexService, CreateIndexClusterStateUpdateRequest request, List<Map<String, Object>> mappings, @Nullable IndexMetadata sourceMetadata) throws IOException {
        MapperService mapperService = indexService.mapperService();
        for (Map<String, Object> mapping : mappings) {
            if (mapping.isEmpty()) continue;
            mapperService.merge("_doc", mapping, MapperService.MergeReason.INDEX_TEMPLATE);
        }
        if (mapperService.isCompositeIndexPresent()) {
            CompositeIndexValidator.validate(mapperService, indexService.getCompositeIndexSettings(), indexService.getIndexSettings());
        }
        if (sourceMetadata == null) {
            indexService.getIndexSortSupplier().get();
        }
        if (request.dataStreamName() != null) {
            MetadataCreateDataStreamService.validateTimestampFieldMapping(mapperService);
        }
    }

    private static void validateActiveShardCount(ActiveShardCount waitForActiveShards, IndexMetadata indexMetadata) {
        if (waitForActiveShards == ActiveShardCount.DEFAULT) {
            waitForActiveShards = indexMetadata.getWaitForActiveShards();
        }
        if (!waitForActiveShards.validate(indexMetadata.getNumberOfReplicas())) {
            throw new IllegalArgumentException("invalid wait_for_active_shards[" + String.valueOf(waitForActiveShards) + "]: cannot be greater than number of shard copies [" + (indexMetadata.getNumberOfReplicas() + 1) + "]");
        }
    }

    private void validate(CreateIndexClusterStateUpdateRequest request, ClusterState state) {
        this.validateIndexName(request.index(), state);
        this.validateIndexSettings(request.index(), request.settings(), this.forbidPrivateIndexSettings);
        this.validateContext(request);
    }

    public void validateIndexSettings(String indexName, Settings settings, boolean forbidPrivateIndexSettings) throws IndexCreationException {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings, indexName);
        MetadataCreateIndexService.validateIndexReplicationTypeSettings(settings, this.clusterService.getClusterSettings()).ifPresent(validationErrors::add);
        MetadataCreateIndexService.validateErrors(indexName, validationErrors);
    }

    private static void validateErrors(String indexName, List<String> validationErrors) {
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new IndexCreationException(indexName, (Throwable)validationException);
        }
    }

    List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings, String indexName) {
        List<String> validationErrors = this.getIndexSettingsValidationErrors(settings, forbidPrivateIndexSettings, Optional.of(indexName));
        return validationErrors;
    }

    List<String> getIndexSettingsValidationErrors(Settings settings, boolean forbidPrivateIndexSettings, Optional<String> indexName) {
        AutoExpandReplicas autoExpandReplica;
        int replicaCount;
        Optional<String> error;
        List<String> validationErrors = MetadataCreateIndexService.validateIndexCustomPath(settings, this.env.sharedDataFile());
        if (forbidPrivateIndexSettings) {
            validationErrors.addAll(MetadataCreateIndexService.validatePrivateSettingsNotExplicitlySet(settings, this.indexScopedSettings));
        }
        if ((indexName.isEmpty() || indexName.get().charAt(0) != '.') && (error = this.awarenessReplicaBalance.validate(replicaCount = settings.getAsInt("index.number_of_replicas", Metadata.DEFAULT_REPLICA_COUNT_SETTING.get(this.clusterService.state().metadata().settings())).intValue(), autoExpandReplica = AutoExpandReplicas.SETTING.get(settings))).isPresent()) {
            validationErrors.add(error.get());
        }
        return validationErrors;
    }

    private static List<String> validatePrivateSettingsNotExplicitlySet(Settings settings, IndexScopedSettings indexScopedSettings) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        for (String key : settings.keySet()) {
            Setting<?> setting = indexScopedSettings.get(key);
            if (setting == null) {
                if (indexScopedSettings.isPrivateSetting(key)) continue;
                validationErrors.add("expected [" + key + "] to be private but it was not");
                continue;
            }
            if (!setting.isPrivateIndex()) continue;
            validationErrors.add("private index setting [" + key + "] can not be set explicitly");
        }
        return validationErrors;
    }

    private static List<String> validateIndexCustomPath(Settings settings, @Nullable Path sharedDataPath) {
        String customPath = IndexMetadata.INDEX_DATA_PATH_SETTING.get(settings);
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (!Strings.isEmpty((CharSequence)customPath)) {
            if (sharedDataPath == null) {
                validationErrors.add("path.shared_data must be set in order to use custom data paths");
            } else {
                Path resolvedPath = PathUtils.get((Path[])new Path[]{sharedDataPath}, (String)customPath);
                if (resolvedPath == null) {
                    validationErrors.add("custom path [" + customPath + "] is not a sub-path of path.shared_data [" + String.valueOf(sharedDataPath) + "]");
                }
            }
        }
        return validationErrors;
    }

    private static Optional<String> validateIndexReplicationTypeSettings(Settings requestSettings, ClusterSettings clusterSettings) {
        if (clusterSettings.get(IndicesService.CLUSTER_INDEX_RESTRICT_REPLICATION_TYPE_SETTING).booleanValue() && requestSettings.hasValue("index.replication.type") && !requestSettings.get(IndexMetadata.INDEX_REPLICATION_TYPE_SETTING.getKey()).equals(clusterSettings.get(IndicesService.CLUSTER_REPLICATION_TYPE_SETTING).name())) {
            return Optional.of("index setting [index.replication.type] is not allowed to be set as [" + IndicesService.CLUSTER_INDEX_RESTRICT_REPLICATION_TYPE_SETTING.getKey() + "=true]");
        }
        return Optional.empty();
    }

    static List<String> validateShrinkIndex(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexName, targetIndexSettings);
        assert (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings));
        IndexMetadata.selectShrinkShards(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        if (sourceMetadata.getNumberOfShards() == 1) {
            throw new IllegalArgumentException("can't shrink an index with only one shard");
        }
        IndexRoutingTable table = state.routingTable().index(sourceIndex);
        HashMap<String, AtomicInteger> nodesToNumRouting = new HashMap<String, AtomicInteger>();
        int numShards = sourceMetadata.getNumberOfShards();
        for (ShardRouting routing : table.shardsWithState(ShardRoutingState.STARTED)) {
            nodesToNumRouting.computeIfAbsent(routing.currentNodeId(), s -> new AtomicInteger(0)).incrementAndGet();
        }
        ArrayList<String> nodesToAllocateOn = new ArrayList<String>();
        for (Map.Entry entries : nodesToNumRouting.entrySet()) {
            int numAllocations = ((AtomicInteger)entries.getValue()).get();
            assert (numAllocations <= numShards) : "wait what? " + numAllocations + " is > than num shards " + numShards;
            if (numAllocations != numShards) continue;
            nodesToAllocateOn.add((String)entries.getKey());
        }
        if (nodesToAllocateOn.isEmpty()) {
            throw new IllegalStateException("index " + sourceIndex + " must have all shards allocated on the same node to shrink index");
        }
        return nodesToAllocateOn;
    }

    static void validateSplitIndex(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexName, targetIndexSettings);
        IndexMetadata.selectSplitShard(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static void validateCloneIndex(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        IndexMetadata sourceMetadata = MetadataCreateIndexService.validateResize(state, sourceIndex, targetIndexName, targetIndexSettings);
        IndexMetadata.selectCloneShard(0, sourceMetadata, IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
    }

    static IndexMetadata validateResize(ClusterState state, String sourceIndex, String targetIndexName, Settings targetIndexSettings) {
        if (state.metadata().hasIndex(targetIndexName)) {
            throw new ResourceAlreadyExistsException(state.metadata().index(targetIndexName).getIndex());
        }
        IndexMetadata sourceMetadata = state.metadata().index(sourceIndex);
        if (sourceMetadata == null) {
            throw new IndexNotFoundException(sourceIndex);
        }
        IndexAbstraction source = (IndexAbstraction)state.metadata().getIndicesLookup().get(sourceIndex);
        assert (source != null);
        if (source.getParentDataStream() != null && source.getParentDataStream().getWriteIndex().getIndex().equals((Object)sourceMetadata.getIndex())) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "cannot resize the write index [%s] for data stream [%s]", sourceIndex, source.getParentDataStream().getName()));
        }
        if (!state.blocks().indexBlocked(ClusterBlockLevel.WRITE, sourceIndex)) {
            throw new IllegalStateException("index " + sourceIndex + " must block write operations to resize index. use \"index.blocks.write=true\"");
        }
        if (IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.exists(targetIndexSettings)) {
            IndexMetadata.getRoutingFactor(sourceMetadata.getNumberOfShards(), IndexMetadata.INDEX_NUMBER_OF_SHARDS_SETTING.get(targetIndexSettings));
        }
        return sourceMetadata;
    }

    static void prepareResizeIndexSettings(ClusterState currentState, Settings.Builder indexSettingsBuilder, Index resizeSourceIndex, String resizeIntoName, ResizeType type, boolean copySettings, IndexScopedSettings indexScopedSettings) {
        String initialRecoveryIdFilter = IndexMetadata.INDEX_ROUTING_INITIAL_RECOVERY_GROUP_SETTING.getKey() + "_id";
        IndexMetadata sourceMetadata = currentState.metadata().index(resizeSourceIndex.getName());
        if (type == ResizeType.SHRINK) {
            List<String> nodesToAllocateOn = MetadataCreateIndexService.validateShrinkIndex(currentState, resizeSourceIndex.getName(), resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.put(initialRecoveryIdFilter, Strings.arrayToCommaDelimitedString((Object[])nodesToAllocateOn.toArray()));
        } else if (type == ResizeType.SPLIT) {
            MetadataCreateIndexService.validateSplitIndex(currentState, resizeSourceIndex.getName(), resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else if (type == ResizeType.CLONE) {
            MetadataCreateIndexService.validateCloneIndex(currentState, resizeSourceIndex.getName(), resizeIntoName, indexSettingsBuilder.build());
            indexSettingsBuilder.putNull(initialRecoveryIdFilter);
        } else {
            throw new IllegalStateException("unknown resize type is " + String.valueOf((Object)type));
        }
        Settings.Builder builder = Settings.builder();
        if (copySettings) {
            for (String key : sourceMetadata.getSettings().keySet()) {
                Setting<?> setting = indexScopedSettings.get(key);
                if (setting == null) {
                    assert (indexScopedSettings.isPrivateSetting(key)) : key;
                } else if (setting.getProperties().contains((Object)Setting.Property.NotCopyableOnResize)) continue;
                if (indexSettingsBuilder.keys().contains(key)) continue;
                builder.copy(key, sourceMetadata.getSettings());
            }
        } else {
            Predicate<String> sourceSettingsPredicate = s -> (s.startsWith("index.similarity.") || s.startsWith("index.analysis.") || s.startsWith("index.sort.") || s.equals("index.soft_deletes.enabled")) && !indexSettingsBuilder.keys().contains(s);
            builder.put(sourceMetadata.getSettings().filter(sourceSettingsPredicate));
        }
        indexSettingsBuilder.put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), sourceMetadata.getCreationVersion()).put("index.version.upgraded", sourceMetadata.getUpgradedVersion()).put(builder.build()).put("index.routing_partition_size", sourceMetadata.getRoutingPartitionSize()).put(IndexMetadata.INDEX_RESIZE_SOURCE_NAME.getKey(), resizeSourceIndex.getName()).put(IndexMetadata.INDEX_RESIZE_SOURCE_UUID.getKey(), resizeSourceIndex.getUUID());
    }

    public static int calculateNumRoutingShards(int numShards, Version indexVersionCreated) {
        if (indexVersionCreated.onOrAfter((Version)LegacyESVersion.V_7_0_0)) {
            int log2MaxNumShards = 10;
            int log2NumShards = 32 - Integer.numberOfLeadingZeros(numShards - 1);
            int numSplits = log2MaxNumShards - log2NumShards;
            numSplits = Math.max(1, numSplits);
            return numShards * 1 << numSplits;
        }
        return numShards;
    }

    public static void validateTranslogRetentionSettings(Settings indexSettings) {
        if (IndexSettings.INDEX_SOFT_DELETES_SETTING.get(indexSettings).booleanValue() && (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(indexSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(indexSettings))) {
            DEPRECATION_LOGGER.deprecate("translog_retention", "Translog retention settings [index.translog.retention.age] and [index.translog.retention.size] are deprecated and effectively ignored. They will be removed in a future version.", new Object[0]);
        }
    }

    public static void validateTranslogFlushIntervalSettingsForCompositeIndex(Settings requestSettings, ClusterSettings clusterSettings) {
        ByteSizeValue compositeIndexMaxFlushSize;
        if (!StarTreeIndexSettings.IS_COMPOSITE_INDEX_SETTING.exists(requestSettings) || requestSettings.get(StarTreeIndexSettings.IS_COMPOSITE_INDEX_SETTING.getKey()) == null) {
            return;
        }
        ByteSizeValue translogFlushSize = IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.get(requestSettings);
        if (translogFlushSize.compareTo(compositeIndexMaxFlushSize = clusterSettings.get(CompositeIndexSettings.COMPOSITE_INDEX_MAX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING)) > 0) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "You can configure '%s' with upto '%s' for composite index", IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey(), compositeIndexMaxFlushSize));
        }
    }

    public static Optional<String> validateTranslogFlushIntervalSettingsForCompositeIndex(Settings requestSettings, ClusterSettings clusterSettings, Settings indexSettings) {
        ByteSizeValue compositeIndexMaxFlushSize;
        if (!IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.exists(requestSettings) || requestSettings.get(IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey()) == null || !StarTreeIndexSettings.IS_COMPOSITE_INDEX_SETTING.exists(indexSettings) || indexSettings.get(StarTreeIndexSettings.IS_COMPOSITE_INDEX_SETTING.getKey()) == null) {
            return Optional.empty();
        }
        ByteSizeValue translogFlushSize = IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.get(requestSettings);
        if (translogFlushSize.compareTo(compositeIndexMaxFlushSize = clusterSettings.get(CompositeIndexSettings.COMPOSITE_INDEX_MAX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING)) > 0) {
            return Optional.of(String.format(Locale.ROOT, "You can configure '%s' with upto '%s' for composite index", IndexSettings.INDEX_TRANSLOG_FLUSH_THRESHOLD_SIZE_SETTING.getKey(), compositeIndexMaxFlushSize));
        }
        return Optional.empty();
    }

    public static void validateRefreshIntervalSettings(Settings requestSettings, ClusterSettings clusterSettings) {
        if (!IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.exists(requestSettings) || requestSettings.get(IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.getKey()) == null) {
            return;
        }
        TimeValue requestRefreshInterval = IndexSettings.INDEX_REFRESH_INTERVAL_SETTING.get(requestSettings);
        if (requestRefreshInterval.millis() == -1L) {
            return;
        }
        TimeValue clusterMinimumRefreshInterval = clusterSettings.get(IndicesService.CLUSTER_MINIMUM_INDEX_REFRESH_INTERVAL_SETTING);
        if (requestRefreshInterval.millis() < clusterMinimumRefreshInterval.millis()) {
            throw new IllegalArgumentException("invalid index.refresh_interval [" + String.valueOf(requestRefreshInterval) + "]: cannot be smaller than cluster.minimum.index.refresh_interval [" + String.valueOf(clusterMinimumRefreshInterval) + "]");
        }
    }

    static void validateTranslogDurabilitySettings(Settings requestSettings, ClusterSettings clusterSettings, Settings settings) {
        if (!RemoteStoreNodeAttribute.isRemoteDataAttributePresent(settings) && !RemoteStoreNodeService.isMigratingToRemoteStore(clusterSettings) || !IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.exists(requestSettings) || !clusterSettings.get(IndicesService.CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING).booleanValue()) {
            return;
        }
        Translog.Durability durability = IndexSettings.INDEX_TRANSLOG_DURABILITY_SETTING.get(requestSettings);
        if (durability.equals((Object)Translog.Durability.ASYNC)) {
            throw new IllegalArgumentException("index setting [index.translog.durability=async] is not allowed as cluster setting [" + IndicesService.CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING.getKey() + "=true]");
        }
    }

    void validateContext(CreateIndexClusterStateUpdateRequest request) {
        boolean isContextAllowed = FeatureFlags.isEnabled("opensearch.experimental.feature.application_templates.enabled");
        if (request.context() != null && !isContextAllowed) {
            throw new InvalidIndexContextException(request.context().name(), request.index(), "index specifies a context which cannot be used without enabling: " + SystemTemplatesService.SETTING_APPLICATION_BASED_CONFIGURATION_TEMPLATES_ENABLED.getKey());
        }
        if (request.context() != null && MetadataIndexTemplateService.findContextTemplateName(this.clusterService.state().metadata(), request.context()) == null) {
            throw new InvalidIndexContextException(request.context().name(), request.index(), "index specifies a context which is not loaded on the cluster.");
        }
    }
}

