/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import io.trino.plugin.opensearch.OpenSearchColumnHandle;
import io.trino.plugin.opensearch.OpenSearchQueryBuilder;
import io.trino.plugin.opensearch.OpenSearchSplit;
import io.trino.plugin.opensearch.OpenSearchTableHandle;
import io.trino.plugin.opensearch.client.OpenSearchClient;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

class CountQueryPageSource
implements ConnectorPageSource {
    private static final int BATCH_SIZE = 10000;
    private final long readTimeNanos;
    private long remaining;

    public CountQueryPageSource(OpenSearchClient client, OpenSearchTableHandle table, OpenSearchSplit split) {
        Objects.requireNonNull(client, "client is null");
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(split, "split is null");
        long start = System.nanoTime();
        long count = client.count(split.index(), split.shard(), OpenSearchQueryBuilder.buildSearchQuery((TupleDomain<OpenSearchColumnHandle>)table.constraint().transformKeys(OpenSearchColumnHandle.class::cast), table.query(), table.regexes()));
        this.readTimeNanos = System.nanoTime() - start;
        if (table.limit().isPresent()) {
            count = Math.min(table.limit().getAsLong(), count);
        }
        this.remaining = count;
    }

    public boolean isFinished() {
        return this.remaining == 0L;
    }

    public SourcePage getNextSourcePage() {
        int batch = Math.toIntExact(Math.min(10000L, this.remaining));
        this.remaining -= (long)batch;
        return SourcePage.create((int)batch);
    }

    public long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    public long getCompletedBytes() {
        return 0L;
    }

    public long getMemoryUsage() {
        return 0L;
    }

    public void close() {
    }
}

