/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.opensearch.OpenSearchConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;

public final class OpenSearchSessionProperties
implements SessionPropertiesProvider {
    private static final String PROJECTION_PUSHDOWN_ENABLED = "projection_pushdown_enabled";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public OpenSearchSessionProperties(OpenSearchConfig openSearchConfig) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.booleanProperty((String)PROJECTION_PUSHDOWN_ENABLED, (String)"Read only required fields from a row type", (Boolean)openSearchConfig.isProjectionPushdownEnabled(), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static boolean isProjectionPushdownEnabled(ConnectorSession session) {
        return (Boolean)session.getProperty(PROJECTION_PUSHDOWN_ENABLED, Boolean.class);
    }
}

