/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.plugin.opensearch.AwsSecurityConfig;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.params.Aws4SignerParams;
import software.amazon.awssdk.auth.signer.params.SignerChecksumParams;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.http.ContentStreamProvider;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.regions.Region;

class AwsRequestSigner
implements HttpRequestInterceptor {
    private static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    private final String serviceName;
    private final String region;
    private final AwsCredentialsProvider credentialsProvider;
    private final Aws4Signer signer;

    public AwsRequestSigner(String region, AwsSecurityConfig.DeploymentType deploymentType, AwsCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.signer = Aws4Signer.create();
        this.serviceName = switch (deploymentType) {
            default -> throw new MatchException(null, null);
            case AwsSecurityConfig.DeploymentType.SERVERLESS -> "aoss";
            case AwsSecurityConfig.DeploymentType.PROVISIONED -> "es";
        };
        this.region = region;
    }

    public void process(HttpRequest request, HttpContext context) throws IOException {
        HttpEntityEnclosingRequest enclosingRequest;
        String method = request.getRequestLine().getMethod();
        URI uri = URI.create(request.getRequestLine().getUri());
        URIBuilder uriBuilder = new URIBuilder(uri);
        TreeMap<String, List> parameters = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (NameValuePair parameter : uriBuilder.getQueryParams()) {
            parameters.computeIfAbsent(parameter.getName(), key -> new ArrayList()).add(parameter.getValue());
        }
        InputStream content = null;
        if (request instanceof HttpEntityEnclosingRequest && (enclosingRequest = (HttpEntityEnclosingRequest)request).getEntity() != null) {
            content = enclosingRequest.getEntity().getContent();
        }
        Map headers = (Map)Arrays.stream(request.getAllHeaders()).collect(ImmutableMap.toImmutableMap(NameValuePair::getName, header -> ImmutableList.of((Object)header.getValue())));
        SdkHttpFullRequest.Builder awsRequest = SdkHttpFullRequest.builder().rawQueryParameters(parameters).method(SdkHttpMethod.fromValue((String)method)).protocol("https").encodedPath(uri.getPath()).headers(headers).rawQueryParameters(parameters);
        Aws4SignerParams aws4SignerParams = Aws4SignerParams.builder().signingName(this.serviceName).signingRegion(Region.of((String)this.region)).awsCredentials(this.credentialsProvider.resolveCredentials()).checksumParams(SignerChecksumParams.builder().algorithm(Algorithm.SHA256).isStreamingRequest(false).checksumHeaderName("x-amz-content-sha256").build()).build();
        HttpHost host = (HttpHost)context.getAttribute("http.target_host");
        if (host != null) {
            awsRequest.uri(URI.create(host.toURI()));
        }
        if (content == null) {
            awsRequest.putHeader("x-amz-content-sha256", EMPTY_BODY_SHA256);
        } else {
            awsRequest.contentStreamProvider(ContentStreamProvider.fromInputStream((InputStream)content));
        }
        SdkHttpFullRequest signedRequest = this.signer.sign(awsRequest.build(), aws4SignerParams);
        Header[] newHeaders = (Header[])signedRequest.headers().entrySet().stream().map(entry -> new BasicHeader((String)entry.getKey(), (String)((List)entry.getValue()).getFirst())).toArray(Header[]::new);
        request.setHeaders(newHeaders);
        InputStream newContent = signedRequest.contentStreamProvider().stream().map(ContentStreamProvider::newStream).findAny().orElse(null);
        Preconditions.checkState((newContent == null || request instanceof HttpEntityEnclosingRequest ? 1 : 0) != 0);
        if (newContent != null) {
            BasicHttpEntity entity = new BasicHttpEntity();
            entity.setContent(newContent);
            ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)entity);
        }
    }
}

