/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.client;

import com.google.common.base.Stopwatch;
import com.google.common.base.Throwables;
import dev.failsafe.Failsafe;
import dev.failsafe.FailsafeException;
import dev.failsafe.Policy;
import dev.failsafe.RetryPolicy;
import dev.failsafe.RetryPolicyBuilder;
import dev.failsafe.event.ExecutionAttemptedEvent;
import dev.failsafe.event.ExecutionCompletedEvent;
import dev.failsafe.function.CheckedSupplier;
import io.airlift.log.Logger;
import io.airlift.stats.TimeStat;
import io.trino.plugin.opensearch.OpenSearchConfig;
import io.trino.plugin.opensearch.client.BackpressureRestClient;
import java.io.Closeable;
import java.io.IOException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.ClearScrollResponse;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.client.RequestOptions;
import org.opensearch.client.RestClientBuilder;
import org.opensearch.client.RestHighLevelClient;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.rest.RestStatus;

public class BackpressureRestHighLevelClient
implements Closeable {
    private static final Logger log = Logger.get(BackpressureRestHighLevelClient.class);
    private final RestHighLevelClient delegate;
    private final BackpressureRestClient backpressureRestClient;
    private final RetryPolicy<ActionResponse> retryPolicy;
    private final TimeStat backpressureStats;
    private final ThreadLocal<Stopwatch> stopwatch = ThreadLocal.withInitial(Stopwatch::createUnstarted);

    public BackpressureRestHighLevelClient(RestClientBuilder restClientBuilder, OpenSearchConfig config, TimeStat backpressureStats) {
        this.backpressureStats = Objects.requireNonNull(backpressureStats, "backpressureStats is null");
        this.delegate = new RestHighLevelClient(Objects.requireNonNull(restClientBuilder, "restClientBuilder is null"));
        this.backpressureRestClient = new BackpressureRestClient(this.delegate.getLowLevelClient(), config, backpressureStats);
        this.retryPolicy = ((RetryPolicyBuilder)((RetryPolicyBuilder)((RetryPolicyBuilder)RetryPolicy.builder().withMaxAttempts(-1).withMaxDuration(Duration.ofMillis(config.getMaxRetryTime().toMillis())).withBackoff(config.getBackoffInitDelay().toMillis(), config.getBackoffMaxDelay().toMillis(), ChronoUnit.MILLIS).withJitter(0.125).handleIf(BackpressureRestHighLevelClient::isBackpressure)).onFailedAttempt(this::onFailedAttempt).onSuccess(this::onComplete)).onFailure(this::onComplete)).build();
    }

    public BackpressureRestClient getLowLevelClient() {
        return this.backpressureRestClient;
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    public SearchResponse search(SearchRequest searchRequest) throws IOException {
        return (SearchResponse)this.executeWithRetries(() -> this.delegate.search(searchRequest, RequestOptions.DEFAULT));
    }

    public SearchResponse searchScroll(SearchScrollRequest searchScrollRequest) throws IOException {
        return (SearchResponse)this.executeWithRetries(() -> this.delegate.scroll(searchScrollRequest, RequestOptions.DEFAULT));
    }

    public ClearScrollResponse clearScroll(ClearScrollRequest clearScrollRequest) throws IOException {
        return (ClearScrollResponse)this.executeWithRetries(() -> this.delegate.clearScroll(clearScrollRequest, RequestOptions.DEFAULT));
    }

    private static boolean isBackpressure(Throwable throwable) {
        OpenSearchStatusException openSearchStatusException;
        return throwable instanceof OpenSearchStatusException && (openSearchStatusException = (OpenSearchStatusException)throwable).status() == RestStatus.TOO_MANY_REQUESTS;
    }

    private void onComplete(ExecutionCompletedEvent<ActionResponse> executionCompletedEvent) {
        if (this.stopwatch.get().isRunning()) {
            long delayMillis = this.stopwatch.get().elapsed(TimeUnit.MILLISECONDS);
            log.debug("Adding %s milliseconds to backpressure stats", new Object[]{delayMillis});
            this.stopwatch.get().reset();
            this.backpressureStats.add((double)delayMillis, TimeUnit.MILLISECONDS);
        }
    }

    private <T extends ActionResponse> T executeWithRetries(CheckedSupplier<T> supplier) throws IOException {
        try {
            return (T)((ActionResponse)Failsafe.with(this.retryPolicy, (Policy[])new RetryPolicy[0]).get(supplier));
        }
        catch (FailsafeException e) {
            Throwable throwable = e.getCause();
            Throwables.throwIfInstanceOf((Throwable)throwable, IOException.class);
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException("Unexpected cause from FailsafeException", throwable);
        }
    }

    private void onFailedAttempt(ExecutionAttemptedEvent<ActionResponse> executionAttemptedEvent) {
        log.debug("REST attempt failed: %s", new Object[]{executionAttemptedEvent.getLastException()});
        if (!this.stopwatch.get().isRunning()) {
            this.stopwatch.get().start();
        }
    }
}

