/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.opensearch.decoders;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.primitives.Longs;
import io.trino.plugin.opensearch.DecoderDescriptor;
import io.trino.plugin.opensearch.decoders.Decoder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.TimestampType;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.function.Supplier;
import org.opensearch.common.document.DocumentField;
import org.opensearch.search.SearchHit;

public class TimestampDecoder
implements Decoder {
    private final String path;

    public TimestampDecoder(String path) {
        this.path = Objects.requireNonNull(path, "path is null");
    }

    @Override
    public void decode(SearchHit hit, Supplier<Object> getter, BlockBuilder output) {
        Object value;
        DocumentField documentField = (DocumentField)hit.getFields().get(this.path);
        if (documentField != null) {
            if (documentField.getValues().size() > 1) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.TYPE_MISMATCH, String.format("Expected single value for column '%s', found: %s", this.path, documentField.getValues().size()));
            }
            value = documentField.getValue();
        } else {
            value = getter.get();
        }
        if (value == null) {
            output.appendNull();
        } else {
            LocalDateTime timestamp;
            if (value instanceof String) {
                String valueString = (String)value;
                Long epochMillis = Longs.tryParse((String)valueString);
                timestamp = epochMillis != null ? LocalDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneOffset.UTC) : DateTimeFormatter.ISO_DATE_TIME.parse((CharSequence)valueString, LocalDateTime::from);
            } else if (value instanceof Number) {
                Number number = (Number)value;
                timestamp = LocalDateTime.ofInstant(Instant.ofEpochMilli(number.longValue()), ZoneOffset.UTC);
            } else {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported representation for field '%s' of type TIMESTAMP: %s [%s]", this.path, value, value.getClass().getSimpleName()));
            }
            long epochMicros = timestamp.atOffset(ZoneOffset.UTC).toInstant().toEpochMilli() * 1000L;
            TimestampType.TIMESTAMP_MILLIS.writeLong(output, epochMicros);
        }
    }

    public static class Descriptor
    implements DecoderDescriptor {
        private final String path;

        @JsonCreator
        public Descriptor(String path) {
            this.path = path;
        }

        @JsonProperty
        public String getPath() {
            return this.path;
        }

        @Override
        public Decoder createDecoder() {
            return new TimestampDecoder(this.path);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Descriptor that = (Descriptor)o;
            return Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }
    }
}

