/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver.resource;

import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import oracle.jdbc.internal.OpaqueString;
import oracle.jdbc.spi.OracleResourceProvider;

final class ClearTextParameters
implements AutoCloseable {
    private final Map<OracleResourceProvider.Parameter, ClearText> clearTextParameters;

    private ClearTextParameters(Builder builder) {
        this.clearTextParameters = new HashMap<OracleResourceProvider.Parameter, ClearText>(builder.clearTextParameters);
    }

    Map<OracleResourceProvider.Parameter, CharSequence> getParameterValues() {
        return this.clearTextParameters.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((ClearText)entry.getValue()).getCharSequence()));
    }

    @Override
    public void close() {
        for (ClearText clearText : this.clearTextParameters.values()) {
            clearText.wipeContents();
        }
    }

    static Builder builder() {
        return new Builder();
    }

    private static final class SensitiveClearText
    implements ClearText {
        private final OpaqueString opaqueString;
        private CharBuffer charBuffer;

        private SensitiveClearText(OpaqueString opaqueString) {
            this.opaqueString = opaqueString;
        }

        @Override
        public CharSequence getCharSequence() {
            if (this.charBuffer == null) {
                this.charBuffer = CharBuffer.wrap(this.opaqueString.getChars());
            }
            return this.charBuffer;
        }

        @Override
        public void wipeContents() {
            Arrays.fill(this.charBuffer.array(), '\u0000');
            this.charBuffer = null;
        }
    }

    private static final class InsensitiveClearText
    implements ClearText {
        private final CharSequence charSequence;

        private InsensitiveClearText(CharSequence charSequence) {
            this.charSequence = charSequence;
        }

        @Override
        public CharSequence getCharSequence() {
            return this.charSequence;
        }

        @Override
        public void wipeContents() {
        }
    }

    private static interface ClearText {
        public CharSequence getCharSequence();

        public void wipeContents();
    }

    static final class Builder {
        private final Map<OracleResourceProvider.Parameter, ClearText> clearTextParameters = new HashMap<OracleResourceProvider.Parameter, ClearText>();

        Builder() {
        }

        Builder addInsensitiveValue(OracleResourceProvider.Parameter parameter, CharSequence value) {
            assert (!parameter.isSensitive()) : "Parameter is sensitive: " + String.valueOf(parameter);
            this.clearTextParameters.put(parameter, new InsensitiveClearText(value));
            return this;
        }

        Builder addSensitiveValue(OracleResourceProvider.Parameter parameter, OpaqueString value) {
            this.clearTextParameters.put(parameter, new SensitiveClearText(value));
            return this;
        }

        ClearTextParameters build() {
            return new ClearTextParameters(this);
        }
    }
}

