/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.spi.Page;
import io.trino.spi.block.Block;
import io.trino.spi.block.RowBlock;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.SourcePage;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class MergeJdbcPageSource
implements ConnectorPageSource {
    private final ConnectorPageSource delegate;
    private final List<ColumnAdaptation> columnAdaptations;

    public MergeJdbcPageSource(ConnectorPageSource delegate, List<ColumnAdaptation> columnAdaptations) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.columnAdaptations = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnAdaptations, "columnAdaptations is null"));
    }

    public long getCompletedBytes() {
        return this.delegate.getCompletedBytes();
    }

    public long getReadTimeNanos() {
        return this.delegate.getReadTimeNanos();
    }

    public boolean isFinished() {
        return this.delegate.isFinished();
    }

    public SourcePage getNextSourcePage() {
        SourcePage page = this.delegate.getNextSourcePage();
        if (page == null || this.columnAdaptations.isEmpty()) {
            return page;
        }
        return this.getColumnAdaptationsPage(page);
    }

    private SourcePage getColumnAdaptationsPage(SourcePage page) {
        Block[] blocks = new Block[this.columnAdaptations.size()];
        for (int i = 0; i < this.columnAdaptations.size(); ++i) {
            blocks[i] = this.columnAdaptations.get(i).getBlock(page);
        }
        return SourcePage.create((Page)new Page(page.getPositionCount(), blocks));
    }

    public long getMemoryUsage() {
        return this.delegate.getMemoryUsage();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public static interface ColumnAdaptation {
        public Block getBlock(SourcePage var1);
    }

    public record SourceColumn(int sourceChannel) implements ColumnAdaptation
    {
        public SourceColumn {
            Preconditions.checkArgument((sourceChannel >= 0 ? 1 : 0) != 0, (Object)"sourceChannel is negative");
        }

        @Override
        public Block getBlock(SourcePage sourcePage) {
            return sourcePage.getBlock(this.sourceChannel);
        }
    }

    public static final class MergedRowAdaptation
    implements ColumnAdaptation {
        private final List<Integer> mergeRowIdSourceChannels;

        public MergedRowAdaptation(List<Integer> mergeRowIdSourceChannels) {
            this.mergeRowIdSourceChannels = mergeRowIdSourceChannels;
        }

        @Override
        public Block getBlock(SourcePage page) {
            Objects.requireNonNull(page, "page is null");
            Block[] mergeRowIdBlocks = new Block[this.mergeRowIdSourceChannels.size()];
            for (int i = 0; i < mergeRowIdBlocks.length; ++i) {
                mergeRowIdBlocks[i] = page.getBlock(this.mergeRowIdSourceChannels.get(i).intValue());
            }
            return RowBlock.fromFieldBlocks((int)page.getPositionCount(), (Block[])mergeRowIdBlocks);
        }
    }
}

