/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.oracle.OracleConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;

public final class OracleSessionProperties
implements SessionPropertiesProvider {
    public static final String NUMBER_ROUNDING_MODE = "number_rounding_mode";
    public static final String NUMBER_DEFAULT_SCALE = "number_default_scale";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public OracleSessionProperties(OracleConfig config) {
        this.sessionProperties = ImmutableList.builder().add((Object)PropertyMetadata.enumProperty((String)NUMBER_ROUNDING_MODE, (String)"Rounding mode for Oracle NUMBER data type", RoundingMode.class, (Enum)config.getNumberRoundingMode(), (boolean)false)).add((Object)PropertyMetadata.integerProperty((String)NUMBER_DEFAULT_SCALE, (String)"Default scale for Oracle Number data type", (Integer)config.getDefaultNumberScale().orElse(null), (boolean)false)).build();
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static RoundingMode getNumberRoundingMode(ConnectorSession session) {
        return (RoundingMode)((Object)session.getProperty(NUMBER_ROUNDING_MODE, RoundingMode.class));
    }

    public static Optional<Integer> getNumberDefaultScale(ConnectorSession session) {
        return Optional.ofNullable((Integer)session.getProperty(NUMBER_DEFAULT_SCALE, Integer.class));
    }
}

