/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.oracle;

import io.trino.plugin.jdbc.JdbcTypeHandle;
import io.trino.plugin.jdbc.expression.AbstractRewriteCast;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import java.util.function.BiFunction;

public class RewriteCast
extends AbstractRewriteCast {
    public RewriteCast(BiFunction<ConnectorSession, Type, String> jdbcTypeProvider) {
        super(jdbcTypeProvider);
    }

    protected String buildCast(Type sourceType, Type targetType, String expression, String castType) {
        if (sourceType instanceof CharType) {
            CharType sourceCharType = (CharType)sourceType;
            if (targetType instanceof CharType) {
                CharType targetCharType = (CharType)targetType;
                if (sourceCharType.getLength() < targetCharType.getLength()) {
                    return expression;
                }
            }
        }
        return "CAST(%s AS %s)".formatted(expression, castType);
    }

    protected Optional<JdbcTypeHandle> toJdbcTypeHandle(JdbcTypeHandle sourceType, Type targetType) {
        if (!this.pushdownSupported(sourceType, targetType)) {
            return Optional.empty();
        }
        if (targetType instanceof CharType) {
            CharType charType = (CharType)targetType;
            return Optional.of(new JdbcTypeHandle(1, Optional.of(charType.getBaseName()), Optional.of(charType.getLength()), Optional.empty(), Optional.empty(), Optional.empty()));
        }
        if (targetType instanceof VarcharType) {
            VarcharType varcharType = (VarcharType)targetType;
            return Optional.of(new JdbcTypeHandle(12, Optional.of(varcharType.getBaseName()), varcharType.getLength(), Optional.empty(), Optional.empty(), Optional.empty()));
        }
        return Optional.empty();
    }

    private boolean pushdownSupported(JdbcTypeHandle sourceType, Type targetType) {
        VarcharType varcharType;
        if (targetType instanceof CharType) {
            CharType charType = (CharType)targetType;
            return charType.getLength() <= 500 && RewriteCast.supportedSourceTypeToCastToChar(sourceType);
        }
        if (targetType instanceof VarcharType && !(varcharType = (VarcharType)targetType).isUnbounded()) {
            return (Integer)varcharType.getLength().orElseThrow() <= 1000 && RewriteCast.supportedSourceTypeToCastToVarchar(sourceType);
        }
        return false;
    }

    private static boolean supportedSourceTypeToCastToChar(JdbcTypeHandle sourceType) {
        return switch (sourceType.jdbcType()) {
            case -15, -9, 1, 12, 2005, 2011 -> true;
            default -> false;
        };
    }

    private static boolean supportedSourceTypeToCastToVarchar(JdbcTypeHandle sourceType) {
        return switch (sourceType.jdbcType()) {
            case -9, 2, 12, 2005, 2011 -> true;
            default -> false;
        };
    }
}

