/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import io.trino.orc.metadata.statistics.BloomFilterBuilder;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.DoubleStatistics;
import io.trino.orc.metadata.statistics.NoOpBloomFilterBuilder;
import io.trino.orc.metadata.statistics.StatisticsBuilder;
import io.trino.spi.block.Block;
import io.trino.spi.type.RealType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DoubleStatisticsBuilder
implements StatisticsBuilder {
    private long nonNullValueCount;
    private boolean hasNan;
    private double minimum = Double.POSITIVE_INFINITY;
    private double maximum = Double.NEGATIVE_INFINITY;
    private final BloomFilterBuilder bloomFilterBuilder;

    public DoubleStatisticsBuilder(BloomFilterBuilder bloomFilterBuilder) {
        this.bloomFilterBuilder = Objects.requireNonNull(bloomFilterBuilder, "bloomFilterBuilder is null");
    }

    @Override
    public void addBlock(Type type, Block block) {
        for (int position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            double value = type == RealType.REAL ? (double)Float.intBitsToFloat((int)type.getLong(block, position)) : type.getDouble(block, position);
            this.addValue(value);
        }
    }

    public void addValue(double value) {
        this.addValueInternal(value);
        this.bloomFilterBuilder.addDouble(value);
    }

    public void addValue(float value) {
        this.addValueInternal(value);
        this.bloomFilterBuilder.addFloat(value);
    }

    private void addValueInternal(double value) {
        ++this.nonNullValueCount;
        if (Double.isNaN(value)) {
            this.hasNan = true;
        } else {
            this.minimum = Math.min(value, this.minimum);
            this.maximum = Math.max(value, this.maximum);
        }
    }

    private void addDoubleStatistics(long valueCount, DoubleStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMin(), this.minimum);
        this.maximum = Math.max(value.getMax(), this.maximum);
    }

    private Optional<DoubleStatistics> buildDoubleStatistics() {
        if (this.nonNullValueCount == 0L || this.hasNan) {
            return Optional.empty();
        }
        return Optional.of(new DoubleStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<DoubleStatistics> doubleStatistics = this.buildDoubleStatistics();
        return new ColumnStatistics(this.nonNullValueCount, doubleStatistics.map(s -> 9L).orElse(0L), null, null, doubleStatistics.orElse(null), null, null, null, null, null, this.bloomFilterBuilder.buildBloomFilter());
    }

    public static Optional<DoubleStatistics> mergeDoubleStatistics(List<ColumnStatistics> stats) {
        DoubleStatisticsBuilder doubleStatisticsBuilder = new DoubleStatisticsBuilder(new NoOpBloomFilterBuilder());
        for (ColumnStatistics columnStatistics : stats) {
            DoubleStatistics partialStatistics = columnStatistics.getDoubleStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            doubleStatisticsBuilder.addDoubleStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return doubleStatisticsBuilder.buildDoubleStatistics();
    }
}

