/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata.statistics;

import io.trino.orc.metadata.statistics.BloomFilterBuilder;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.LongValueStatisticsBuilder;
import io.trino.orc.metadata.statistics.NoOpBloomFilterBuilder;
import io.trino.orc.metadata.statistics.TimestampStatistics;
import io.trino.spi.block.Block;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TimestampStatisticsBuilder
implements LongValueStatisticsBuilder {
    private long nonNullValueCount;
    private long minimum = Long.MAX_VALUE;
    private long maximum = Long.MIN_VALUE;
    private final BloomFilterBuilder bloomFilterBuilder;
    private final MillisFunction millisFunction;

    public TimestampStatisticsBuilder(BloomFilterBuilder bloomFilterBuilder) {
        this(bloomFilterBuilder, Type::getLong);
    }

    public TimestampStatisticsBuilder(MillisFunction millisFunction) {
        this(new NoOpBloomFilterBuilder(), millisFunction);
    }

    public TimestampStatisticsBuilder(BloomFilterBuilder bloomFilterBuilder, MillisFunction millisFunction) {
        this.bloomFilterBuilder = Objects.requireNonNull(bloomFilterBuilder, "bloomFilterBuilder is nulll");
        this.millisFunction = Objects.requireNonNull(millisFunction, "millisFunction is null");
    }

    @Override
    public long getValueFromBlock(Type type, Block block, int position) {
        return this.millisFunction.getMillis(type, block, position);
    }

    @Override
    public void addValue(long value) {
        ++this.nonNullValueCount;
        this.minimum = Math.min(value, this.minimum);
        this.maximum = Math.max(value, this.maximum);
        this.bloomFilterBuilder.addLong(value);
    }

    private void addTimestampStatistics(long valueCount, TimestampStatistics value) {
        Objects.requireNonNull(value, "value is null");
        Objects.requireNonNull(value.getMin(), "value.getMin() is null");
        Objects.requireNonNull(value.getMax(), "value.getMax() is null");
        this.nonNullValueCount += valueCount;
        this.minimum = Math.min(value.getMin(), this.minimum);
        this.maximum = Math.max(value.getMax(), this.maximum);
    }

    private Optional<TimestampStatistics> buildTimestampStatistics() {
        if (this.nonNullValueCount == 0L) {
            return Optional.empty();
        }
        return Optional.of(new TimestampStatistics(this.minimum, this.maximum));
    }

    @Override
    public ColumnStatistics buildColumnStatistics() {
        Optional<TimestampStatistics> timestampStatistics = this.buildTimestampStatistics();
        return new ColumnStatistics(this.nonNullValueCount, timestampStatistics.map(s -> 9L).orElse(0L), null, null, null, null, null, timestampStatistics.orElse(null), null, null, this.bloomFilterBuilder.buildBloomFilter());
    }

    public static Optional<TimestampStatistics> mergeTimestampStatistics(List<ColumnStatistics> stats) {
        TimestampStatisticsBuilder timestampStatisticsBuilder = new TimestampStatisticsBuilder(new NoOpBloomFilterBuilder());
        for (ColumnStatistics columnStatistics : stats) {
            TimestampStatistics partialStatistics = columnStatistics.getTimestampStatistics();
            if (columnStatistics.getNumberOfValues() <= 0L) continue;
            if (partialStatistics == null) {
                return Optional.empty();
            }
            timestampStatisticsBuilder.addTimestampStatistics(columnStatistics.getNumberOfValues(), partialStatistics);
        }
        return timestampStatisticsBuilder.buildTimestampStatistics();
    }

    public static interface MillisFunction {
        public long getMillis(Type var1, Block var2, int var3);
    }
}

