/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.airlift.units.DataSize;
import java.util.Objects;
import java.util.Set;

public class OrcWriterOptions {
    @VisibleForTesting
    static final DataSize DEFAULT_MAX_STRING_STATISTICS_LIMIT = DataSize.ofBytes((long)64L);
    @VisibleForTesting
    static final DataSize DEFAULT_MAX_COMPRESSION_BUFFER_SIZE = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.KILOBYTE);
    private static final double DEFAULT_BLOOM_FILTER_FPP = 0.05;
    private static final DataSize DEFAULT_STRIPE_MIN_SIZE = DataSize.of((long)32L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_STRIPE_MAX_SIZE = DataSize.of((long)64L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final int DEFAULT_STRIPE_MAX_ROW_COUNT = 10000000;
    private static final int DEFAULT_ROW_GROUP_MAX_ROW_COUNT = 10000;
    private static final DataSize DEFAULT_DICTIONARY_MAX_MEMORY = DataSize.of((long)16L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private final WriterIdentification writerIdentification;
    private final DataSize stripeMinSize;
    private final DataSize stripeMaxSize;
    private final int stripeMaxRowCount;
    private final int rowGroupMaxRowCount;
    private final DataSize dictionaryMaxMemory;
    private final DataSize maxStringStatisticsLimit;
    private final DataSize maxCompressionBufferSize;
    private final Set<String> bloomFilterColumns;
    private final double bloomFilterFpp;

    public OrcWriterOptions() {
        this(WriterIdentification.TRINO, DEFAULT_STRIPE_MIN_SIZE, DEFAULT_STRIPE_MAX_SIZE, 10000000, 10000, DEFAULT_DICTIONARY_MAX_MEMORY, DEFAULT_MAX_STRING_STATISTICS_LIMIT, DEFAULT_MAX_COMPRESSION_BUFFER_SIZE, (Set<String>)ImmutableSet.of(), 0.05);
    }

    private OrcWriterOptions(WriterIdentification writerIdentification, DataSize stripeMinSize, DataSize stripeMaxSize, int stripeMaxRowCount, int rowGroupMaxRowCount, DataSize dictionaryMaxMemory, DataSize maxStringStatisticsLimit, DataSize maxCompressionBufferSize, Set<String> bloomFilterColumns, double bloomFilterFpp) {
        Objects.requireNonNull(stripeMinSize, "stripeMinSize is null");
        Objects.requireNonNull(stripeMaxSize, "stripeMaxSize is null");
        Preconditions.checkArgument((stripeMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"stripeMaxRowCount must be at least 1");
        Preconditions.checkArgument((rowGroupMaxRowCount >= 1 ? 1 : 0) != 0, (Object)"rowGroupMaxRowCount must be at least 1");
        Objects.requireNonNull(dictionaryMaxMemory, "dictionaryMaxMemory is null");
        Objects.requireNonNull(maxStringStatisticsLimit, "maxStringStatisticsLimit is null");
        Objects.requireNonNull(maxCompressionBufferSize, "maxCompressionBufferSize is null");
        Objects.requireNonNull(bloomFilterColumns, "bloomFilterColumns is null");
        Preconditions.checkArgument((bloomFilterFpp > 0.0 && bloomFilterFpp < 1.0 ? 1 : 0) != 0, (Object)"bloomFilterFpp should be > 0.0 & < 1.0");
        this.writerIdentification = Objects.requireNonNull(writerIdentification, "writerIdentification is null");
        this.stripeMinSize = stripeMinSize;
        this.stripeMaxSize = stripeMaxSize;
        this.stripeMaxRowCount = stripeMaxRowCount;
        this.rowGroupMaxRowCount = rowGroupMaxRowCount;
        this.dictionaryMaxMemory = dictionaryMaxMemory;
        this.maxStringStatisticsLimit = maxStringStatisticsLimit;
        this.maxCompressionBufferSize = maxCompressionBufferSize;
        this.bloomFilterColumns = ImmutableSet.copyOf(bloomFilterColumns);
        this.bloomFilterFpp = bloomFilterFpp;
    }

    public WriterIdentification getWriterIdentification() {
        return this.writerIdentification;
    }

    public OrcWriterOptions withWriterIdentification(WriterIdentification writerIdentification) {
        return OrcWriterOptions.builderFrom(this).setWriterIdentification(writerIdentification).build();
    }

    public DataSize getStripeMinSize() {
        return this.stripeMinSize;
    }

    public OrcWriterOptions withStripeMinSize(DataSize stripeMinSize) {
        return OrcWriterOptions.builderFrom(this).setStripeMinSize(stripeMinSize).build();
    }

    public DataSize getStripeMaxSize() {
        return this.stripeMaxSize;
    }

    public OrcWriterOptions withStripeMaxSize(DataSize stripeMaxSize) {
        return OrcWriterOptions.builderFrom(this).setStripeMaxSize(stripeMaxSize).build();
    }

    public int getStripeMaxRowCount() {
        return this.stripeMaxRowCount;
    }

    public OrcWriterOptions withStripeMaxRowCount(int stripeMaxRowCount) {
        return OrcWriterOptions.builderFrom(this).setStripeMaxRowCount(stripeMaxRowCount).build();
    }

    public int getRowGroupMaxRowCount() {
        return this.rowGroupMaxRowCount;
    }

    public OrcWriterOptions withRowGroupMaxRowCount(int rowGroupMaxRowCount) {
        return OrcWriterOptions.builderFrom(this).setRowGroupMaxRowCount(rowGroupMaxRowCount).build();
    }

    public DataSize getDictionaryMaxMemory() {
        return this.dictionaryMaxMemory;
    }

    public OrcWriterOptions withDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
        return OrcWriterOptions.builderFrom(this).setDictionaryMaxMemory(dictionaryMaxMemory).build();
    }

    public DataSize getMaxStringStatisticsLimit() {
        return this.maxStringStatisticsLimit;
    }

    public OrcWriterOptions withMaxStringStatisticsLimit(DataSize maxStringStatisticsLimit) {
        return OrcWriterOptions.builderFrom(this).setMaxStringStatisticsLimit(maxStringStatisticsLimit).build();
    }

    public DataSize getMaxCompressionBufferSize() {
        return this.maxCompressionBufferSize;
    }

    public OrcWriterOptions withMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
        return OrcWriterOptions.builderFrom(this).setMaxCompressionBufferSize(maxCompressionBufferSize).build();
    }

    public boolean isBloomFilterColumn(String columnName) {
        return this.bloomFilterColumns.contains(columnName);
    }

    public OrcWriterOptions withBloomFilterColumns(Set<String> bloomFilterColumns) {
        return OrcWriterOptions.builderFrom(this).setBloomFilterColumns(bloomFilterColumns).build();
    }

    public double getBloomFilterFpp() {
        return this.bloomFilterFpp;
    }

    public OrcWriterOptions withBloomFilterFpp(double bloomFilterFpp) {
        return OrcWriterOptions.builderFrom(this).setBloomFilterFpp(bloomFilterFpp).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("stripeMinSize", (Object)this.stripeMinSize).add("stripeMaxSize", (Object)this.stripeMaxSize).add("stripeMaxRowCount", this.stripeMaxRowCount).add("rowGroupMaxRowCount", this.rowGroupMaxRowCount).add("dictionaryMaxMemory", (Object)this.dictionaryMaxMemory).add("maxStringStatisticsLimit", (Object)this.maxStringStatisticsLimit).add("maxCompressionBufferSize", (Object)this.maxCompressionBufferSize).add("bloomFilterColumns", this.bloomFilterColumns).add("bloomFilterFpp", this.bloomFilterFpp).toString();
    }

    public static Builder builder() {
        return OrcWriterOptions.builderFrom(new OrcWriterOptions());
    }

    public static Builder builderFrom(OrcWriterOptions options) {
        return new Builder(options);
    }

    public static enum WriterIdentification {
        LEGACY_HIVE_COMPATIBLE,
        PRESTO,
        TRINO;

    }

    public static final class Builder {
        private WriterIdentification writerIdentification;
        private DataSize stripeMinSize;
        private DataSize stripeMaxSize;
        private int stripeMaxRowCount;
        private int rowGroupMaxRowCount;
        private DataSize dictionaryMaxMemory;
        private DataSize maxStringStatisticsLimit;
        private DataSize maxCompressionBufferSize;
        private Set<String> bloomFilterColumns;
        private double bloomFilterFpp;

        private Builder(OrcWriterOptions options) {
            Objects.requireNonNull(options, "options is null");
            this.writerIdentification = options.writerIdentification;
            this.stripeMinSize = options.stripeMinSize;
            this.stripeMaxSize = options.stripeMaxSize;
            this.stripeMaxRowCount = options.stripeMaxRowCount;
            this.rowGroupMaxRowCount = options.rowGroupMaxRowCount;
            this.dictionaryMaxMemory = options.dictionaryMaxMemory;
            this.maxStringStatisticsLimit = options.maxStringStatisticsLimit;
            this.maxCompressionBufferSize = options.maxCompressionBufferSize;
            this.bloomFilterColumns = ImmutableSet.copyOf(options.bloomFilterColumns);
            this.bloomFilterFpp = options.bloomFilterFpp;
        }

        public Builder setWriterIdentification(WriterIdentification writerIdentification) {
            this.writerIdentification = writerIdentification;
            return this;
        }

        public Builder setStripeMinSize(DataSize stripeMinSize) {
            this.stripeMinSize = stripeMinSize;
            return this;
        }

        public Builder setStripeMaxSize(DataSize stripeMaxSize) {
            this.stripeMaxSize = stripeMaxSize;
            return this;
        }

        public Builder setStripeMaxRowCount(int stripeMaxRowCount) {
            this.stripeMaxRowCount = stripeMaxRowCount;
            return this;
        }

        public Builder setRowGroupMaxRowCount(int rowGroupMaxRowCount) {
            this.rowGroupMaxRowCount = rowGroupMaxRowCount;
            return this;
        }

        public Builder setDictionaryMaxMemory(DataSize dictionaryMaxMemory) {
            this.dictionaryMaxMemory = dictionaryMaxMemory;
            return this;
        }

        public Builder setMaxStringStatisticsLimit(DataSize maxStringStatisticsLimit) {
            this.maxStringStatisticsLimit = maxStringStatisticsLimit;
            return this;
        }

        public Builder setMaxCompressionBufferSize(DataSize maxCompressionBufferSize) {
            this.maxCompressionBufferSize = maxCompressionBufferSize;
            return this;
        }

        public Builder setBloomFilterColumns(Set<String> bloomFilterColumns) {
            this.bloomFilterColumns = bloomFilterColumns;
            return this;
        }

        public Builder setBloomFilterFpp(double bloomFilterFpp) {
            this.bloomFilterFpp = bloomFilterFpp;
            return this;
        }

        public OrcWriterOptions build() {
            return new OrcWriterOptions(this.writerIdentification, this.stripeMinSize, this.stripeMaxSize, this.stripeMaxRowCount, this.rowGroupMaxRowCount, this.dictionaryMaxMemory, this.maxStringStatisticsLimit, this.maxCompressionBufferSize, this.bloomFilterColumns, this.bloomFilterFpp);
        }
    }
}

