/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import io.airlift.slice.SliceOutput;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.stream.OrcInputStream;
import java.io.IOException;

public final class LongDecode {
    private LongDecode() {
    }

    public static int decodeBitWidth(int n) {
        if (n >= FixedBitSizes.ONE.ordinal() && n <= FixedBitSizes.TWENTY_FOUR.ordinal()) {
            return n + 1;
        }
        if (n == FixedBitSizes.TWENTY_SIX.ordinal()) {
            return 26;
        }
        if (n == FixedBitSizes.TWENTY_EIGHT.ordinal()) {
            return 28;
        }
        if (n == FixedBitSizes.THIRTY.ordinal()) {
            return 30;
        }
        if (n == FixedBitSizes.THIRTY_TWO.ordinal()) {
            return 32;
        }
        if (n == FixedBitSizes.FORTY.ordinal()) {
            return 40;
        }
        if (n == FixedBitSizes.FORTY_EIGHT.ordinal()) {
            return 48;
        }
        if (n == FixedBitSizes.FIFTY_SIX.ordinal()) {
            return 56;
        }
        return 64;
    }

    public static int getClosestFixedBits(int width) {
        if (width == 0) {
            return 1;
        }
        if (width >= 1 && width <= 24) {
            return width;
        }
        if (width > 24 && width <= 26) {
            return 26;
        }
        if (width > 26 && width <= 28) {
            return 28;
        }
        if (width > 28 && width <= 30) {
            return 30;
        }
        if (width > 30 && width <= 32) {
            return 32;
        }
        if (width > 32 && width <= 40) {
            return 40;
        }
        if (width > 40 && width <= 48) {
            return 48;
        }
        if (width > 48 && width <= 56) {
            return 56;
        }
        return 64;
    }

    public static long readSignedVInt(OrcInputStream inputStream) throws IOException {
        long result = LongDecode.readUnsignedVInt(inputStream);
        return LongDecode.zigzagDecode(result);
    }

    private static long readUnsignedVInt(OrcInputStream inputStream) throws IOException {
        long b;
        long result = 0L;
        int offset = 0;
        do {
            if ((b = (long)inputStream.read()) == -1L) {
                throw new OrcCorruptionException(inputStream.getOrcDataSourceId(), "EOF while reading unsigned vint");
            }
            result |= (b & 0x7FL) << offset;
            offset += 7;
        } while ((b & 0x80L) != 0L);
        return result;
    }

    public static long readVInt(boolean signed, OrcInputStream inputStream) throws IOException {
        if (signed) {
            return LongDecode.readSignedVInt(inputStream);
        }
        return LongDecode.readUnsignedVInt(inputStream);
    }

    public static long zigzagDecode(long value) {
        return value >>> 1 ^ -(value & 1L);
    }

    public static void writeVLong(SliceOutput buffer, long value, boolean signed) {
        if (signed) {
            value = LongDecode.zigzagEncode(value);
        }
        LongDecode.writeVLongUnsigned(buffer, value);
    }

    private static void writeVLongUnsigned(SliceOutput output, long value) {
        while (true) {
            if ((value & 0xFFFFFFFFFFFFFF80L) == 0L) {
                output.write((int)((byte)value));
                return;
            }
            output.write((int)((byte)(0x80L | value & 0x7FL)));
            value >>>= 7;
        }
    }

    private static long zigzagEncode(long value) {
        return value << 1 ^ value >> 63;
    }

    static enum FixedBitSizes {
        ONE,
        TWO,
        THREE,
        FOUR,
        FIVE,
        SIX,
        SEVEN,
        EIGHT,
        NINE,
        TEN,
        ELEVEN,
        TWELVE,
        THIRTEEN,
        FOURTEEN,
        FIFTEEN,
        SIXTEEN,
        SEVENTEEN,
        EIGHTEEN,
        NINETEEN,
        TWENTY,
        TWENTY_ONE,
        TWENTY_TWO,
        TWENTY_THREE,
        TWENTY_FOUR,
        TWENTY_SIX,
        TWENTY_EIGHT,
        THIRTY,
        THIRTY_TWO,
        FORTY,
        FORTY_EIGHT,
        FIFTY_SIX,
        SIXTY_FOUR;

    }
}

