/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.DataSize;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.statistics.BinaryStatisticsBuilder;
import io.trino.orc.metadata.statistics.BloomFilterBuilder;
import io.trino.orc.metadata.statistics.DateStatisticsBuilder;
import io.trino.orc.metadata.statistics.DoubleStatisticsBuilder;
import io.trino.orc.metadata.statistics.IntegerStatisticsBuilder;
import io.trino.orc.metadata.statistics.StringStatisticsBuilder;
import io.trino.orc.metadata.statistics.TimestampStatisticsBuilder;
import io.trino.orc.writer.BooleanColumnWriter;
import io.trino.orc.writer.ByteColumnWriter;
import io.trino.orc.writer.ColumnWriter;
import io.trino.orc.writer.DecimalColumnWriter;
import io.trino.orc.writer.DoubleColumnWriter;
import io.trino.orc.writer.FloatColumnWriter;
import io.trino.orc.writer.ListColumnWriter;
import io.trino.orc.writer.LongColumnWriter;
import io.trino.orc.writer.MapColumnWriter;
import io.trino.orc.writer.SliceDictionaryColumnWriter;
import io.trino.orc.writer.SliceDirectColumnWriter;
import io.trino.orc.writer.StructColumnWriter;
import io.trino.orc.writer.TimeColumnWriter;
import io.trino.orc.writer.TimestampColumnWriter;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class ColumnWriters {
    private ColumnWriters() {
    }

    public static ColumnWriter createColumnWriter(OrcColumnId columnId, ColumnMetadata<OrcType> orcTypes, Type type, CompressionKind compression, int bufferSize, DataSize stringStatisticsLimit, Supplier<BloomFilterBuilder> bloomFilterBuilder, boolean shouldCompactMinMax) {
        Objects.requireNonNull(type, "type is null");
        OrcType orcType = orcTypes.get(columnId);
        if (type instanceof TimeType) {
            TimeType timeType = (TimeType)type;
            Preconditions.checkArgument((timeType.getPrecision() == 6 ? 1 : 0) != 0, (String)"%s not supported for ORC writer", (Object)type);
            Preconditions.checkArgument((orcType.getOrcTypeKind() == OrcType.OrcTypeKind.LONG ? 1 : 0) != 0, (String)"wrong ORC type %s for type %s", (Object)orcType, (Object)type);
            Preconditions.checkArgument((boolean)"TIME".equals(orcType.getAttributes().get("iceberg.long-type")), (String)"wrong attributes %s for type %s", orcType.getAttributes(), (Object)type);
            return new TimeColumnWriter(columnId, type, compression, bufferSize, () -> new IntegerStatisticsBuilder((BloomFilterBuilder)bloomFilterBuilder.get()));
        }
        switch (orcType.getOrcTypeKind()) {
            case BOOLEAN: {
                return new BooleanColumnWriter(columnId, type, compression, bufferSize);
            }
            case FLOAT: {
                return new FloatColumnWriter(columnId, type, compression, bufferSize, () -> new DoubleStatisticsBuilder((BloomFilterBuilder)bloomFilterBuilder.get()));
            }
            case DOUBLE: {
                return new DoubleColumnWriter(columnId, type, compression, bufferSize, () -> new DoubleStatisticsBuilder((BloomFilterBuilder)bloomFilterBuilder.get()));
            }
            case BYTE: {
                return new ByteColumnWriter(columnId, type, compression, bufferSize);
            }
            case DATE: {
                return new LongColumnWriter(columnId, type, compression, bufferSize, () -> new DateStatisticsBuilder((BloomFilterBuilder)bloomFilterBuilder.get()));
            }
            case SHORT: 
            case INT: 
            case LONG: {
                return new LongColumnWriter(columnId, type, compression, bufferSize, () -> new IntegerStatisticsBuilder((BloomFilterBuilder)bloomFilterBuilder.get()));
            }
            case DECIMAL: {
                return new DecimalColumnWriter(columnId, type, compression, bufferSize);
            }
            case TIMESTAMP: 
            case TIMESTAMP_INSTANT: {
                return new TimestampColumnWriter(columnId, type, compression, bufferSize, () -> new TimestampStatisticsBuilder((BloomFilterBuilder)bloomFilterBuilder.get()));
            }
            case BINARY: {
                return new SliceDirectColumnWriter(columnId, type, compression, bufferSize, BinaryStatisticsBuilder::new);
            }
            case CHAR: 
            case VARCHAR: 
            case STRING: {
                return new SliceDictionaryColumnWriter(columnId, type, compression, bufferSize, () -> new StringStatisticsBuilder(Math.toIntExact(stringStatisticsLimit.toBytes()), (BloomFilterBuilder)bloomFilterBuilder.get(), shouldCompactMinMax));
            }
            case LIST: {
                OrcColumnId fieldColumnIndex = orcType.getFieldTypeIndex(0);
                Type fieldType = (Type)type.getTypeParameters().get(0);
                ColumnWriter elementWriter = ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compression, bufferSize, stringStatisticsLimit, bloomFilterBuilder, shouldCompactMinMax);
                return new ListColumnWriter(columnId, compression, bufferSize, elementWriter);
            }
            case MAP: {
                ColumnWriter keyWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(0), orcTypes, (Type)type.getTypeParameters().get(0), compression, bufferSize, stringStatisticsLimit, bloomFilterBuilder, shouldCompactMinMax);
                ColumnWriter valueWriter = ColumnWriters.createColumnWriter(orcType.getFieldTypeIndex(1), orcTypes, (Type)type.getTypeParameters().get(1), compression, bufferSize, stringStatisticsLimit, bloomFilterBuilder, shouldCompactMinMax);
                return new MapColumnWriter(columnId, compression, bufferSize, keyWriter, valueWriter);
            }
            case STRUCT: {
                ImmutableList.Builder fieldWriters = ImmutableList.builder();
                for (int fieldId = 0; fieldId < orcType.getFieldCount(); ++fieldId) {
                    OrcColumnId fieldColumnIndex = orcType.getFieldTypeIndex(fieldId);
                    Type fieldType = (Type)type.getTypeParameters().get(fieldId);
                    fieldWriters.add((Object)ColumnWriters.createColumnWriter(fieldColumnIndex, orcTypes, fieldType, compression, bufferSize, stringStatisticsLimit, bloomFilterBuilder, shouldCompactMinMax));
                }
                return new StructColumnWriter(columnId, compression, bufferSize, (List<ColumnWriter>)fieldWriters.build());
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }
}

