/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.DecimalInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.LongInputStream;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.block.Block;
import io.trino.spi.block.Int128ArrayBlock;
import io.trino.spi.block.LongArrayBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.Int128Math;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public class DecimalColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DecimalColumnReader.class);
    private final DecimalType type;
    private final OrcColumn column;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<DecimalInputStream> decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
    @Nullable
    private DecimalInputStream decimalStream;
    private InputStreamSource<LongInputStream> scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream scaleStream;
    private boolean rowGroupOpen;
    private long[] nonNullValueTemp = new long[0];
    private final LocalMemoryContext memoryContext;

    public DecimalColumnReader(Type type, OrcColumn column, LocalMemoryContext memoryContext) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, DecimalType.class::isInstance);
        this.type = (DecimalType)type;
        this.column = Objects.requireNonNull(column, "column is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        this.seekToOffset();
        if (this.decimalStream == null && this.scaleStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = RunLengthEncodedBlock.create((Type)this.type, null, (int)this.nextBatchSize);
        } else if (this.presentStream == null) {
            this.checkDataStreamsArePresent();
            block = this.readNonNullBlock();
        } else {
            this.checkDataStreamsArePresent();
            boolean[] isNull = new boolean[this.nextBatchSize];
            int nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull);
            block = nullCount == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : RunLengthEncodedBlock.create((Type)DoubleType.DOUBLE, null, (int)this.nextBatchSize));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private void checkDataStreamsArePresent() throws OrcCorruptionException {
        if (this.decimalStream == null) {
            throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but decimal stream is missing");
        }
        if (this.scaleStream == null) {
            throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but scale stream is missing");
        }
    }

    private Block readNonNullBlock() throws IOException {
        Block block = this.type.isShort() ? this.readShortNotNullBlock() : this.readLongNotNullBlock();
        return block;
    }

    private Block readShortNotNullBlock() throws IOException {
        Verify.verifyNotNull((Object)this.scaleStream);
        Verify.verifyNotNull((Object)this.decimalStream);
        long[] data = new long[this.nextBatchSize];
        this.decimalStream.nextShortDecimal(data, this.nextBatchSize);
        for (int i = 0; i < this.nextBatchSize; ++i) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            data[i] = Decimals.rescale((long)data[i], (int)((int)sourceScale), (int)this.type.getScale());
        }
        return new LongArrayBlock(this.nextBatchSize, Optional.empty(), data);
    }

    private Block readLongNotNullBlock() throws IOException {
        Verify.verifyNotNull((Object)this.decimalStream);
        Verify.verifyNotNull((Object)this.scaleStream);
        long[] data = new long[this.nextBatchSize * 2];
        this.decimalStream.nextLongDecimal(data, this.nextBatchSize);
        for (int offset = 0; offset < data.length; offset += 2) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            Int128Math.rescale((long)data[offset], (long)data[offset + 1], (int)((int)((long)this.type.getScale() - sourceScale)), (long[])data, (int)offset);
        }
        return new Int128ArrayBlock(this.nextBatchSize, Optional.empty(), data);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Block block = this.type.isShort() ? this.readShortNullBlock(isNull, nonNullCount) : this.readLongNullBlock(isNull, nonNullCount);
        return block;
    }

    private Block readShortNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.decimalStream);
        Verify.verifyNotNull((Object)this.scaleStream);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.nonNullValueTemp.length < minNonNullValueSize) {
            this.nonNullValueTemp = new long[minNonNullValueSize];
            this.memoryContext.setBytes(SizeOf.sizeOf((long[])this.nonNullValueTemp));
        }
        this.decimalStream.nextShortDecimal(this.nonNullValueTemp, nonNullCount);
        for (int i = 0; i < nonNullCount; ++i) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            this.nonNullValueTemp[i] = Decimals.rescale((long)this.nonNullValueTemp[i], (int)((int)sourceScale), (int)this.type.getScale());
        }
        long[] result = ReaderUtils.unpackLongNulls(this.nonNullValueTemp, isNull);
        return new LongArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private Block readLongNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.decimalStream);
        Verify.verifyNotNull((Object)this.scaleStream);
        int minTempSize = ReaderUtils.minNonNullValueSize(nonNullCount) * 2;
        if (this.nonNullValueTemp.length < minTempSize) {
            this.nonNullValueTemp = new long[minTempSize];
            this.memoryContext.setBytes(SizeOf.sizeOf((long[])this.nonNullValueTemp));
        }
        this.decimalStream.nextLongDecimal(this.nonNullValueTemp, nonNullCount);
        for (int offset = 0; offset < nonNullCount * 2; offset += 2) {
            long sourceScale = this.scaleStream.next();
            if (sourceScale == (long)this.type.getScale()) continue;
            Int128Math.rescale((long)this.nonNullValueTemp[offset], (long)this.nonNullValueTemp[offset + 1], (int)((int)((long)this.type.getScale() - sourceScale)), (long[])this.nonNullValueTemp, (int)offset);
        }
        long[] result = ReaderUtils.unpackInt128Nulls(this.nonNullValueTemp, isNull);
        return new Int128ArrayBlock(this.nextBatchSize, Optional.of(isNull), result);
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.decimalStream = this.decimalStreamSource.openStream();
        this.scaleStream = this.scaleStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private void seekToOffset() throws IOException {
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                this.checkDataStreamsArePresent();
                Verify.verifyNotNull((Object)this.decimalStream);
                Verify.verifyNotNull((Object)this.scaleStream);
                this.decimalStream.skip(this.readOffset);
                this.scaleStream.skip(this.readOffset);
            }
        }
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.decimalStreamSource = MissingInputStreamSource.missingStreamSource(DecimalInputStream.class);
        this.scaleStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.decimalStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, DecimalInputStream.class);
        this.scaleStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.SECONDARY, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.decimalStream = null;
        this.scaleStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
        this.memoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return INSTANCE_SIZE;
    }
}

