/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import io.trino.orc.OrcCorruptionException;
import io.trino.orc.checkpoint.LongStreamCheckpoint;
import io.trino.orc.checkpoint.LongStreamV1Checkpoint;
import io.trino.orc.stream.LongDecode;
import io.trino.orc.stream.LongInputStream;
import io.trino.orc.stream.OrcInputStream;
import java.io.IOException;

public class LongInputStreamV1
implements LongInputStream {
    private static final int MIN_REPEAT_SIZE = 3;
    private static final int MAX_LITERAL_SIZE = 128;
    private final OrcInputStream input;
    private final boolean signed;
    private final long[] literals = new long[128];
    private int numLiterals;
    private int delta;
    private int used;
    private boolean repeat;
    private long lastReadInputCheckpoint;

    public LongInputStreamV1(OrcInputStream input, boolean signed) {
        this.input = input;
        this.signed = signed;
        this.lastReadInputCheckpoint = input.getCheckpoint();
    }

    private void readValues() throws IOException {
        this.lastReadInputCheckpoint = this.input.getCheckpoint();
        int control = this.input.read();
        if (control == -1) {
            throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Read past end of RLE integer");
        }
        if (control < 128) {
            this.numLiterals = control + 3;
            this.used = 0;
            this.repeat = true;
            int delta = this.input.read();
            if (delta == -1) {
                throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "End of stream in RLE Integer");
            }
            this.delta = (byte)delta;
            this.literals[0] = LongDecode.readVInt(this.signed, this.input);
        } else {
            this.numLiterals = 256 - control;
            this.used = 0;
            this.repeat = false;
            for (int i = 0; i < this.numLiterals; ++i) {
                this.literals[i] = LongDecode.readVInt(this.signed, this.input);
            }
        }
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues();
        }
        long result = this.repeat ? this.literals[0] + (long)(this.used++ * this.delta) : this.literals[this.used++];
        return result;
    }

    @Override
    public void next(long[] values, int items) throws IOException {
        int offset = 0;
        while (items > 0) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            int chunkSize = Math.min(this.numLiterals - this.used, items);
            if (this.repeat) {
                for (int i = 0; i < chunkSize; ++i) {
                    values[offset + i] = this.literals[0] + (long)((this.used + i) * this.delta);
                }
            } else {
                System.arraycopy(this.literals, this.used, values, offset, chunkSize);
            }
            this.used += chunkSize;
            offset += chunkSize;
            items -= chunkSize;
        }
    }

    @Override
    public void next(int[] values, int items) throws IOException {
        int offset = 0;
        while (items > 0) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            int chunkSize = Math.min(this.numLiterals - this.used, items);
            if (this.repeat) {
                for (i = 0; i < chunkSize; ++i) {
                    literal = this.literals[0] + (long)((this.used + i) * this.delta);
                    value = (int)literal;
                    if (literal != (long)value) {
                        throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decoded value out of range for a 32bit number");
                    }
                    values[offset + i] = value;
                }
            } else {
                for (i = 0; i < chunkSize; ++i) {
                    literal = this.literals[this.used + i];
                    value = (int)literal;
                    if (literal != (long)value) {
                        throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decoded value out of range for a 32bit number");
                    }
                    values[offset + i] = value;
                }
            }
            this.used += chunkSize;
            offset += chunkSize;
            items -= chunkSize;
        }
    }

    @Override
    public void next(short[] values, int items) throws IOException {
        int offset = 0;
        while (items > 0) {
            if (this.used == this.numLiterals) {
                this.numLiterals = 0;
                this.used = 0;
                this.readValues();
            }
            int chunkSize = Math.min(this.numLiterals - this.used, items);
            if (this.repeat) {
                for (i = 0; i < chunkSize; ++i) {
                    literal = this.literals[0] + (long)((this.used + i) * this.delta);
                    value = (short)literal;
                    if (literal != (long)value) {
                        throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decoded value out of range for a 16bit number");
                    }
                    values[offset + i] = value;
                }
            } else {
                for (i = 0; i < chunkSize; ++i) {
                    literal = this.literals[this.used + i];
                    value = (short)literal;
                    if (literal != (long)value) {
                        throw new OrcCorruptionException(this.input.getOrcDataSourceId(), "Decoded value out of range for a 16bit number");
                    }
                    values[offset + i] = value;
                }
            }
            this.used += chunkSize;
            offset += chunkSize;
            items -= chunkSize;
        }
    }

    @Override
    public void seekToCheckpoint(LongStreamCheckpoint checkpoint) throws IOException {
        LongStreamV1Checkpoint v1Checkpoint = (LongStreamV1Checkpoint)checkpoint;
        if (this.lastReadInputCheckpoint == v1Checkpoint.getInputStreamCheckpoint() && v1Checkpoint.getOffset() <= this.numLiterals) {
            this.used = v1Checkpoint.getOffset();
        } else {
            this.input.seekToCheckpoint(v1Checkpoint.getInputStreamCheckpoint());
            this.numLiterals = 0;
            this.used = 0;
            this.skip(v1Checkpoint.getOffset());
        }
    }

    @Override
    public void skip(long items) throws IOException {
        while (items > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues();
            }
            long consume = Math.min(items, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            items -= consume;
        }
    }
}

