/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.errorprone.annotations.FormatMethod;
import io.trino.orc.OrcDataSourceId;
import java.io.IOException;

public class OrcCorruptionException
extends IOException {
    public OrcCorruptionException(OrcDataSourceId orcDataSourceId, String message) {
        this(orcDataSourceId, "%s", message);
    }

    @FormatMethod
    public OrcCorruptionException(OrcDataSourceId orcDataSourceId, String messageFormat, Object ... args) {
        super(OrcCorruptionException.formatMessage(orcDataSourceId, messageFormat, args));
    }

    @FormatMethod
    public OrcCorruptionException(Throwable cause, OrcDataSourceId orcDataSourceId, String messageFormat, Object ... args) {
        super(OrcCorruptionException.formatMessage(orcDataSourceId, messageFormat, args), cause);
    }

    private static String formatMessage(OrcDataSourceId orcDataSourceId, String messageFormat, Object[] args) {
        return "Malformed ORC file. " + String.format(messageFormat, args) + " [" + orcDataSourceId + "]";
    }
}

