/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.Throwables;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperators;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Objects;

class ValidationHash {
    private static final long NULL_HASH_CODE = 7944063686788161739L;
    private static final MethodHandle MAP_HASH;
    private static final MethodHandle ARRAY_HASH;
    private static final MethodHandle ROW_HASH;
    private static final MethodHandle TIMESTAMP_HASH;
    private static final TypeOperators VALIDATION_TYPE_OPERATORS_CACHE;
    private final MethodHandle hashCodeOperator;

    public static ValidationHash createValidationHash(Type type) {
        TimestampType timestampType;
        Objects.requireNonNull(type, "type is null");
        if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            ValidationHash keyHash = ValidationHash.createValidationHash(mapType.getKeyType());
            ValidationHash valueHash = ValidationHash.createValidationHash(mapType.getValueType());
            return new ValidationHash(MAP_HASH.bindTo(mapType).bindTo(keyHash).bindTo(valueHash));
        }
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            ValidationHash elementHash = ValidationHash.createValidationHash(arrayType.getElementType());
            return new ValidationHash(ARRAY_HASH.bindTo(arrayType).bindTo(elementHash));
        }
        if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            ValidationHash[] fieldHashes = (ValidationHash[])type.getTypeParameters().stream().map(ValidationHash::createValidationHash).toArray(ValidationHash[]::new);
            return new ValidationHash(ROW_HASH.bindTo(rowType).bindTo(fieldHashes));
        }
        if (type instanceof TimestampType && (timestampType = (TimestampType)type).isShort()) {
            return new ValidationHash(TIMESTAMP_HASH);
        }
        return new ValidationHash(VALIDATION_TYPE_OPERATORS_CACHE.getHashCodeOperator(type, InvocationConvention.simpleConvention((InvocationConvention.InvocationReturnConvention)InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, (InvocationConvention.InvocationArgumentConvention[])new InvocationConvention.InvocationArgumentConvention[]{InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION_NOT_NULL})));
    }

    private ValidationHash(MethodHandle hashCodeOperator) {
        this.hashCodeOperator = Objects.requireNonNull(hashCodeOperator, "hashCodeOperator is null");
    }

    public long hash(Block block, int position) {
        if (block.isNull(position)) {
            return 7944063686788161739L;
        }
        try {
            return this.hashCodeOperator.invokeExact(block, position);
        }
        catch (Throwable throwable) {
            Throwables.throwIfUnchecked((Throwable)throwable);
            throw new RuntimeException(throwable);
        }
    }

    private static long mapSkipNullKeysHash(MapType type, ValidationHash keyHash, ValidationHash valueHash, Block block, int position) {
        SqlMap sqlMap = type.getObject(block, position);
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        long hash = 0L;
        for (int i = 0; i < sqlMap.getSize(); ++i) {
            if (rawKeyBlock.isNull(rawOffset + i)) continue;
            hash += keyHash.hash(rawKeyBlock, rawOffset + i) ^ valueHash.hash(rawValueBlock, rawOffset + i);
        }
        return hash;
    }

    private static long arrayHash(ArrayType type, ValidationHash elementHash, Block block, int position) {
        Block array = type.getObject(block, position);
        long hash = 0L;
        for (int i = 0; i < array.getPositionCount(); ++i) {
            hash = 31L * hash + elementHash.hash(array, i);
        }
        return hash;
    }

    private static long rowHash(RowType type, ValidationHash[] fieldHashes, Block block, int position) {
        SqlRow row = type.getObject(block, position);
        int rawIndex = row.getRawIndex();
        long hash = 0L;
        for (int i = 0; i < row.getFieldCount(); ++i) {
            hash = 31L * hash + fieldHashes[i].hash(row.getRawFieldBlock(i), rawIndex);
        }
        return hash;
    }

    private static long timestampHash(Block block, int position) {
        long millis = TimestampType.TIMESTAMP_MILLIS.getLong(block, position);
        if (millis > -1000L && millis < 0L) {
            millis += 1000L;
        }
        return AbstractLongType.hash((long)millis);
    }

    static {
        try {
            MAP_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "mapSkipNullKeysHash", MethodType.methodType(Long.TYPE, MapType.class, ValidationHash.class, ValidationHash.class, Block.class, Integer.TYPE));
            ARRAY_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "arrayHash", MethodType.methodType(Long.TYPE, ArrayType.class, ValidationHash.class, Block.class, Integer.TYPE));
            ROW_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "rowHash", MethodType.methodType(Long.TYPE, RowType.class, ValidationHash[].class, Block.class, Integer.TYPE));
            TIMESTAMP_HASH = MethodHandles.lookup().findStatic(ValidationHash.class, "timestampHash", MethodType.methodType(Long.TYPE, Block.class, Integer.TYPE));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        VALIDATION_TYPE_OPERATORS_CACHE = new TypeOperators();
    }
}

