/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.stream;

import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.orc.checkpoint.FloatStreamCheckpoint;
import io.trino.orc.stream.OrcInputStream;
import io.trino.orc.stream.ValueInputStream;
import java.io.IOException;

public class FloatInputStream
implements ValueInputStream<FloatStreamCheckpoint> {
    private static final int BUFFER_SIZE = 128;
    private final OrcInputStream input;
    private final byte[] buffer = new byte[512];
    private final Slice slice = Slices.wrappedBuffer((byte[])this.buffer);

    public FloatInputStream(OrcInputStream input) {
        this.input = input;
    }

    @Override
    public void seekToCheckpoint(FloatStreamCheckpoint checkpoint) throws IOException {
        this.input.seekToCheckpoint(checkpoint.getInputStreamCheckpoint());
    }

    @Override
    public void skip(long items) throws IOException {
        long length = items * 4L;
        this.input.skipFully(length);
    }

    public float next() throws IOException {
        this.input.readFully(this.buffer, 0, 4);
        return this.slice.getFloat(0);
    }

    public void next(int[] values, int items) throws IOException {
        this.input.readFully(values, 0, items);
    }
}

