/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Footer;
import io.trino.orc.metadata.Metadata;
import io.trino.orc.metadata.MetadataReader;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.PostScript;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.StripeFooter;
import io.trino.orc.metadata.statistics.BloomFilter;
import io.trino.spi.TrinoException;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;

public class ExceptionWrappingMetadataReader
implements MetadataReader {
    private final OrcDataSourceId orcDataSourceId;
    private final MetadataReader delegate;

    public ExceptionWrappingMetadataReader(OrcDataSourceId orcDataSourceId, MetadataReader delegate) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        Preconditions.checkArgument((!(delegate instanceof ExceptionWrappingMetadataReader) ? 1 : 0) != 0, (Object)"ExceptionWrappingMetadataReader cannot wrap a ExceptionWrappingMetadataReader");
    }

    @Override
    public PostScript readPostScript(InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readPostScript(inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid postscript");
        }
    }

    @Override
    public Metadata readMetadata(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readMetadata(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid file metadata");
        }
    }

    @Override
    public Footer readFooter(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readFooter(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid file footer");
        }
    }

    @Override
    public StripeFooter readStripeFooter(ColumnMetadata<OrcType> types, InputStream inputStream, ZoneId legacyFileTimeZone) throws IOException {
        try {
            return this.delegate.readStripeFooter(types, inputStream, legacyFileTimeZone);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid stripe footer");
        }
    }

    @Override
    public List<RowGroupIndex> readRowIndexes(PostScript.HiveWriterVersion hiveWriterVersion, InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readRowIndexes(hiveWriterVersion, inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid stripe row index");
        }
    }

    @Override
    public List<BloomFilter> readBloomFilterIndexes(InputStream inputStream) throws OrcCorruptionException {
        try {
            return this.delegate.readBloomFilterIndexes(inputStream);
        }
        catch (IOException | RuntimeException e) {
            throw this.propagate(e, "Invalid bloom filter");
        }
    }

    private OrcCorruptionException propagate(Throwable throwable, String message) {
        if (throwable != null) {
            Throwables.throwIfInstanceOf((Throwable)throwable, TrinoException.class);
            Throwables.throwIfUnchecked((Throwable)throwable);
        }
        return new OrcCorruptionException(throwable, this.orcDataSourceId, "%s", message);
    }
}

