/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.reader.SliceColumnReader;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.ByteArrayInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.LongInputStream;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.VariableWidthBlock;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public class SliceDictionaryColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(SliceDictionaryColumnReader.class);
    private static final byte[] EMPTY_DICTIONARY_DATA = new byte[0];
    private static final int[] EMPTY_DICTIONARY_OFFSETS = new int[2];
    private final OrcColumn column;
    private final int maxCodePointCount;
    private final boolean isCharType;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<ByteArrayInputStream> dictionaryDataStreamSource = MissingInputStreamSource.missingStreamSource(ByteArrayInputStream.class);
    private boolean dictionaryOpen;
    private int dictionarySize;
    private int[] dictionaryLength = new int[0];
    private byte[] dictionaryData = EMPTY_DICTIONARY_DATA;
    private int[] dictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
    private VariableWidthBlock dictionaryBlock = new VariableWidthBlock(1, Slices.wrappedBuffer((byte[])EMPTY_DICTIONARY_DATA), EMPTY_DICTIONARY_OFFSETS, Optional.of(new boolean[]{true}));
    private byte[] currentDictionaryData = EMPTY_DICTIONARY_DATA;
    private InputStreamSource<LongInputStream> dictionaryLengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    private InputStreamSource<LongInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream dataStream;
    private boolean rowGroupOpen;
    private int[] nonNullValueTemp = new int[0];
    private int[] nonNullPositionList = new int[0];
    private final LocalMemoryContext memoryContext;

    public SliceDictionaryColumnReader(OrcColumn column, LocalMemoryContext memoryContext, int maxCodePointCount, boolean isCharType) {
        this.maxCodePointCount = maxCodePointCount;
        this.isCharType = isCharType;
        this.column = Objects.requireNonNull(column, "column is null");
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block block;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                this.dataStream.skip(this.readOffset);
            }
        }
        if (this.dataStream == null) {
            if (this.presentStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is null but present stream is missing");
            }
            this.presentStream.skip(this.nextBatchSize);
            block = this.readAllNullsBlock();
        } else {
            boolean[] isNull;
            int nullCount;
            block = this.presentStream == null ? this.readNonNullBlock() : ((nullCount = this.presentStream.getUnsetBits(this.nextBatchSize, isNull = new boolean[this.nextBatchSize])) == 0 ? this.readNonNullBlock() : (nullCount != this.nextBatchSize ? this.readNullBlock(isNull, this.nextBatchSize - nullCount) : this.readAllNullsBlock()));
        }
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return block;
    }

    private Block readAllNullsBlock() {
        return RunLengthEncodedBlock.create((Block)new VariableWidthBlock(1, Slices.EMPTY_SLICE, new int[2], Optional.of(new boolean[]{true})), (int)this.nextBatchSize);
    }

    private Block readNonNullBlock() throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        int[] values = new int[this.nextBatchSize];
        this.dataStream.next(values, this.nextBatchSize);
        return DictionaryBlock.create((int)this.nextBatchSize, (Block)this.dictionaryBlock, (int[])values);
    }

    private Block readNullBlock(boolean[] isNull, int nonNullCount) throws IOException {
        Verify.verifyNotNull((Object)this.dataStream);
        int minNonNullValueSize = ReaderUtils.minNonNullValueSize(nonNullCount);
        if (this.nonNullValueTemp.length < minNonNullValueSize) {
            this.nonNullValueTemp = new int[minNonNullValueSize];
            this.nonNullPositionList = new int[minNonNullValueSize];
            this.memoryContext.setBytes(this.getRetainedSizeInBytes());
        }
        this.dataStream.next(this.nonNullValueTemp, nonNullCount);
        int nonNullPosition = 0;
        for (int i = 0; i < isNull.length; ++i) {
            this.nonNullPositionList[nonNullPosition] = i;
            if (isNull[i]) continue;
            ++nonNullPosition;
        }
        int[] result = new int[isNull.length];
        Arrays.fill(result, this.dictionarySize);
        for (int i = 0; i < nonNullPosition; ++i) {
            result[this.nonNullPositionList[i]] = this.nonNullValueTemp[i];
        }
        return DictionaryBlock.create((int)this.nextBatchSize, (Block)this.dictionaryBlock, (int[])result);
    }

    private void setDictionaryBlockData(byte[] dictionaryData, int[] dictionaryOffsets, int positionCount) {
        Verify.verify((positionCount > 0 ? 1 : 0) != 0);
        if (this.currentDictionaryData != dictionaryData) {
            boolean[] isNullVector = new boolean[positionCount];
            isNullVector[positionCount - 1] = true;
            dictionaryOffsets[positionCount] = dictionaryOffsets[positionCount - 1];
            this.dictionaryBlock = new VariableWidthBlock(positionCount, Slices.wrappedBuffer((byte[])dictionaryData), dictionaryOffsets, Optional.of(isNullVector));
            this.currentDictionaryData = dictionaryData;
            this.memoryContext.setBytes(this.getRetainedSizeInBytes());
        }
    }

    private void openRowGroup() throws IOException {
        if (!this.dictionaryOpen) {
            if (this.dictionarySize > 0) {
                LongInputStream lengthStream;
                if (this.dictionaryLength.length < this.dictionarySize) {
                    this.dictionaryLength = new int[this.dictionarySize];
                }
                if ((lengthStream = this.dictionaryLengthStreamSource.openStream()) == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Dictionary is not empty but dictionary length stream is missing");
                }
                lengthStream.next(this.dictionaryLength, this.dictionarySize);
                long dataLength = 0L;
                for (int i = 0; i < this.dictionarySize; ++i) {
                    dataLength += (long)this.dictionaryLength[i];
                }
                this.dictionaryData = new byte[Math.toIntExact(dataLength)];
                this.dictionaryOffsetVector = new int[this.dictionarySize + 2];
                ByteArrayInputStream dictionaryDataStream = this.dictionaryDataStreamSource.openStream();
                SliceDictionaryColumnReader.readDictionary(dictionaryDataStream, this.dictionarySize, this.dictionaryLength, 0, this.dictionaryData, this.dictionaryOffsetVector, this.maxCodePointCount, this.isCharType);
            } else {
                this.dictionaryData = EMPTY_DICTIONARY_DATA;
                this.dictionaryOffsetVector = EMPTY_DICTIONARY_OFFSETS;
            }
        }
        this.dictionaryOpen = true;
        this.setDictionaryBlockData(this.dictionaryData, this.dictionaryOffsetVector, this.dictionarySize + 1);
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    private static void readDictionary(ByteArrayInputStream dictionaryDataStream, int dictionarySize, int[] dictionaryLengthVector, int offsetVectorOffset, byte[] data, int[] offsetVector, int maxCodePointCount, boolean isCharType) throws IOException {
        Slice slice = Slices.wrappedBuffer((byte[])data);
        if (offsetVectorOffset == 0) {
            offsetVector[0] = 0;
        }
        for (int i = 0; i < dictionarySize; ++i) {
            int truncatedLength;
            int offsetIndex = offsetVectorOffset + i;
            int offset = offsetVector[offsetIndex];
            int length = dictionaryLengthVector[i];
            if (length > 0) {
                dictionaryDataStream.next(data, offset, offset + length);
                truncatedLength = SliceColumnReader.computeTruncatedLength(slice, offset, length, maxCodePointCount, isCharType);
                Verify.verify((truncatedLength >= 0 ? 1 : 0) != 0);
            } else {
                truncatedLength = 0;
            }
            offsetVector[offsetIndex + 1] = offsetVector[offsetIndex] + truncatedLength;
        }
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) {
        this.dictionaryDataStreamSource = dictionaryStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DICTIONARY_DATA, ByteArrayInputStream.class);
        this.dictionaryLengthStreamSource = dictionaryStreamSources.getInputStreamSource(this.column, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.dictionarySize = encoding.get(this.column.getColumnId()).getDictionarySize();
        this.dictionaryOpen = false;
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
        this.memoryContext.close();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.nonNullValueTemp) + SizeOf.sizeOf((int[])this.nonNullPositionList) + SizeOf.sizeOf((byte[])this.dictionaryData) + SizeOf.sizeOf((int[])this.dictionaryLength) + SizeOf.sizeOf((int[])this.dictionaryOffsetVector) + (this.currentDictionaryData == this.dictionaryData ? 0L : SizeOf.sizeOf((byte[])this.currentDictionaryData));
    }
}

