/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import io.airlift.slice.OutputStreamSliceOutput;
import io.airlift.slice.SizeOf;
import io.airlift.slice.SliceOutput;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcDataSink;
import io.trino.orc.stream.OrcDataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Objects;

public class OutputStreamOrcDataSink
implements OrcDataSink {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(OutputStreamOrcDataSink.class);
    private final OutputStreamSliceOutput output;
    private final AggregatedMemoryContext memoryContext;

    public static OutputStreamOrcDataSink create(TrinoOutputFile outputFile) throws IOException {
        AggregatedMemoryContext memoryContext = AggregatedMemoryContext.newSimpleAggregatedMemoryContext();
        return new OutputStreamOrcDataSink(outputFile.create(memoryContext), memoryContext);
    }

    private OutputStreamOrcDataSink(OutputStream outputStream, AggregatedMemoryContext memoryContext) {
        this.output = new OutputStreamSliceOutput(Objects.requireNonNull(outputStream, "outputStream is null"));
        this.memoryContext = Objects.requireNonNull(memoryContext, "memoryContext is null");
    }

    @Override
    public long size() {
        return this.output.longSize();
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.output.getRetainedSize() + this.memoryContext.getBytes();
    }

    @Override
    public void write(List<OrcDataOutput> outputData) {
        outputData.forEach(data -> data.writeData((SliceOutput)this.output));
    }

    @Override
    public void close() throws IOException {
        this.output.close();
    }
}

