/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.metadata;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CountingOutputStream;
import com.google.common.primitives.Longs;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceOutput;
import io.trino.orc.OrcWriterOptions;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.Footer;
import io.trino.orc.metadata.Metadata;
import io.trino.orc.metadata.MetadataWriter;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.OrcType;
import io.trino.orc.metadata.PostScript;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import io.trino.orc.metadata.StripeFooter;
import io.trino.orc.metadata.StripeInformation;
import io.trino.orc.metadata.statistics.BloomFilter;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.StripeStatistics;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.orc.OrcProto;
import org.apache.orc.protobuf.ByteString;
import org.apache.orc.protobuf.MessageLite;

public class OrcMetadataWriter
implements MetadataWriter {
    public static final int TRINO_WRITER_ID = 4;
    private static final int TRINO_WRITER_VERSION = 6;
    public static final int PRESTO_WRITER_ID = 2;
    private static final int HIVE_LEGACY_WRITER_VERSION = 4;
    private static final List<Integer> ORC_METADATA_VERSION = ImmutableList.of((Object)0, (Object)12);
    private final OrcWriterOptions.WriterIdentification writerIdentification;

    public OrcMetadataWriter(OrcWriterOptions.WriterIdentification writerIdentification) {
        this.writerIdentification = Objects.requireNonNull(writerIdentification, "writerIdentification is null");
    }

    @Override
    public List<Integer> getOrcMetadataVersion() {
        return ORC_METADATA_VERSION;
    }

    @Override
    public int writePostscript(SliceOutput output, int footerLength, int metadataLength, CompressionKind compression, int compressionBlockSize) throws IOException {
        OrcProto.PostScript postScriptProtobuf = OrcProto.PostScript.newBuilder().addAllVersion(ORC_METADATA_VERSION).setFooterLength((long)footerLength).setMetadataLength((long)metadataLength).setCompression(OrcMetadataWriter.toCompression(compression)).setCompressionBlockSize((long)compressionBlockSize).setWriterVersion(this.getOrcWriterVersion()).setMagic(PostScript.MAGIC.toStringUtf8()).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)postScriptProtobuf);
    }

    private int getOrcWriterVersion() {
        return switch (this.writerIdentification) {
            default -> throw new MatchException(null, null);
            case OrcWriterOptions.WriterIdentification.LEGACY_HIVE_COMPATIBLE -> 4;
            case OrcWriterOptions.WriterIdentification.TRINO -> 6;
        };
    }

    @Override
    public int writeMetadata(SliceOutput output, Metadata metadata) throws IOException {
        OrcProto.Metadata metadataProtobuf = OrcProto.Metadata.newBuilder().addAllStripeStats((Iterable)metadata.getStripeStatsList().stream().map(Optional::get).map(OrcMetadataWriter::toStripeStatistics).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)metadataProtobuf);
    }

    private static OrcProto.StripeStatistics toStripeStatistics(StripeStatistics stripeStatistics) {
        return OrcProto.StripeStatistics.newBuilder().addAllColStats((Iterable)stripeStatistics.getColumnStatistics().stream().map(OrcMetadataWriter::toColumnStatistics).collect(Collectors.toList())).build();
    }

    @Override
    public int writeFooter(SliceOutput output, Footer footer) throws IOException {
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder().setNumberOfRows(footer.getNumberOfRows()).setRowIndexStride(footer.getRowsInRowGroup().orElse(0)).addAllStripes((Iterable)footer.getStripes().stream().map(OrcMetadataWriter::toStripeInformation).collect(Collectors.toList())).addAllTypes((Iterable)footer.getTypes().stream().map(OrcMetadataWriter::toType).collect(Collectors.toList())).addAllStatistics((Iterable)footer.getFileStats().map(ColumnMetadata::stream).orElseGet(java.util.stream.Stream::empty).map(OrcMetadataWriter::toColumnStatistics).collect(Collectors.toList())).addAllMetadata((Iterable)footer.getUserMetadata().entrySet().stream().map(OrcMetadataWriter::toUserMetadata).collect(Collectors.toList()));
        this.setWriter(builder);
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)builder.build());
    }

    private void setWriter(OrcProto.Footer.Builder builder) {
        switch (this.writerIdentification) {
            case LEGACY_HIVE_COMPATIBLE: {
                return;
            }
            case TRINO: {
                builder.setWriter(4);
                return;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf((Object)this.writerIdentification));
    }

    private static OrcProto.StripeInformation toStripeInformation(StripeInformation stripe) {
        return OrcProto.StripeInformation.newBuilder().setNumberOfRows((long)stripe.getNumberOfRows()).setOffset(stripe.getOffset()).setIndexLength(stripe.getIndexLength()).setDataLength(stripe.getDataLength()).setFooterLength(stripe.getFooterLength()).build();
    }

    private static OrcProto.Type toType(OrcType type) {
        OrcProto.Type.Builder builder = OrcProto.Type.newBuilder().setKind(OrcMetadataWriter.toTypeKind(type.getOrcTypeKind())).addAllSubtypes((Iterable)type.getFieldTypeIndexes().stream().map(OrcColumnId::getId).collect(Collectors.toList())).addAllFieldNames(type.getFieldNames()).addAllAttributes(OrcMetadataWriter.toStringPairList(type.getAttributes()));
        if (type.getLength().isPresent()) {
            builder.setMaximumLength(type.getLength().get().intValue());
        }
        if (type.getPrecision().isPresent()) {
            builder.setPrecision(type.getPrecision().get().intValue());
        }
        if (type.getScale().isPresent()) {
            builder.setScale(type.getScale().get().intValue());
        }
        return builder.build();
    }

    private static OrcProto.Type.Kind toTypeKind(OrcType.OrcTypeKind orcTypeKind) {
        return switch (orcTypeKind) {
            default -> throw new MatchException(null, null);
            case OrcType.OrcTypeKind.BOOLEAN -> OrcProto.Type.Kind.BOOLEAN;
            case OrcType.OrcTypeKind.BYTE -> OrcProto.Type.Kind.BYTE;
            case OrcType.OrcTypeKind.SHORT -> OrcProto.Type.Kind.SHORT;
            case OrcType.OrcTypeKind.INT -> OrcProto.Type.Kind.INT;
            case OrcType.OrcTypeKind.LONG -> OrcProto.Type.Kind.LONG;
            case OrcType.OrcTypeKind.DECIMAL -> OrcProto.Type.Kind.DECIMAL;
            case OrcType.OrcTypeKind.FLOAT -> OrcProto.Type.Kind.FLOAT;
            case OrcType.OrcTypeKind.DOUBLE -> OrcProto.Type.Kind.DOUBLE;
            case OrcType.OrcTypeKind.STRING -> OrcProto.Type.Kind.STRING;
            case OrcType.OrcTypeKind.VARCHAR -> OrcProto.Type.Kind.VARCHAR;
            case OrcType.OrcTypeKind.CHAR -> OrcProto.Type.Kind.CHAR;
            case OrcType.OrcTypeKind.BINARY -> OrcProto.Type.Kind.BINARY;
            case OrcType.OrcTypeKind.DATE -> OrcProto.Type.Kind.DATE;
            case OrcType.OrcTypeKind.TIMESTAMP -> OrcProto.Type.Kind.TIMESTAMP;
            case OrcType.OrcTypeKind.TIMESTAMP_INSTANT -> OrcProto.Type.Kind.TIMESTAMP_INSTANT;
            case OrcType.OrcTypeKind.LIST -> OrcProto.Type.Kind.LIST;
            case OrcType.OrcTypeKind.MAP -> OrcProto.Type.Kind.MAP;
            case OrcType.OrcTypeKind.STRUCT -> OrcProto.Type.Kind.STRUCT;
            case OrcType.OrcTypeKind.UNION -> OrcProto.Type.Kind.UNION;
        };
    }

    private static List<OrcProto.StringPair> toStringPairList(Map<String, String> attributes) {
        return (List)attributes.entrySet().stream().map(entry -> OrcProto.StringPair.newBuilder().setKey((String)entry.getKey()).setValue((String)entry.getValue()).build()).collect(ImmutableList.toImmutableList());
    }

    private static OrcProto.ColumnStatistics toColumnStatistics(ColumnStatistics columnStatistics) {
        OrcProto.ColumnStatistics.Builder builder = OrcProto.ColumnStatistics.newBuilder();
        if (columnStatistics.hasNumberOfValues()) {
            builder.setNumberOfValues(columnStatistics.getNumberOfValues());
        }
        if (columnStatistics.getBooleanStatistics() != null) {
            builder.setBucketStatistics(OrcProto.BucketStatistics.newBuilder().addCount(columnStatistics.getBooleanStatistics().getTrueValueCount()).build());
        }
        if (columnStatistics.getIntegerStatistics() != null) {
            OrcProto.IntegerStatistics.Builder integerStatistics = OrcProto.IntegerStatistics.newBuilder().setMinimum(columnStatistics.getIntegerStatistics().getMin().longValue()).setMaximum(columnStatistics.getIntegerStatistics().getMax().longValue());
            if (columnStatistics.getIntegerStatistics().getSum() != null) {
                integerStatistics.setSum(columnStatistics.getIntegerStatistics().getSum().longValue());
            }
            builder.setIntStatistics(integerStatistics.build());
        }
        if (columnStatistics.getDoubleStatistics() != null) {
            builder.setDoubleStatistics(OrcProto.DoubleStatistics.newBuilder().setMinimum(columnStatistics.getDoubleStatistics().getMin().doubleValue()).setMaximum(columnStatistics.getDoubleStatistics().getMax().doubleValue()).build());
        }
        if (columnStatistics.getStringStatistics() != null) {
            OrcProto.StringStatistics.Builder statisticsBuilder = OrcProto.StringStatistics.newBuilder();
            if (columnStatistics.getStringStatistics().getMin() != null) {
                statisticsBuilder.setMinimumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMin().getBytes()));
            }
            if (columnStatistics.getStringStatistics().getMax() != null) {
                statisticsBuilder.setMaximumBytes(ByteString.copyFrom((byte[])columnStatistics.getStringStatistics().getMax().getBytes()));
            }
            statisticsBuilder.setSum(columnStatistics.getStringStatistics().getSum());
            builder.setStringStatistics(statisticsBuilder.build());
        }
        if (columnStatistics.getDateStatistics() != null) {
            builder.setDateStatistics(OrcProto.DateStatistics.newBuilder().setMinimum(columnStatistics.getDateStatistics().getMin().intValue()).setMaximum(columnStatistics.getDateStatistics().getMax().intValue()).build());
        }
        if (columnStatistics.getTimestampStatistics() != null) {
            builder.setTimestampStatistics(OrcProto.TimestampStatistics.newBuilder().setMinimumUtc(columnStatistics.getTimestampStatistics().getMin().longValue()).setMaximumUtc(columnStatistics.getTimestampStatistics().getMax().longValue()).build());
        }
        if (columnStatistics.getDecimalStatistics() != null) {
            builder.setDecimalStatistics(OrcProto.DecimalStatistics.newBuilder().setMinimum(columnStatistics.getDecimalStatistics().getMin().toString()).setMaximum(columnStatistics.getDecimalStatistics().getMax().toString()).build());
        }
        if (columnStatistics.getBinaryStatistics() != null) {
            builder.setBinaryStatistics(OrcProto.BinaryStatistics.newBuilder().setSum(columnStatistics.getBinaryStatistics().getSum()).build());
        }
        return builder.build();
    }

    private static OrcProto.UserMetadataItem toUserMetadata(Map.Entry<String, Slice> entry) {
        return OrcProto.UserMetadataItem.newBuilder().setName(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue().getBytes())).build();
    }

    @Override
    public int writeStripeFooter(SliceOutput output, StripeFooter footer) throws IOException {
        OrcProto.StripeFooter footerProtobuf = OrcProto.StripeFooter.newBuilder().addAllStreams((Iterable)footer.getStreams().stream().map(OrcMetadataWriter::toStream).collect(Collectors.toList())).addAllColumns((Iterable)footer.getColumnEncodings().stream().map(OrcMetadataWriter::toColumnEncoding).collect(Collectors.toList())).setWriterTimezone(footer.getTimeZone().getId()).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)footerProtobuf);
    }

    private static OrcProto.Stream toStream(Stream stream) {
        return OrcProto.Stream.newBuilder().setColumn(stream.getColumnId().getId()).setKind(OrcMetadataWriter.toStreamKind(stream.getStreamKind())).setLength((long)stream.getLength()).build();
    }

    private static OrcProto.Stream.Kind toStreamKind(Stream.StreamKind streamKind) {
        switch (streamKind) {
            case PRESENT: {
                return OrcProto.Stream.Kind.PRESENT;
            }
            case DATA: {
                return OrcProto.Stream.Kind.DATA;
            }
            case LENGTH: {
                return OrcProto.Stream.Kind.LENGTH;
            }
            case DICTIONARY_DATA: {
                return OrcProto.Stream.Kind.DICTIONARY_DATA;
            }
            case DICTIONARY_COUNT: {
                return OrcProto.Stream.Kind.DICTIONARY_COUNT;
            }
            case SECONDARY: {
                return OrcProto.Stream.Kind.SECONDARY;
            }
            case ROW_INDEX: {
                return OrcProto.Stream.Kind.ROW_INDEX;
            }
            case BLOOM_FILTER: {
                break;
            }
            case BLOOM_FILTER_UTF8: {
                return OrcProto.Stream.Kind.BLOOM_FILTER_UTF8;
            }
        }
        throw new IllegalArgumentException("Unsupported stream kind: " + String.valueOf((Object)streamKind));
    }

    private static OrcProto.ColumnEncoding toColumnEncoding(ColumnEncoding columnEncodings) {
        return OrcProto.ColumnEncoding.newBuilder().setKind(OrcMetadataWriter.toColumnEncoding(columnEncodings.getColumnEncodingKind())).setDictionarySize(columnEncodings.getDictionarySize()).build();
    }

    private static OrcProto.ColumnEncoding.Kind toColumnEncoding(ColumnEncoding.ColumnEncodingKind columnEncodingKind) {
        return switch (columnEncodingKind) {
            default -> throw new MatchException(null, null);
            case ColumnEncoding.ColumnEncodingKind.DIRECT -> OrcProto.ColumnEncoding.Kind.DIRECT;
            case ColumnEncoding.ColumnEncodingKind.DICTIONARY -> OrcProto.ColumnEncoding.Kind.DICTIONARY;
            case ColumnEncoding.ColumnEncodingKind.DIRECT_V2 -> OrcProto.ColumnEncoding.Kind.DIRECT_V2;
            case ColumnEncoding.ColumnEncodingKind.DICTIONARY_V2 -> OrcProto.ColumnEncoding.Kind.DICTIONARY_V2;
        };
    }

    @Override
    public int writeRowIndexes(SliceOutput output, List<RowGroupIndex> rowGroupIndexes) throws IOException {
        OrcProto.RowIndex rowIndexProtobuf = OrcProto.RowIndex.newBuilder().addAllEntry((Iterable)rowGroupIndexes.stream().map(OrcMetadataWriter::toRowGroupIndex).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)rowIndexProtobuf);
    }

    private static OrcProto.RowIndexEntry toRowGroupIndex(RowGroupIndex rowGroupIndex) {
        return OrcProto.RowIndexEntry.newBuilder().addAllPositions((Iterable)rowGroupIndex.getPositions().stream().map(Integer::longValue).collect(Collectors.toList())).setStatistics(OrcMetadataWriter.toColumnStatistics(rowGroupIndex.getColumnStatistics())).build();
    }

    @Override
    public int writeBloomFilters(SliceOutput output, List<BloomFilter> bloomFilters) throws IOException {
        OrcProto.BloomFilterIndex bloomFilterIndex = OrcProto.BloomFilterIndex.newBuilder().addAllBloomFilter((Iterable)bloomFilters.stream().map(OrcMetadataWriter::toBloomFilter).collect(Collectors.toList())).build();
        return OrcMetadataWriter.writeProtobufObject((OutputStream)output, (MessageLite)bloomFilterIndex);
    }

    private static OrcProto.BloomFilter toBloomFilter(BloomFilter bloomFilter) {
        return OrcProto.BloomFilter.newBuilder().addAllBitset((Iterable)Longs.asList((long[])bloomFilter.getBitSet())).setNumHashFunctions(bloomFilter.getNumHashFunctions()).build();
    }

    private static OrcProto.CompressionKind toCompression(CompressionKind compressionKind) {
        return switch (compressionKind) {
            default -> throw new MatchException(null, null);
            case CompressionKind.NONE -> OrcProto.CompressionKind.NONE;
            case CompressionKind.ZLIB -> OrcProto.CompressionKind.ZLIB;
            case CompressionKind.SNAPPY -> OrcProto.CompressionKind.SNAPPY;
            case CompressionKind.LZ4 -> OrcProto.CompressionKind.LZ4;
            case CompressionKind.ZSTD -> OrcProto.CompressionKind.ZSTD;
        };
    }

    private static int writeProtobufObject(OutputStream output, MessageLite object) throws IOException {
        CountingOutputStream countingOutput = new CountingOutputStream(output);
        object.writeTo((OutputStream)countingOutput);
        return Math.toIntExact(countingOutput.getCount());
    }
}

