/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import io.airlift.compress.v3.Decompressor;
import io.airlift.compress.v3.MalformedInputException;
import io.airlift.compress.v3.lz4.Lz4Decompressor;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcDecompressor;
import java.util.Objects;

class OrcLz4Decompressor
implements OrcDecompressor {
    private final OrcDataSourceId orcDataSourceId;
    private final int maxBufferSize;
    private final Decompressor decompressor = Lz4Decompressor.create();

    public OrcLz4Decompressor(OrcDataSourceId orcDataSourceId, int maxBufferSize) {
        this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public int decompress(byte[] input, int offset, int length, OrcDecompressor.OutputBuffer output) throws OrcCorruptionException {
        try {
            byte[] buffer = output.initialize(this.maxBufferSize);
            return this.decompressor.decompress(input, offset, length, buffer, 0, buffer.length);
        }
        catch (MalformedInputException e) {
            throw new OrcCorruptionException(e, this.orcDataSourceId, "Invalid compressed stream", new Object[0]);
        }
    }

    public String toString() {
        return "lz4";
    }
}

