/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.io.Closer;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.ColumnReaders;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.LongInputStream;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.block.Block;
import io.trino.spi.type.MapType;
import io.trino.spi.type.Type;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;

public class MapColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(MapColumnReader.class);
    private final MapType type;
    private final OrcColumn column;
    private final ColumnReader keyColumnReader;
    private final ColumnReader valueColumnReader;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    private InputStreamSource<LongInputStream> lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
    @Nullable
    private LongInputStream lengthStream;
    private boolean rowGroupOpen;

    public MapColumnReader(Type type, OrcColumn column, AggregatedMemoryContext memoryContext, OrcReader.FieldMapperFactory fieldMapperFactory) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, MapType.class::isInstance);
        this.type = (MapType)type;
        this.column = Objects.requireNonNull(column, "column is null");
        this.keyColumnReader = ColumnReaders.createColumnReader(this.type.getKeyType(), column.getNestedColumns().get(0), OrcReader.fullyProjectedLayout(), memoryContext, fieldMapperFactory);
        this.valueColumnReader = ColumnReaders.createColumnReader(this.type.getValueType(), column.getNestedColumns().get(1), OrcReader.fullyProjectedLayout(), memoryContext, fieldMapperFactory);
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block values;
        Block keys;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                long entrySkipSize = this.lengthStream.sum(this.readOffset);
                this.keyColumnReader.prepareNextRead(Math.toIntExact(entrySkipSize));
                this.valueColumnReader.prepareNextRead(Math.toIntExact(entrySkipSize));
            }
        }
        int[] offsetVector = new int[this.nextBatchSize + 1];
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            if (this.lengthStream == null) {
                throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is not present");
            }
            this.lengthStream.next(offsetVector, this.nextBatchSize);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                if (this.lengthStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is not present");
                }
                this.lengthStream.next(offsetVector, this.nextBatchSize - nullValues);
                ReaderUtils.unpackLengthNulls(offsetVector, nullVector, this.nextBatchSize - nullValues);
            }
        }
        int entryCount = 0;
        for (int i = 0; i < offsetVector.length - 1; ++i) {
            entryCount += offsetVector[i];
        }
        if (entryCount > 0) {
            this.keyColumnReader.prepareNextRead(entryCount);
            this.valueColumnReader.prepareNextRead(entryCount);
            keys = this.keyColumnReader.readBlock();
            values = this.valueColumnReader.readBlock();
        } else {
            keys = this.type.getKeyType().createBlockBuilder(null, 0).build();
            values = this.type.getValueType().createBlockBuilder(null, 1).build();
        }
        Block[] keyValueBlock = MapColumnReader.createKeyValueBlock(this.nextBatchSize, keys, values, offsetVector);
        ReaderUtils.convertLengthVectorToOffsetVector(offsetVector);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return this.type.createBlockFromKeyValue(Optional.ofNullable(nullVector), offsetVector, keyValueBlock[0], keyValueBlock[1]);
    }

    private static Block[] createKeyValueBlock(int positionCount, Block keys, Block values, int[] lengths) {
        if (!MapColumnReader.hasNull(keys)) {
            return new Block[]{keys, values};
        }
        IntArrayList nonNullPositions = new IntArrayList(keys.getPositionCount());
        int position = 0;
        for (int mapIndex = 0; mapIndex < positionCount; ++mapIndex) {
            int length = lengths[mapIndex];
            for (int entryIndex = 0; entryIndex < length; ++entryIndex) {
                if (keys.isNull(position)) {
                    int n = mapIndex;
                    lengths[n] = lengths[n] - 1;
                } else {
                    nonNullPositions.add(position);
                }
                ++position;
            }
        }
        Block newKeys = keys.copyPositions(nonNullPositions.elements(), 0, nonNullPositions.size());
        Block newValues = values.copyPositions(nonNullPositions.elements(), 0, nonNullPositions.size());
        return new Block[]{newKeys, newValues};
    }

    private static boolean hasNull(Block keys) {
        for (int position = 0; position < keys.getPositionCount(); ++position) {
            if (!keys.isNull(position)) continue;
            return true;
        }
        return false;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.lengthStream = this.lengthStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.lengthStreamSource = MissingInputStreamSource.missingStreamSource(LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyColumnReader.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
        this.valueColumnReader.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.lengthStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.LENGTH, LongInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.lengthStream = null;
        this.rowGroupOpen = false;
        this.keyColumnReader.startRowGroup(dataStreamSources);
        this.valueColumnReader.startRowGroup(dataStreamSources);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            closer.register(this.keyColumnReader::close);
            closer.register(this.valueColumnReader::close);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.keyColumnReader.getRetainedSizeInBytes() + this.valueColumnReader.getRetainedSizeInBytes();
    }
}

