/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.reader;

import com.google.common.base.MoreObjects;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Closer;
import io.airlift.slice.SizeOf;
import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.orc.OrcColumn;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcReader;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.ColumnMetadata;
import io.trino.orc.metadata.Stream;
import io.trino.orc.reader.ColumnReader;
import io.trino.orc.reader.ColumnReaders;
import io.trino.orc.reader.ReaderUtils;
import io.trino.orc.stream.BooleanInputStream;
import io.trino.orc.stream.ByteInputStream;
import io.trino.orc.stream.InputStreamSource;
import io.trino.orc.stream.InputStreamSources;
import io.trino.orc.stream.MissingInputStreamSource;
import io.trino.spi.block.Block;
import io.trino.spi.block.ByteArrayBlock;
import io.trino.spi.block.RowBlock;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.type.RowType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class UnionColumnReader
implements ColumnReader {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(UnionColumnReader.class);
    private final OrcColumn column;
    private final RowType type;
    private final List<ColumnReader> fieldReaders;
    private int readOffset;
    private int nextBatchSize;
    private InputStreamSource<BooleanInputStream> presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
    private InputStreamSource<ByteInputStream> dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteInputStream.class);
    @Nullable
    private BooleanInputStream presentStream;
    @Nullable
    private ByteInputStream dataStream;
    private boolean rowGroupOpen;

    UnionColumnReader(Type type, OrcColumn column, AggregatedMemoryContext memoryContext, OrcReader.FieldMapperFactory fieldMapperFactory) throws OrcCorruptionException {
        Objects.requireNonNull(type, "type is null");
        ReaderUtils.verifyStreamType(column, type, RowType.class::isInstance);
        this.type = (RowType)type;
        this.column = Objects.requireNonNull(column, "column is null");
        ImmutableList.Builder fieldReadersBuilder = ImmutableList.builder();
        List<OrcColumn> fields = column.getNestedColumns();
        for (int i = 0; i < fields.size(); ++i) {
            fieldReadersBuilder.add((Object)ColumnReaders.createColumnReader((Type)type.getTypeParameters().get(i + 1), fields.get(i), OrcReader.fullyProjectedLayout(), memoryContext, fieldMapperFactory));
        }
        this.fieldReaders = fieldReadersBuilder.build();
    }

    @Override
    public void prepareNextRead(int batchSize) {
        this.readOffset += this.nextBatchSize;
        this.nextBatchSize = batchSize;
    }

    @Override
    public Block readBlock() throws IOException {
        Block[] blocks;
        if (!this.rowGroupOpen) {
            this.openRowGroup();
        }
        if (this.readOffset > 0) {
            if (this.presentStream != null) {
                this.readOffset = this.presentStream.countBitsSet(this.readOffset);
            }
            if (this.readOffset > 0) {
                if (this.dataStream == null) {
                    throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
                }
                int[] readOffsets = new int[this.fieldReaders.size()];
                byte[] byArray = this.dataStream.next(this.readOffset);
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    byte tag;
                    byte by = tag = byArray[i];
                    readOffsets[by] = readOffsets[by] + 1;
                }
                for (int i = 0; i < this.fieldReaders.size(); ++i) {
                    this.fieldReaders.get(i).prepareNextRead(readOffsets[i]);
                }
            }
        }
        boolean[] nullVector = null;
        if (this.presentStream == null) {
            blocks = this.getBlocks(this.nextBatchSize, this.nextBatchSize, null);
        } else {
            nullVector = new boolean[this.nextBatchSize];
            int nullValues = this.presentStream.getUnsetBits(this.nextBatchSize, nullVector);
            if (nullValues != this.nextBatchSize) {
                blocks = this.getBlocks(this.nextBatchSize, this.nextBatchSize - nullValues, nullVector);
            } else {
                List typeParameters = this.type.getTypeParameters();
                blocks = new Block[typeParameters.size() + 1];
                blocks[0] = TinyintType.TINYINT.createFixedSizeBlockBuilder(0).build();
                for (int i = 0; i < typeParameters.size(); ++i) {
                    blocks[i + 1] = ((Type)typeParameters.get(i)).createBlockBuilder(null, 0).build();
                }
            }
        }
        Verify.verify((Arrays.stream(blocks).mapToInt(Block::getPositionCount).distinct().count() == 1L ? 1 : 0) != 0);
        RowBlock rowBlock = RowBlock.fromNotNullSuppressedFieldBlocks((int)this.nextBatchSize, Optional.ofNullable(nullVector), (Block[])blocks);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        return rowBlock;
    }

    private void openRowGroup() throws IOException {
        this.presentStream = this.presentStreamSource.openStream();
        this.dataStream = this.dataStreamSource.openStream();
        this.rowGroupOpen = true;
    }

    @Override
    public void startStripe(ZoneId fileTimeZone, InputStreamSources dictionaryStreamSources, ColumnMetadata<ColumnEncoding> encoding) throws IOException {
        this.presentStreamSource = MissingInputStreamSource.missingStreamSource(BooleanInputStream.class);
        this.dataStreamSource = MissingInputStreamSource.missingStreamSource(ByteInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
        for (ColumnReader fieldReader : this.fieldReaders) {
            fieldReader.startStripe(fileTimeZone, dictionaryStreamSources, encoding);
        }
    }

    @Override
    public void startRowGroup(InputStreamSources dataStreamSources) throws IOException {
        this.presentStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.PRESENT, BooleanInputStream.class);
        this.dataStreamSource = dataStreamSources.getInputStreamSource(this.column, Stream.StreamKind.DATA, ByteInputStream.class);
        this.readOffset = 0;
        this.nextBatchSize = 0;
        this.presentStream = null;
        this.dataStream = null;
        this.rowGroupOpen = false;
        for (ColumnReader fieldReader : this.fieldReaders) {
            fieldReader.startRowGroup(dataStreamSources);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.column).toString();
    }

    private Block[] getBlocks(int positionCount, int nonNullCount, boolean[] rowIsNull) throws IOException {
        boolean[][] valueIsNull;
        if (this.dataStream == null) {
            throw new OrcCorruptionException(this.column.getOrcDataSourceId(), "Value is not null but data stream is missing");
        }
        Block[] blocks = new Block[this.fieldReaders.size() + 1];
        byte[] tags = this.dataStream.next(nonNullCount);
        blocks[0] = rowIsNull == null ? new ByteArrayBlock(positionCount, Optional.empty(), tags) : ReaderUtils.toNotNullSupressedBlock(positionCount, rowIsNull, (Block)new ByteArrayBlock(nonNullCount, Optional.empty(), tags));
        for (boolean[] fieldIsNull : valueIsNull = new boolean[this.fieldReaders.size()][positionCount]) {
            Arrays.fill(fieldIsNull, true);
        }
        int[] nonNullValueCount = new int[this.fieldReaders.size()];
        for (int position = 0; position < positionCount; ++position) {
            if (rowIsNull == null || !rowIsNull[position]) continue;
            byte tag = tags[position];
            valueIsNull[tag][position] = false;
            byte by = tag;
            nonNullValueCount[by] = nonNullValueCount[by] + 1;
        }
        for (int i = 0; i < this.fieldReaders.size(); ++i) {
            Type fieldType = (Type)this.type.getTypeParameters().get(i + 1);
            if (nonNullValueCount[i] > 0) {
                ColumnReader reader = this.fieldReaders.get(i);
                reader.prepareNextRead(nonNullValueCount[i]);
                blocks[i] = ReaderUtils.toNotNullSupressedBlock(positionCount, valueIsNull[i], reader.readBlock());
                continue;
            }
            blocks[i + 1] = RunLengthEncodedBlock.create((Block)fieldType.createBlockBuilder(null, 1).appendNull().build(), (int)positionCount);
        }
        return blocks;
    }

    @Override
    public void close() {
        try (Closer closer = Closer.create();){
            for (ColumnReader structField : this.fieldReaders) {
                closer.register(structField::close);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (ColumnReader structField : this.fieldReaders) {
            retainedSizeInBytes += structField.getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }
}

